/*
 * Decompiled with CFR 0.152.
 */
package io.socol.bundleinventory.inventory;

import io.socol.bundleinventory.BundleInventoryMod;
import io.socol.bundleinventory.inventory.BundleContentSlider;
import io.socol.bundleinventory.inventory.BundleInventoryHandler;
import io.socol.bundleinventory.util.UIDrawer;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1259;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5537;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BundleInventoryScreen
extends class_465<BundleInventoryHandler> {
    private static final class_2960 SLOT_HIGHLIGHT_BACK_TEXTURE = class_2960.method_60656((String)"container/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_TEXTURE = class_2960.method_60656((String)"container/slot_highlight_front");
    private static final int MAX_TITLE_WIDTH = 120;
    private final class_5481 trimmedTitle = BundleInventoryScreen.trimTitleToWidth(this.method_25440(), 120);
    private final boolean openInventoryOnClose;
    private float currentBarOccupancy;
    private float prevBarOccupancy;
    private int scrollBarSelectedRow;
    private int scrollBarRowsCount;
    private class_1735 focusedBundleSlot = null;

    public BundleInventoryScreen(BundleInventoryHandler handler, class_1661 inventory, boolean openInventoryOnClose) {
        super((class_1703)handler, inventory, handler.getBundleTitle());
        this.openInventoryOnClose = openInventoryOnClose;
        this.field_2792 = 176;
        this.field_2779 = 114 + handler.getRowsVisible() * 18;
        this.field_25270 = this.field_2779 - 94;
        this.prevBarOccupancy = this.currentBarOccupancy = handler.getBundleInventory().getBundleContent().method_57428().floatValue();
    }

    @Nullable
    private class_1735 getBundleSlotAt(double mouseX, double mouseY) {
        for (class_1735 slot : ((BundleInventoryHandler)this.field_2797).getBundleSlots()) {
            if (!slot.method_7682() || !this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.scrollBarSelectedRow != ((BundleInventoryHandler)this.field_2797).getSelectedRow() || this.scrollBarRowsCount != ((BundleInventoryHandler)this.field_2797).getRowsCount()) {
            this.scrollBarSelectedRow = ((BundleInventoryHandler)this.field_2797).getSelectedRow();
            this.scrollBarRowsCount = ((BundleInventoryHandler)this.field_2797).getRowsCount();
            for (class_364 child : this.method_25396()) {
                if (!(child instanceof BundleContentSlider)) continue;
                BundleContentSlider scrollBar = (BundleContentSlider)child;
                if (((BundleInventoryHandler)this.field_2797).getRowsCount() < 2) {
                    scrollBar.setValue(-1.0);
                    continue;
                }
                double value = (double)((BundleInventoryHandler)this.field_2797).getSelectedRow() / (double)(((BundleInventoryHandler)this.field_2797).getRowsCount() - 1);
                scrollBar.setValue(value);
            }
        }
        this.focusedBundleSlot = this.getBundleSlotAt(mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
        this.drawMouseoverBundleTooltip(context, mouseX, mouseY);
    }

    private void drawMouseoverBundleTooltip(class_332 context, int x, int y) {
        if (this.focusedBundleSlot == null || !this.focusedBundleSlot.method_7681()) {
            return;
        }
        class_1799 focusedStack = this.focusedBundleSlot.method_7677();
        Optional tooltipData = focusedStack.method_32347();
        Boolean stickyTooltip = tooltipData.map(class_5684::method_32663).map(class_5684::method_62003).orElse(false);
        if (((BundleInventoryHandler)this.field_2797).method_34255().method_7960() || stickyTooltip.booleanValue()) {
            context.method_51437(this.field_22793, this.method_51454(focusedStack), tooltipData, x, y, (class_2960)focusedStack.method_58694(class_9334.field_54198));
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        class_9276 content;
        int x0 = (this.field_22789 - this.field_2792) / 2;
        int y0 = (this.field_22790 - this.field_2779) / 2;
        UIDrawer drawer = new UIDrawer(context).at(x0, y0);
        drawer.drawResizablePlate(this.field_2792, this.field_2779);
        drawer.move(7, 17).drawSlots(8, ((BundleInventoryHandler)this.field_2797).getRowsVisible());
        drawer.move(7, this.field_2779 - 83).drawSlots(9, 3);
        drawer.move(7, this.field_2779 - 25).drawSlots(9, 1);
        drawer.move(155, 17).drawScrollerGroove(((BundleInventoryHandler)this.field_2797).getRowsVisible() * 18);
        if (BundleInventoryMod.config().showEquipmentSlotsInBundleInventory()) {
            UIDrawer equipmentDrawer = drawer.move(-36, this.field_2779 - 108);
            equipmentDrawer.drawResizablePlate(32, 108);
            equipmentDrawer.move(7, 7).drawSlots(1, 4);
            equipmentDrawer.move(7, 83).drawSlot();
        }
        if ((content = ((BundleInventoryHandler)this.field_2797).getBundleInventory().getBundleContent()) != null) {
            int barWidth = 55;
            float barOccupancy = class_3532.method_16439((float)delta, (float)this.prevBarOccupancy, (float)this.currentBarOccupancy);
            int barProgress = class_3532.method_15386((float)(barOccupancy * (float)barWidth));
            class_1259.class_1260 barColor = class_1259.class_1260.field_5780;
            if ((double)barOccupancy > 0.9) {
                barColor = class_1259.class_1260.field_5784;
            } else if ((double)barOccupancy > 0.7) {
                barColor = class_1259.class_1260.field_5782;
            }
            drawer.move(this.field_2792 - 7 - barWidth, 8).drawBossBar(barWidth, barProgress, barColor, class_1259.class_1261.field_5791);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51430(this.field_22793, this.trimmedTitle, this.field_25267, this.field_25268, 0x404040, false);
        context.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    protected void method_64508(class_332 context) {
        super.method_64508(context);
        this.drawBundleSlotHighlightBack(context);
        for (class_1735 slot : ((BundleInventoryHandler)this.field_2797).getBundleSlots()) {
            if (!slot.method_7682()) continue;
            this.method_2385(context, slot);
        }
        this.drawBundleSlotHighlightFront(context);
    }

    private void drawBundleSlotHighlightBack(class_332 context) {
        if (this.focusedBundleSlot == null || !this.focusedBundleSlot.method_51306()) {
            return;
        }
        context.method_52706(class_1921::method_62277, SLOT_HIGHLIGHT_BACK_TEXTURE, this.focusedBundleSlot.field_7873 - 4, this.focusedBundleSlot.field_7872 - 4, 24, 24);
    }

    private void drawBundleSlotHighlightFront(class_332 context) {
        if (this.focusedBundleSlot == null || !this.focusedBundleSlot.method_51306()) {
            return;
        }
        context.method_52706(class_1921::method_62275, SLOT_HIGHLIGHT_FRONT_TEXTURE, this.focusedBundleSlot.field_7873 - 4, this.focusedBundleSlot.field_7872 - 4, 24, 24);
    }

    protected void method_2385(class_332 context, class_1735 slot) {
        if (!BundleInventoryMod.config().indicateOpenBundle()) {
            super.method_2385(context, slot);
            return;
        }
        if (this.field_22787 != null && slot instanceof BundleInventoryHandler.BundleItemSlot) {
            class_1799 stack = slot.method_7677();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof class_5537)) {
                super.method_2385(context, slot);
                return;
            }
            class_5537 bundleItem = (class_5537)class_17922;
            class_1799 openBundle = new class_1799((class_1935)bundleItem);
            class_9276.class_9277 openBundleContent = new class_9276.class_9277(new class_9276(List.of(class_1799.field_8037)));
            openBundleContent.method_64662(0);
            openBundle.method_57379(class_9334.field_49650, (Object)openBundleContent.method_57435());
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            context.method_51427(openBundle, slot.field_7873, slot.field_7872);
            context.method_51431(this.field_22787.field_1772, stack, slot.field_7873, slot.field_7872);
            context.method_51448().method_22909();
            return;
        }
        super.method_2385(context, slot);
    }

    protected void method_37432() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !((BundleInventoryHandler)this.field_2797).method_7597((class_1657)player)) {
            class_310.method_1551().method_1507(null);
            return;
        }
        ((BundleInventoryHandler)this.field_2797).tick();
        this.prevBarOccupancy = this.currentBarOccupancy;
        class_9276 content = ((BundleInventoryHandler)this.field_2797).getBundleInventory().getBundleContent();
        if (content != null) {
            float targetBarValue = content.method_57428().floatValue();
            this.currentBarOccupancy = class_3532.method_16439((float)0.5f, (float)this.currentBarOccupancy, (float)targetBarValue);
            if (targetBarValue <= 0.0f && this.currentBarOccupancy <= 0.01f) {
                this.currentBarOccupancy = 0.0f;
            }
        }
        super.method_37432();
    }

    protected void method_25426() {
        super.method_25426();
        this.scrollBarSelectedRow = -1;
        this.scrollBarRowsCount = -1;
        int x0 = (this.field_22789 - this.field_2792) / 2;
        int y0 = (this.field_22790 - this.field_2779) / 2;
        BundleContentSlider scrollBar = new BundleContentSlider(x0 + 155, y0 + 17, 14, ((BundleInventoryHandler)this.field_2797).getRowsVisible() * 18, this::updateSelectedRow);
        this.method_37063((class_364)scrollBar);
    }

    public void method_25419() {
        class_746 player = this.field_22787.field_1724;
        if (player != null) {
            ((BundleInventoryHandler)this.field_2797).close(player);
        }
        if (this.openInventoryOnClose && player != null) {
            this.field_22787.method_1507((class_437)new class_490((class_1657)player));
        } else {
            super.method_25419();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_1735 bundleSlot = this.getBundleSlotAt(mouseX, mouseY);
        if (bundleSlot != null) {
            boolean shiftClick = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344);
            class_1713 actionType = shiftClick ? class_1713.field_7794 : class_1713.field_7790;
            int slotIndex = bundleSlot.method_34266();
            ((BundleInventoryHandler)this.field_2797).handleBundleSlotAction(slotIndex, button, actionType);
            this.field_2798 = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.method_25399() != null && this.method_25397() && button == 0) {
            return this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.method_25397()) {
            this.method_25398(false);
            class_364 focused = this.method_25399();
            if (focused != null) {
                this.method_25395(null);
                return focused.method_25406(mouseX, mouseY, button);
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int x0 = (this.field_22789 - this.field_2792) / 2;
        int y0 = (this.field_22790 - this.field_2779) / 2;
        int h = 24 + ((BundleInventoryHandler)this.field_2797).getRowsVisible() * 18;
        if (mouseX >= (double)x0 && mouseX < (double)(x0 + this.field_2792) && mouseY >= (double)y0 && mouseY < (double)(y0 + h)) {
            ((BundleInventoryHandler)this.field_2797).setSelectedRow(((BundleInventoryHandler)this.field_2797).getSelectedRow() - class_3532.method_17822((double)verticalAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.focusedBundleSlot != null && this.focusedBundleSlot.method_7681() && this.field_22787 != null && this.field_22787.field_1690.field_1869.method_1417(keyCode, scanCode)) {
            int slotIndex = this.focusedBundleSlot.method_34266();
            ((BundleInventoryHandler)this.field_2797).handleBundleSlotAction(slotIndex, BundleInventoryScreen.method_25441() ? 1 : 0, class_1713.field_7795);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        boolean isOutside = super.method_2381(mouseX, mouseY, left, top, button);
        if (!isOutside) {
            return false;
        }
        if (!BundleInventoryMod.config().showEquipmentSlotsInBundleInventory()) {
            return true;
        }
        return mouseX < (double)left - 36.0 || mouseY < (double)top + (double)this.field_2792 - 108.0 || mouseX >= (double)(left - 4) || mouseY >= (double)(top + this.field_2779);
    }

    private void updateSelectedRow(double scrollBarValue) {
        int newSelectedRow = (int)((double)((BundleInventoryHandler)this.field_2797).getRowsCount() * scrollBarValue);
        this.scrollBarSelectedRow = ((BundleInventoryHandler)this.field_2797).setSelectedRow(newSelectedRow);
    }

    private static class_5481 trimTitleToWidth(class_2561 text, int width) {
        class_310 client = class_310.method_1551();
        int i = client.field_1772.method_27525((class_5348)text);
        if (i > width) {
            class_5348 trimmed = client.field_1772.method_1714((class_5348)text, width - client.field_1772.method_1727("..."));
            class_5348 result = class_5348.method_29433((class_5348[])new class_5348[]{trimmed, class_5348.method_29430((String)"...")});
            return class_2477.method_10517().method_30934(result);
        }
        return text.method_30937();
    }
}

