/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.predicate.LightSourceLightPredicate;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2096;
import net.minecraft.class_2338;
import net.minecraft.class_3922;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public record LightSourceLocationPredicate(Optional<PositionPredicate> position, Optional<class_6885<class_1959>> biomes, Optional<class_5321<class_1937>> dimension, Optional<Boolean> smokey, Optional<LightSourceLightPredicate> light, Optional<Boolean> canSeeSky) {
    public static final Codec<LightSourceLocationPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PositionPredicate.CODEC.optionalFieldOf("position").forGetter(LightSourceLocationPredicate::position), (App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("biomes").forGetter(LightSourceLocationPredicate::biomes), (App)class_5321.method_39154((class_5321)class_7924.field_41223).optionalFieldOf("dimension").forGetter(LightSourceLocationPredicate::dimension), (App)Codec.BOOL.optionalFieldOf("smokey").forGetter(LightSourceLocationPredicate::smokey), (App)LightSourceLightPredicate.CODEC.optionalFieldOf("light").forGetter(LightSourceLocationPredicate::light), (App)Codec.BOOL.optionalFieldOf("can_see_sky").forGetter(LightSourceLocationPredicate::canSeeSky)).apply((Applicative)instance, LightSourceLocationPredicate::new));

    public boolean matches(class_1937 level, double x, double y, double z) {
        if (this.position.isPresent() && !this.position.get().matches(x, y, z)) {
            return false;
        }
        if (this.dimension.isPresent() && this.dimension.get() != level.method_27983()) {
            return false;
        }
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean loaded = level.method_8477(pos);
        if (this.biomes.isEmpty() || loaded && this.biomes.get().method_40241(level.method_23753(pos))) {
            if (this.smokey.isEmpty() || loaded && this.smokey.get() == class_3922.method_23895((class_1937)level, (class_2338)pos)) {
                if (this.light.isPresent() && !this.light.get().matches(level, pos)) {
                    return false;
                }
                return this.canSeeSky.isEmpty() || this.canSeeSky.get().booleanValue() == level.method_8311(pos);
            }
            return false;
        }
        return false;
    }

    public record PositionPredicate(class_2096.class_2099 x, class_2096.class_2099 y, class_2096.class_2099 z) {
        public static final Codec<PositionPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2096.class_2099.field_45762.optionalFieldOf("x", (Object)class_2096.class_2099.field_9705).forGetter(PositionPredicate::x), (App)class_2096.class_2099.field_45762.optionalFieldOf("y", (Object)class_2096.class_2099.field_9705).forGetter(PositionPredicate::y), (App)class_2096.class_2099.field_45762.optionalFieldOf("z", (Object)class_2096.class_2099.field_9705).forGetter(PositionPredicate::z)).apply((Applicative)instance, PositionPredicate::new));

        public static Optional<PositionPredicate> of(class_2096.class_2099 x, class_2096.class_2099 y, class_2096.class_2099 z) {
            return x.method_9041() && y.method_9041() && z.method_9041() ? Optional.empty() : Optional.of(new PositionPredicate(x, y, z));
        }

        public boolean matches(double x, double y, double z) {
            return this.x.method_9047(x) && this.y.method_9047(y) && this.z.method_9047(z);
        }
    }

    public static class Builder {
        private class_2096.class_2099 x = class_2096.class_2099.field_9705;
        private class_2096.class_2099 y = class_2096.class_2099.field_9705;
        private class_2096.class_2099 z = class_2096.class_2099.field_9705;
        private Optional<class_6885<class_1959>> biomes = Optional.empty();
        private Optional<class_5321<class_1937>> dimension = Optional.empty();
        private Optional<Boolean> smokey = Optional.empty();
        private Optional<LightSourceLightPredicate> light = Optional.empty();
        private Optional<Boolean> canSeeSky = Optional.empty();

        public static Builder location() {
            return new Builder();
        }

        public static Builder inBiome(class_6880<class_1959> holder) {
            return Builder.location().biomes((class_6885<class_1959>)class_6885.method_40246((class_6880[])new class_6880[]{holder}));
        }

        public static Builder inDimension(class_5321<class_1937> resourceKey) {
            return Builder.location().dimension(resourceKey);
        }

        public static Builder atYLocation(class_2096.class_2099 doubles) {
            return Builder.location().y(doubles);
        }

        public Builder x(class_2096.class_2099 doubles) {
            this.x = doubles;
            return this;
        }

        public Builder y(class_2096.class_2099 doubles) {
            this.y = doubles;
            return this;
        }

        public Builder z(class_2096.class_2099 doubles) {
            this.z = doubles;
            return this;
        }

        public Builder biomes(class_6885<class_1959> holderSet) {
            this.biomes = Optional.of(holderSet);
            return this;
        }

        public Builder dimension(class_5321<class_1937> resourceKey) {
            this.dimension = Optional.of(resourceKey);
            return this;
        }

        public Builder light(LightSourceLightPredicate predicate) {
            this.light = Optional.of(predicate);
            return this;
        }

        public Builder smokey(boolean smokey) {
            this.smokey = Optional.of(smokey);
            return this;
        }

        public Builder canSeeSky(boolean canSeeSky) {
            this.canSeeSky = Optional.of(canSeeSky);
            return this;
        }

        public LightSourceLocationPredicate build() {
            Optional<PositionPredicate> position = PositionPredicate.of(this.x, this.y, this.z);
            return new LightSourceLocationPredicate(position, this.biomes, this.dimension, this.smokey, this.light, this.canSeeSky);
        }
    }
}

