/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.entity.luminance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record WetSensitiveEntityLuminance(List<EntityLuminance> dry, List<EntityLuminance> wet) implements EntityLuminance
{
    public static final MapCodec<WetSensitiveEntityLuminance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityLuminance.LIST_CODEC.optionalFieldOf("dry", List.of()).forGetter(WetSensitiveEntityLuminance::dry), (App)EntityLuminance.LIST_CODEC.optionalFieldOf("wet", List.of()).forGetter(WetSensitiveEntityLuminance::wet)).apply((Applicative)instance, WetSensitiveEntityLuminance::new));

    @Override
    @NotNull
    public EntityLuminance.Type type() {
        return EntityLuminance.Type.WET_SENSITIVE;
    }

    @Override
    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
        boolean submergedInWater = entity.method_5721();
        if (submergedInWater) {
            return EntityLuminance.getLuminance(itemLightSourceManager, entity, this.wet);
        }
        return EntityLuminance.getLuminance(itemLightSourceManager, entity, this.dry);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<EntityLuminance> dry = new ArrayList<EntityLuminance>();
        private final List<EntityLuminance> wet = new ArrayList<EntityLuminance>();

        @Contract(value="_ -> this")
        public Builder dry(EntityLuminance ... luminances) {
            this.dry.addAll(List.of(luminances));
            return this;
        }

        @Contract(value="_ -> this")
        public Builder dry(@NotNull List<EntityLuminance> luminances) {
            this.dry.addAll(luminances);
            return this;
        }

        @Contract(value="_ -> this")
        public Builder wet(EntityLuminance ... luminances) {
            this.wet.addAll(List.of(luminances));
            return this;
        }

        @Contract(value="_ -> this")
        public Builder wet(@NotNull List<EntityLuminance> luminances) {
            this.wet.addAll(luminances);
            return this;
        }

        @NotNull
        public WetSensitiveEntityLuminance build() {
            return new WetSensitiveEntityLuminance(List.copyOf(this.dry), List.copyOf(this.wet));
        }
    }
}

