/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.api.predicate.LightSourceLocationPredicate;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2040;
import net.minecraft.class_2050;
import net.minecraft.class_2102;
import net.minecraft.class_3735;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_9329;
import net.minecraft.class_9350;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record EntityLightSource(EntityPredicate predicate, List<EntityLuminance> luminances) {
    public static final Codec<EntityLightSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.CODEC.fieldOf("match").forGetter(EntityLightSource::predicate), (App)EntityLuminance.LIST_CODEC.fieldOf("luminance").forGetter(EntityLightSource::luminances)).apply((Applicative)instance, EntityLightSource::new));

    public @Range(from=0L, to=15L) int getLuminance(ItemLightSourceManager itemLightSourceManager, class_1297 entity) {
        if (this.predicate.test(entity)) {
            return EntityLuminance.getLuminance(itemLightSourceManager, entity, this.luminances);
        }
        return 0;
    }

    public record EntityPredicate(Optional<class_2050> entityType, Optional<LightSourceLocationPredicate> located, Optional<class_2102> effects, Optional<class_2040> flags, Optional<class_3735> equipment, Optional<EntityPredicate> vehicle, Optional<EntityPredicate> passenger, Optional<class_9350> slots, Optional<class_9329> components) {
        public static final Codec<EntityPredicate> CODEC = Codec.recursive((String)"EntityPredicate", codec -> RecordCodecBuilder.create(instance -> instance.group((App)class_2050.field_45749.optionalFieldOf("type").forGetter(EntityPredicate::entityType), (App)LightSourceLocationPredicate.CODEC.optionalFieldOf("location").forGetter(EntityPredicate::located), (App)class_2102.field_45764.optionalFieldOf("effects").forGetter(EntityPredicate::effects), (App)class_2040.field_45745.optionalFieldOf("flags").forGetter(EntityPredicate::flags), (App)class_3735.field_45744.optionalFieldOf("equipment").forGetter(EntityPredicate::equipment), (App)codec.optionalFieldOf("vehicle").forGetter(EntityPredicate::vehicle), (App)codec.optionalFieldOf("passenger").forGetter(EntityPredicate::passenger), (App)class_9350.field_49755.optionalFieldOf("slots").forGetter(EntityPredicate::slots), (App)class_9329.field_49595.optionalFieldOf("components").forGetter(EntityPredicate::components)).apply((Applicative)instance, EntityPredicate::new)));

        public boolean test(class_1297 entity) {
            if (entity == null) {
                return false;
            }
            if (this.entityType.isPresent() && !this.entityType.get().method_8925(entity.method_5864())) {
                return false;
            }
            if (this.located.isPresent() && !this.located.get().matches(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321())) {
                return false;
            }
            if (this.effects.isPresent() && !this.effects.get().method_9062(entity)) {
                return false;
            }
            if (this.flags.isPresent() && !this.flags.get().method_8892(entity)) {
                return false;
            }
            if (this.equipment.isPresent() && !this.equipment.get().method_16226(entity)) {
                return false;
            }
            if (this.vehicle.isPresent() && !this.vehicle.get().test(entity.method_5854())) {
                return false;
            }
            if (this.passenger.isPresent() && entity.method_5685().stream().noneMatch(passenger -> this.passenger.get().test((class_1297)passenger))) {
                return false;
            }
            if (this.slots.isPresent() && !this.slots.get().method_58119(entity)) {
                return false;
            }
            return this.components.isEmpty() || !this.components.get().method_57868((class_9473)entity);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Optional<class_2050> entityType = Optional.empty();
            private Optional<LightSourceLocationPredicate> located = Optional.empty();
            private Optional<class_2102> effects = Optional.empty();
            private Optional<class_2040> flags = Optional.empty();
            private Optional<class_3735> equipment = Optional.empty();
            private Optional<EntityPredicate> vehicle = Optional.empty();
            private Optional<EntityPredicate> passenger = Optional.empty();
            private Optional<class_9350> slots = Optional.empty();
            private Optional<class_9329> components = Optional.empty();

            @NotNull
            public Builder of(@NotNull class_7871<class_1299<?>> holderGetter, @NotNull class_1299<?> type) {
                this.entityType = Optional.of(class_2050.method_8929(holderGetter, type));
                return this;
            }

            @NotNull
            public Builder of(@NotNull class_7871<class_1299<?>> holderGetter, class_1299<?> ... types) {
                this.entityType = Optional.of(new class_2050((class_6885)class_6885.method_40245(class_1299::method_40124, (Object[])types)));
                return this;
            }

            @NotNull
            public Builder of(@NotNull class_7871<class_1299<?>> holderGetter, @NotNull class_6862<class_1299<?>> tag) {
                this.entityType = Optional.of(class_2050.method_8926(holderGetter, tag));
                return this;
            }

            @Contract(value="_ -> this")
            public Builder entityType(@NotNull class_2050 entityTypePredicate) {
                this.entityType = Optional.of(entityTypePredicate);
                return this;
            }

            @Contract(value="_ -> this")
            public Builder located(@NotNull LightSourceLocationPredicate.Builder builder) {
                this.located = Optional.of(builder.build());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder effects(@NotNull class_2102.class_8748 builder) {
                this.effects = builder.method_53203();
                return this;
            }

            @Contract(value="_ -> this")
            public Builder flags(@NotNull class_2040.class_2041 builder) {
                this.flags = Optional.of(builder.method_8899());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder equipment(@NotNull class_3735.class_5278 builder) {
                this.equipment = Optional.of(builder.method_27967());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder equipment(@NotNull class_3735 equipmentPredicate) {
                this.equipment = Optional.of(equipmentPredicate);
                return this;
            }

            @Contract(value="_ -> this")
            public Builder vehicle(@NotNull Builder builder) {
                this.vehicle = Optional.of(builder.build());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder passenger(@NotNull Builder builder) {
                this.passenger = Optional.of(builder.build());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder slots(@NotNull class_9350 slotsPredicate) {
                this.slots = Optional.of(slotsPredicate);
                return this;
            }

            @Contract(value="_ -> this")
            public Builder components(@NotNull class_9329.class_9330 builder) {
                return this.components(builder.method_57871());
            }

            @Contract(value="_ -> this")
            public Builder components(@NotNull class_9329 componentsPredicate) {
                this.components = Optional.of(componentsPredicate);
                return this;
            }

            @NotNull
            public EntityPredicate build() {
                return new EntityPredicate(this.entityType, this.located, this.effects, this.flags, this.equipment, this.vehicle, this.passenger, this.slots, this.components);
            }
        }
    }
}

