/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SimpleBlockRenderContext
extends AbstractRenderContext {
    public static final ThreadLocal<SimpleBlockRenderContext> POOL = ThreadLocal.withInitial(SimpleBlockRenderContext::new);
    private final class_5819 random = class_5819.method_43053();
    private class_4597 vertexConsumers;
    private class_1921 defaultRenderLayer;
    private float red;
    private float green;
    private float blue;
    private int light;
    @Nullable
    private class_1921 lastRenderLayer;
    @Nullable
    private class_4588 lastVertexConsumer;

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        class_4588 vertexConsumer;
        class_1921 renderLayer;
        RenderMaterialImpl mat = quad.material();
        BlendMode blendMode = mat.blendMode();
        class_1921 class_19212 = renderLayer = blendMode == BlendMode.DEFAULT ? this.defaultRenderLayer : blendMode.blockRenderLayer;
        if (renderLayer == this.lastRenderLayer) {
            vertexConsumer = this.lastVertexConsumer;
        } else {
            this.lastVertexConsumer = vertexConsumer = this.vertexConsumers.getBuffer(renderLayer);
            this.lastRenderLayer = renderLayer;
        }
        this.tintQuad(quad);
        this.shadeQuad(quad, mat.emissive());
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        if (quad.tintIndex() != -1) {
            float red = this.red;
            float green = this.green;
            float blue = this.blue;
            for (int i = 0; i < 4; ++i) {
                quad.color(i, class_9848.method_64602((int)quad.color(i), (float)red, (float)green, (float)blue));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int light = this.light;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), light));
            }
        }
    }

    public void bufferModel(class_4587.class_4665 entry, class_4597 vertexConsumers, class_1087 model, float red, float green, float blue, int light, int overlay, class_1920 blockView, class_2338 pos, class_2680 state) {
        this.matrices = entry;
        this.overlay = overlay;
        this.vertexConsumers = vertexConsumers;
        this.defaultRenderLayer = class_4696.method_23679((class_2680)state);
        this.red = class_3532.method_15363((float)red, (float)0.0f, (float)1.0f);
        this.green = class_3532.method_15363((float)green, (float)0.0f, (float)1.0f);
        this.blue = class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f);
        this.light = light;
        this.random.method_43052(42L);
        model.emitQuads(this.getEmitter(), blockView, pos, state, this.random, cullFace -> false);
        this.matrices = null;
        this.vertexConsumers = null;
        this.lastRenderLayer = null;
        this.lastVertexConsumer = null;
    }
}

