/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.mesh;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.MaterialViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class EncodingFormat {
    static final int HEADER_BITS = 0;
    static final int HEADER_FACE_NORMAL = 1;
    static final int HEADER_TINT_INDEX = 2;
    static final int HEADER_TAG = 3;
    public static final int HEADER_STRIDE = 4;
    static final int VERTEX_X;
    static final int VERTEX_Y;
    static final int VERTEX_Z;
    static final int VERTEX_COLOR;
    static final int VERTEX_U;
    static final int VERTEX_V;
    static final int VERTEX_LIGHTMAP;
    static final int VERTEX_NORMAL;
    public static final int VERTEX_STRIDE;
    public static final int QUAD_STRIDE;
    public static final int QUAD_STRIDE_BYTES;
    public static final int TOTAL_STRIDE;
    private static final int DIRECTION_COUNT;
    private static final int NULLABLE_DIRECTION_COUNT;
    private static final int CULL_BIT_LENGTH;
    private static final int LIGHT_BIT_LENGTH;
    private static final int NORMALS_BIT_LENGTH = 4;
    private static final int GEOMETRY_BIT_LENGTH = 3;
    private static final int MATERIAL_BIT_LENGTH;
    private static final int CULL_BIT_OFFSET = 0;
    private static final int LIGHT_BIT_OFFSET;
    private static final int NORMALS_BIT_OFFSET;
    private static final int GEOMETRY_BIT_OFFSET;
    private static final int MATERIAL_BIT_OFFSET;
    private static final int TOTAL_BIT_LENGTH;
    private static final int CULL_MASK;
    private static final int LIGHT_MASK;
    private static final int NORMALS_MASK;
    private static final int GEOMETRY_MASK;
    private static final int MATERIAL_MASK;

    private EncodingFormat() {
    }

    public static int bitMask(int bitLength, int bitOffset) {
        return (1 << bitLength) - 1 << bitOffset;
    }

    @Nullable
    static class_2350 cullFace(int bits) {
        return ModelHelper.faceFromIndex((int)((bits & CULL_MASK) >>> 0));
    }

    static int cullFace(int bits, @Nullable class_2350 face) {
        return bits & ~CULL_MASK | ModelHelper.toFaceIndex((class_2350)face) << 0;
    }

    static class_2350 lightFace(int bits) {
        return ModelHelper.faceFromIndex((int)((bits & LIGHT_MASK) >>> LIGHT_BIT_OFFSET));
    }

    static int lightFace(int bits, class_2350 face) {
        return bits & ~LIGHT_MASK | ModelHelper.toFaceIndex((class_2350)face) << LIGHT_BIT_OFFSET;
    }

    static int normalFlags(int bits) {
        return (bits & NORMALS_MASK) >>> NORMALS_BIT_OFFSET;
    }

    static int normalFlags(int bits, int normalFlags) {
        return bits & ~NORMALS_MASK | normalFlags << NORMALS_BIT_OFFSET & NORMALS_MASK;
    }

    static int geometryFlags(int bits) {
        return (bits & GEOMETRY_MASK) >>> GEOMETRY_BIT_OFFSET;
    }

    static int geometryFlags(int bits, int geometryFlags) {
        return bits & ~GEOMETRY_MASK | geometryFlags << GEOMETRY_BIT_OFFSET & GEOMETRY_MASK;
    }

    static RenderMaterialImpl material(int bits) {
        return RenderMaterialImpl.byIndex((bits & MATERIAL_MASK) >>> MATERIAL_BIT_OFFSET);
    }

    static int material(int bits, RenderMaterialImpl material) {
        return bits & ~MATERIAL_MASK | material.index() << MATERIAL_BIT_OFFSET;
    }

    static {
        VertexFormat format = class_290.field_1590;
        VERTEX_X = 4;
        VERTEX_Y = 5;
        VERTEX_Z = 6;
        VERTEX_COLOR = 7;
        VERTEX_U = 8;
        VERTEX_V = VERTEX_U + 1;
        VERTEX_LIGHTMAP = 10;
        VERTEX_NORMAL = 11;
        VERTEX_STRIDE = format.getVertexSize() / 4;
        QUAD_STRIDE = VERTEX_STRIDE * 4;
        QUAD_STRIDE_BYTES = QUAD_STRIDE * 4;
        TOTAL_STRIDE = 4 + QUAD_STRIDE;
        Preconditions.checkState((VERTEX_STRIDE == QuadView.VANILLA_VERTEX_STRIDE ? 1 : 0) != 0, (String)"Indigo vertex stride (%s) mismatched with rendering API (%s)", (int)VERTEX_STRIDE, (int)QuadView.VANILLA_VERTEX_STRIDE);
        Preconditions.checkState((QUAD_STRIDE == QuadView.VANILLA_QUAD_STRIDE ? 1 : 0) != 0, (String)"Indigo quad stride (%s) mismatched with rendering API (%s)", (int)QUAD_STRIDE, (int)QuadView.VANILLA_QUAD_STRIDE);
        DIRECTION_COUNT = class_2350.values().length;
        NULLABLE_DIRECTION_COUNT = DIRECTION_COUNT + 1;
        CULL_BIT_LENGTH = class_3532.method_15342((int)NULLABLE_DIRECTION_COUNT);
        LIGHT_BIT_LENGTH = class_3532.method_15342((int)DIRECTION_COUNT);
        MATERIAL_BIT_LENGTH = MaterialViewImpl.TOTAL_BIT_LENGTH;
        LIGHT_BIT_OFFSET = 0 + CULL_BIT_LENGTH;
        NORMALS_BIT_OFFSET = LIGHT_BIT_OFFSET + LIGHT_BIT_LENGTH;
        GEOMETRY_BIT_OFFSET = NORMALS_BIT_OFFSET + 4;
        MATERIAL_BIT_OFFSET = GEOMETRY_BIT_OFFSET + 3;
        TOTAL_BIT_LENGTH = MATERIAL_BIT_OFFSET + MATERIAL_BIT_LENGTH;
        CULL_MASK = EncodingFormat.bitMask(CULL_BIT_LENGTH, 0);
        LIGHT_MASK = EncodingFormat.bitMask(LIGHT_BIT_LENGTH, LIGHT_BIT_OFFSET);
        NORMALS_MASK = EncodingFormat.bitMask(4, NORMALS_BIT_OFFSET);
        GEOMETRY_MASK = EncodingFormat.bitMask(3, GEOMETRY_BIT_OFFSET);
        MATERIAL_MASK = EncodingFormat.bitMask(MATERIAL_BIT_LENGTH, MATERIAL_BIT_OFFSET);
        Preconditions.checkArgument((TOTAL_BIT_LENGTH <= 32 ? 1 : 0) != 0, (String)"Indigo header encoding bit count (%s) exceeds integer bit length)", (int)TOTAL_STRIDE);
    }
}

