/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.aocalc;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.Indigo;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoConfig;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoFace;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoFaceData;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.QuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.LightDataProvider;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_778;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class AoCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AoCalculator.class);
    private final BlockRenderInfo blockInfo;
    private final LightDataProvider dataProvider;
    private final class_2338.class_2339 lightPos = new class_2338.class_2339();
    private final class_2338.class_2339 searchPos = new class_2338.class_2339();
    private final AoFaceData[] faceData = new AoFaceData[24];
    private int completionFlags = 0;
    private final float[] w = new float[4];
    public final float[] ao = new float[4];
    public final int[] light = new int[4];
    private final int[] vertexData = new int[EncodingFormat.QUAD_STRIDE];
    private final class_778.class_780 vanillaCalc = new class_778.class_780();
    AoFaceData tmpFace = new AoFaceData();
    private final Vector3f vertexNormal = new Vector3f();

    public AoCalculator(BlockRenderInfo blockInfo, LightDataProvider dataProvider) {
        this.blockInfo = blockInfo;
        this.dataProvider = dataProvider;
        for (int i = 0; i < 24; ++i) {
            this.faceData[i] = new AoFaceData();
        }
    }

    public void clear() {
        this.completionFlags = 0;
    }

    public void compute(QuadViewImpl quad, boolean vanillaShade) {
        AoConfig config = Indigo.AMBIENT_OCCLUSION_MODE;
        switch (config) {
            case VANILLA: {
                this.calcVanilla(quad);
                break;
            }
            case EMULATE: {
                this.calcFastVanilla(quad);
                break;
            }
            case HYBRID: {
                if (vanillaShade) {
                    this.calcFastVanilla(quad);
                    break;
                }
                this.calcEnhanced(quad);
                break;
            }
            case ENHANCED: {
                this.calcEnhanced(quad);
            }
        }
        if (Indigo.DEBUG_COMPARE_LIGHTING && vanillaShade && (config == AoConfig.EMULATE || config == AoConfig.HYBRID)) {
            float[] vanillaAo = new float[4];
            int[] vanillaLight = new int[4];
            this.calcVanilla(quad, vanillaAo, vanillaLight);
            for (int i = 0; i < 4; ++i) {
                if (this.light[i] == vanillaLight[i] && class_3532.method_15347((float)this.ao[i], (float)vanillaAo[i])) continue;
                LOGGER.info(String.format("Mismatch for %s @ %s", this.blockInfo.blockState.toString(), this.blockInfo.blockPos.toString()));
                LOGGER.info(String.format("Flags = %d, LightFace = %s", quad.geometryFlags(), quad.lightFace().toString()));
                LOGGER.info(String.format("    Old Brightness: %.2f, %.2f, %.2f, %.2f", Float.valueOf(vanillaAo[0]), Float.valueOf(vanillaAo[1]), Float.valueOf(vanillaAo[2]), Float.valueOf(vanillaAo[3])));
                LOGGER.info(String.format("    New Brightness: %.2f, %.2f, %.2f, %.2f", Float.valueOf(this.ao[0]), Float.valueOf(this.ao[1]), Float.valueOf(this.ao[2]), Float.valueOf(this.ao[3])));
                LOGGER.info(String.format("    Old Light: %s, %s, %s, %s", Integer.toHexString(vanillaLight[0]), Integer.toHexString(vanillaLight[1]), Integer.toHexString(vanillaLight[2]), Integer.toHexString(vanillaLight[3])));
                LOGGER.info(String.format("    New Light: %s, %s, %s, %s", Integer.toHexString(this.light[0]), Integer.toHexString(this.light[1]), Integer.toHexString(this.light[2]), Integer.toHexString(this.light[3])));
                break;
            }
        }
    }

    private void calcVanilla(QuadViewImpl quad) {
        this.calcVanilla(quad, this.ao, this.light);
    }

    private void calcVanilla(QuadViewImpl quad, float[] aoDest, int[] lightDest) {
        class_2350 lightFace = quad.lightFace();
        quad.toVanilla(this.vertexData, 0);
        class_778.method_3364((class_1920)this.blockInfo.blockView, (class_2680)this.blockInfo.blockState, (class_2338)this.blockInfo.blockPos, (int[])this.vertexData, (class_2350)lightFace, (class_778.class_10931)this.vanillaCalc);
        this.vanillaCalc.method_3388(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, lightFace, quad.hasShade());
        System.arraycopy(this.vanillaCalc.field_58162, 0, aoDest, 0, 4);
        System.arraycopy(this.vanillaCalc.field_58163, 0, lightDest, 0, 4);
    }

    private void calcFastVanilla(QuadViewImpl quad) {
        boolean isOnLightFace;
        int flags = quad.geometryFlags();
        boolean bl = isOnLightFace = (flags & 4) != 0;
        if (!isOnLightFace && (flags & 2) != 0 && this.blockInfo.blockState.method_26234((class_1922)this.blockInfo.blockView, this.blockInfo.blockPos)) {
            isOnLightFace = true;
        }
        if ((flags & 1) == 0) {
            this.vanillaPartialFace(quad, quad.lightFace(), isOnLightFace, quad.hasShade());
        } else {
            this.vanillaFullFace(quad, quad.lightFace(), isOnLightFace, quad.hasShade());
        }
    }

    private void calcEnhanced(QuadViewImpl quad) {
        switch (quad.geometryFlags()) {
            case 6: 
            case 7: {
                this.vanillaPartialFace(quad, quad.lightFace(), true, quad.hasShade());
                break;
            }
            case 2: 
            case 3: {
                this.blendedPartialFace(quad, quad.lightFace(), quad.hasShade());
                break;
            }
            default: {
                this.irregularFace(quad, quad.hasShade());
            }
        }
    }

    private void vanillaFullFace(QuadViewImpl quad, class_2350 lightFace, boolean isOnLightFace, boolean shade) {
        this.computeFace(lightFace, isOnLightFace, shade).toArray(this.ao, this.light, AoFace.get((class_2350)lightFace).vertexMap);
    }

    private void vanillaPartialFace(QuadViewImpl quad, class_2350 lightFace, boolean isOnLightFace, boolean shade) {
        AoFaceData faceData = this.computeFace(lightFace, isOnLightFace, shade);
        AoFace aoFace = AoFace.get(lightFace);
        float[] w = this.w;
        for (int i = 0; i < 4; ++i) {
            aoFace.computeCornerWeights(quad, i, w);
            this.light[i] = faceData.weightedCombinedLight(w);
            this.ao[i] = faceData.weigtedAo(w);
        }
    }

    private AoFaceData blendedInsetFace(QuadViewImpl quad, int vertexIndex, class_2350 lightFace, boolean shade) {
        float w1 = AoFace.get(lightFace).computeDepth(quad, vertexIndex);
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true, shade), w0, this.computeFace(lightFace, false, shade), w1, this.tmpFace);
    }

    private AoFaceData gatherInsetFace(QuadViewImpl quad, int vertexIndex, class_2350 lightFace, boolean shade) {
        float w1 = AoFace.get(lightFace).computeDepth(quad, vertexIndex);
        if (class_3532.method_15347((float)w1, (float)0.0f)) {
            return this.computeFace(lightFace, true, shade);
        }
        if (class_3532.method_15347((float)w1, (float)1.0f)) {
            return this.computeFace(lightFace, false, shade);
        }
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true, shade), w0, this.computeFace(lightFace, false, shade), w1, this.tmpFace);
    }

    private void blendedPartialFace(QuadViewImpl quad, class_2350 lightFace, boolean shade) {
        AoFaceData faceData = this.blendedInsetFace(quad, 0, lightFace, shade);
        AoFace aoFace = AoFace.get(lightFace);
        for (int i = 0; i < 4; ++i) {
            aoFace.computeCornerWeights(quad, i, this.w);
            this.light[i] = faceData.weightedCombinedLight(this.w);
            this.ao[i] = faceData.weigtedAo(this.w);
        }
    }

    private void irregularFace(QuadViewImpl quad, boolean shade) {
        Vector3fc faceNorm = quad.faceNormal();
        float[] w = this.w;
        float[] aoResult = this.ao;
        int[] lightResult = this.light;
        for (int i = 0; i < 4; ++i) {
            float z;
            float y;
            Vector3fc normal = quad.hasNormal(i) ? quad.copyNormal(i, this.vertexNormal) : faceNorm;
            float ao = 0.0f;
            float sky = 0.0f;
            float block = 0.0f;
            float maxAo = 0.0f;
            int maxSky = 0;
            int maxBlock = 0;
            float x = normal.x();
            if (!class_3532.method_15347((float)0.0f, (float)x)) {
                class_2350 face = x > 0.0f ? class_2350.field_11034 : class_2350.field_11039;
                AoFaceData fd = this.gatherInsetFace(quad, i, face, shade);
                AoFace.get(face).computeCornerWeights(quad, i, w);
                float n = x * x;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = a;
                maxSky = s;
                maxBlock = b;
            }
            if (!class_3532.method_15347((float)0.0f, (float)(y = normal.y()))) {
                class_2350 face = y > 0.0f ? class_2350.field_11036 : class_2350.field_11033;
                AoFaceData fd = this.gatherInsetFace(quad, i, face, shade);
                AoFace.get(face).computeCornerWeights(quad, i, w);
                float n = y * y;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = Math.max(maxAo, a);
                maxSky = Math.max(maxSky, s);
                maxBlock = Math.max(maxBlock, b);
            }
            if (!class_3532.method_15347((float)0.0f, (float)(z = normal.z()))) {
                class_2350 face = z > 0.0f ? class_2350.field_11035 : class_2350.field_11043;
                AoFaceData fd = this.gatherInsetFace(quad, i, face, shade);
                AoFace.get(face).computeCornerWeights(quad, i, w);
                float n = z * z;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = Math.max(maxAo, a);
                maxSky = Math.max(maxSky, s);
                maxBlock = Math.max(maxBlock, b);
            }
            aoResult[i] = (ao + maxAo) * 0.5f;
            lightResult[i] = ((int)((sky + (float)maxSky) * 0.5f) & 0xFF) << 16 | (int)((block + (float)maxBlock) * 0.5f) & 0xFF;
        }
    }

    private AoFaceData computeFace(class_2350 lightFace, boolean isOnBlockFace, boolean shade) {
        int faceDataIndex = shade ? (isOnBlockFace ? lightFace.method_10146() : lightFace.method_10146() + 6) : (isOnBlockFace ? lightFace.method_10146() + 12 : lightFace.method_10146() + 18);
        int mask = 1 << faceDataIndex;
        AoFaceData result = this.faceData[faceDataIndex];
        if ((this.completionFlags & mask) == 0) {
            this.completionFlags |= mask;
            this.computeFace(result, lightFace, isOnBlockFace, shade);
        }
        return result;
    }

    private void computeFace(AoFaceData result, class_2350 lightFace, boolean isOnBlockFace, boolean shade) {
        boolean isClearCenter;
        int lightCenter;
        boolean cIsClear3;
        int cLight3;
        float cAo3;
        boolean cIsClear2;
        int cLight2;
        float cAo2;
        boolean cIsClear1;
        int cLight1;
        float cAo1;
        boolean cIsClear0;
        int cLight0;
        float cAo0;
        boolean isClear3;
        class_1920 world = this.blockInfo.blockView;
        class_2338 pos = this.blockInfo.blockPos;
        class_2680 blockState = this.blockInfo.blockState;
        class_2338.class_2339 lightPos = this.lightPos;
        class_2338.class_2339 searchPos = this.searchPos;
        if (isOnBlockFace) {
            lightPos.method_25505((class_2382)pos, lightFace);
        } else {
            lightPos.method_10101((class_2382)pos);
        }
        AoFace aoFace = AoFace.get(lightFace);
        searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[0]);
        class_2680 searchState = world.method_8320((class_2338)searchPos);
        int light0 = this.dataProvider.light((class_2338)searchPos, searchState);
        float ao0 = this.dataProvider.ao((class_2338)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.method_10098(lightFace);
            searchState = world.method_8320((class_2338)searchPos);
        }
        boolean isClear0 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[1]);
        searchState = world.method_8320((class_2338)searchPos);
        int light1 = this.dataProvider.light((class_2338)searchPos, searchState);
        float ao1 = this.dataProvider.ao((class_2338)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.method_10098(lightFace);
            searchState = world.method_8320((class_2338)searchPos);
        }
        boolean isClear1 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[2]);
        searchState = world.method_8320((class_2338)searchPos);
        int light2 = this.dataProvider.light((class_2338)searchPos, searchState);
        float ao2 = this.dataProvider.ao((class_2338)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.method_10098(lightFace);
            searchState = world.method_8320((class_2338)searchPos);
        }
        boolean isClear2 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[3]);
        searchState = world.method_8320((class_2338)searchPos);
        int light3 = this.dataProvider.light((class_2338)searchPos, searchState);
        float ao3 = this.dataProvider.ao((class_2338)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.method_10098(lightFace);
            searchState = world.method_8320((class_2338)searchPos);
        }
        boolean bl = isClear3 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        if (!isClear2 && !isClear0) {
            cAo0 = ao0;
            cLight0 = light0;
            cIsClear0 = false;
        } else {
            searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[0]).method_10098(aoFace.neighbors[2]);
            searchState = world.method_8320((class_2338)searchPos);
            cAo0 = this.dataProvider.ao((class_2338)searchPos, searchState);
            cLight0 = this.dataProvider.light((class_2338)searchPos, searchState);
            boolean bl2 = cIsClear0 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        }
        if (!isClear3 && !isClear0) {
            cAo1 = ao0;
            cLight1 = light0;
            cIsClear1 = false;
        } else {
            searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[0]).method_10098(aoFace.neighbors[3]);
            searchState = world.method_8320((class_2338)searchPos);
            cAo1 = this.dataProvider.ao((class_2338)searchPos, searchState);
            cLight1 = this.dataProvider.light((class_2338)searchPos, searchState);
            boolean bl3 = cIsClear1 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        }
        if (!isClear2 && !isClear1) {
            cAo2 = ao1;
            cLight2 = light1;
            cIsClear2 = false;
        } else {
            searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[1]).method_10098(aoFace.neighbors[2]);
            searchState = world.method_8320((class_2338)searchPos);
            cAo2 = this.dataProvider.ao((class_2338)searchPos, searchState);
            cLight2 = this.dataProvider.light((class_2338)searchPos, searchState);
            boolean bl4 = cIsClear2 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        }
        if (!isClear3 && !isClear1) {
            cAo3 = ao1;
            cLight3 = light1;
            cIsClear3 = false;
        } else {
            searchPos.method_25505((class_2382)lightPos, aoFace.neighbors[1]).method_10098(aoFace.neighbors[3]);
            searchState = world.method_8320((class_2338)searchPos);
            cAo3 = this.dataProvider.ao((class_2338)searchPos, searchState);
            cLight3 = this.dataProvider.light((class_2338)searchPos, searchState);
            cIsClear3 = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        }
        searchPos.method_25505((class_2382)pos, lightFace);
        searchState = world.method_8320((class_2338)searchPos);
        if (isOnBlockFace && !searchState.method_26216()) {
            lightCenter = this.dataProvider.light((class_2338)searchPos, searchState);
            isClearCenter = !searchState.method_26230((class_1922)world, (class_2338)searchPos) || searchState.method_26193() == 0;
        } else {
            lightCenter = this.dataProvider.light(pos, blockState);
            isClearCenter = !blockState.method_26230((class_1922)world, pos) || blockState.method_26193() == 0;
        }
        float aoCenter = this.dataProvider.ao((class_2338)lightPos, world.method_8320((class_2338)lightPos));
        float shadeBrightness = world.method_24852(lightFace, shade);
        result.a0 = (ao3 + ao0 + cAo1 + aoCenter) * 0.25f * shadeBrightness;
        result.a1 = (ao2 + ao0 + cAo0 + aoCenter) * 0.25f * shadeBrightness;
        result.a2 = (ao2 + ao1 + cAo2 + aoCenter) * 0.25f * shadeBrightness;
        result.a3 = (ao3 + ao1 + cAo3 + aoCenter) * 0.25f * shadeBrightness;
        result.l0(AoCalculator.meanLight(light3, light0, cLight1, lightCenter, isClear3, isClear0, cIsClear1, isClearCenter));
        result.l1(AoCalculator.meanLight(light2, light0, cLight0, lightCenter, isClear2, isClear0, cIsClear0, isClearCenter));
        result.l2(AoCalculator.meanLight(light2, light1, cLight2, lightCenter, isClear2, isClear1, cIsClear2, isClearCenter));
        result.l3(AoCalculator.meanLight(light3, light1, cLight3, lightCenter, isClear3, isClear1, cIsClear3, isClearCenter));
    }

    private static int meanLight(int lightA, int lightB, int lightC, int lightD, boolean isClearA, boolean isClearB, boolean isClearC, boolean isClearD) {
        if (Indigo.FIX_MEAN_LIGHT_CALCULATION) {
            int lightABlock = lightA & 0xFFFF;
            int lightASky = lightA >>> 16 & 0xFFFF;
            int lightBBlock = lightB & 0xFFFF;
            int lightBSky = lightB >>> 16 & 0xFFFF;
            int lightCBlock = lightC & 0xFFFF;
            int lightCSky = lightC >>> 16 & 0xFFFF;
            int lightDBlock = lightD & 0xFFFF;
            int lightDSky = lightD >>> 16 & 0xFFFF;
            int minBlock = 65536;
            int minSky = 65536;
            if (isClearA) {
                minBlock = lightABlock;
                minSky = lightASky;
            }
            if (isClearB) {
                minBlock = Math.min(minBlock, lightBBlock);
                minSky = Math.min(minSky, lightBSky);
            }
            if (isClearC) {
                minBlock = Math.min(minBlock, lightCBlock);
                minSky = Math.min(minSky, lightCSky);
            }
            if (isClearD) {
                minBlock = Math.min(minBlock, lightDBlock);
                minSky = Math.min(minSky, lightDSky);
            }
            lightA = Math.max(lightASky, minSky &= 0xFFFF) << 16 | Math.max(lightABlock, minBlock &= 0xFFFF);
            lightB = Math.max(lightBSky, minSky) << 16 | Math.max(lightBBlock, minBlock);
            lightC = Math.max(lightCSky, minSky) << 16 | Math.max(lightCBlock, minBlock);
            lightD = Math.max(lightDSky, minSky) << 16 | Math.max(lightDBlock, minBlock);
            return AoCalculator.meanInnerLight(lightA, lightB, lightC, lightD);
        }
        return AoCalculator.vanillaMeanLight(lightA, lightB, lightC, lightD);
    }

    private static int vanillaMeanLight(int a, int b, int c, int d) {
        if (a == 0) {
            a = d;
        }
        if (b == 0) {
            b = d;
        }
        if (c == 0) {
            c = d;
        }
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int meanInnerLight(int a, int b, int c, int d) {
        return a + b + c + d >> 2 & 0xFF00FF;
    }
}

