/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.fluid;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class WaterPotionStorage
implements ExtractionOnlyStorage<FluidVariant>,
SingleSlotStorage<FluidVariant> {
    private static final FluidVariant CONTAINED_FLUID = FluidVariant.of((class_3611)class_3612.field_15910);
    private static final long CONTAINED_AMOUNT = 27000L;
    private final ContainerItemContext context;

    @Nullable
    public static WaterPotionStorage find(ContainerItemContext context) {
        return WaterPotionStorage.isWaterPotion(context) ? new WaterPotionStorage(context) : null;
    }

    private static boolean isWaterPotion(ContainerItemContext context) {
        ItemVariant variant = context.getItemVariant();
        class_1844 potionContents = (class_1844)variant.getComponentMap().method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        return variant.isOf(class_1802.field_8574) && potionContents.comp_2378().orElse(null) == class_1847.field_8991;
    }

    private WaterPotionStorage(ContainerItemContext context) {
        this.context = context;
    }

    private boolean isWaterPotion() {
        return WaterPotionStorage.isWaterPotion(this.context);
    }

    private ItemVariant mapToGlassBottle() {
        class_1799 newStack = this.context.getItemVariant().toStack();
        newStack.method_57379(class_9334.field_49651, (Object)class_1844.field_49274);
        return ItemVariant.of((class_1935)class_1802.field_8469, newStack.method_57380());
    }

    @Override
    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, maxAmount);
        if (!this.isWaterPotion()) {
            return 0L;
        }
        if (resource.equals(CONTAINED_FLUID) && maxAmount >= 27000L && this.context.exchange(this.mapToGlassBottle(), 1L, transaction) == 1L) {
            return 27000L;
        }
        return 0L;
    }

    @Override
    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    @Override
    public FluidVariant getResource() {
        if (this.isWaterPotion()) {
            return CONTAINED_FLUID;
        }
        return FluidVariant.blank();
    }

    @Override
    public long getAmount() {
        if (this.isWaterPotion()) {
            return 27000L;
        }
        return 0L;
    }

    @Override
    public long getCapacity() {
        return this.getAmount();
    }

    public String toString() {
        return "WaterPotionStorage[" + String.valueOf(this.context) + "]";
    }
}

