/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.blockrenderlayer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_3611;

@Environment(value=EnvType.CLIENT)
public class BlockRenderLayerMapImpl
implements BlockRenderLayerMap {
    private static final Map<class_2248, class_1921> BLOCK_RENDER_LAYER_MAP = new HashMap<class_2248, class_1921>();
    private static final Map<class_3611, class_1921> FLUID_RENDER_LAYER_MAP = new HashMap<class_3611, class_1921>();
    private static BiConsumer<class_2248, class_1921> blockHandler = BLOCK_RENDER_LAYER_MAP::put;
    private static BiConsumer<class_3611, class_1921> fluidHandler = FLUID_RENDER_LAYER_MAP::put;

    @Override
    public void putBlock(class_2248 block, class_1921 renderLayer) {
        if (block == null) {
            throw new IllegalArgumentException("Request to map null block to RenderLayer");
        }
        if (renderLayer == null) {
            throw new IllegalArgumentException("Request to map block " + block.toString() + " to null RenderLayer");
        }
        blockHandler.accept(block, renderLayer);
    }

    @Override
    public void putBlocks(class_1921 renderLayer, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            this.putBlock(block, renderLayer);
        }
    }

    @Override
    public void putFluid(class_3611 fluid, class_1921 renderLayer) {
        if (fluid == null) {
            throw new IllegalArgumentException("Request to map null fluid to RenderLayer");
        }
        if (renderLayer == null) {
            throw new IllegalArgumentException("Request to map fluid " + fluid.toString() + " to null RenderLayer");
        }
        fluidHandler.accept(fluid, renderLayer);
    }

    @Override
    public void putFluids(class_1921 renderLayer, class_3611 ... fluids) {
        for (class_3611 fluid : fluids) {
            this.putFluid(fluid, renderLayer);
        }
    }

    public static void initialize(BiConsumer<class_2248, class_1921> blockHandlerIn, BiConsumer<class_3611, class_1921> fluidHandlerIn) {
        BLOCK_RENDER_LAYER_MAP.forEach(blockHandlerIn);
        FLUID_RENDER_LAYER_MAP.forEach(fluidHandlerIn);
        blockHandler = blockHandlerIn;
        fluidHandler = fluidHandlerIn;
    }
}

