/*
 * Decompiled with CFR 0.152.
 */
package com.akuleshov7.ktoml.parsers;

import com.akuleshov7.ktoml.exceptions.ParseException;
import com.akuleshov7.ktoml.utils.UtilsJvmKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0007\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\n\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\r\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0010*\u00020\u001bH\u0002\u001a\f\u0010\u001c\u001a\u00020\u0010*\u00020\u0002H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0002\u001a \u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a8\u0006\""}, d2={"splitKeyToTokens", "", "", "lineNo", "", "trimSingleQuotes", "trimMultilineLiteralQuotes", "convertLineEndingBackslash", "trimQuotes", "trimMultilineQuotes", "trimCurlyBraces", "trimBrackets", "removeTrailingComma", "trimDoubleBrackets", "takeBeforeComment", "allowEscapedQuotesInLiteralStrings", "", "trimComment", "getCountOfOccurrencesOfSubstring", "substring", "validateSpaces", "", "fullKey", "validateQuotes", "validateSymbols", "getCommentStartIndex", "isLetterOrDigit", "", "isNotQuoted", "quotes", "trimSymbols", "str", "prefix", "suffix", "ktoml-core"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\ncom/akuleshov7/ktoml/parsers/StringUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,308:1\n1179#2,2:309\n1104#2,3:311\n1104#2,3:314\n1179#2,2:317\n130#2,2:319\n1069#2,2:324\n13491#3,3:321\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\ncom/akuleshov7/ktoml/parsers/StringUtilsKt\n*L\n27#1:309,2\n185#1:311,3\n197#1:314,3\n212#1:317,2\n234#1:319,2\n287#1:324,2\n248#1:321,3\n*E\n"})
public final class StringUtilsKt {
    @NotNull
    public static final List<String> splitKeyToTokens(@NotNull String $this$splitKeyToTokens, int lineNo) {
        Intrinsics.checkNotNullParameter((Object)$this$splitKeyToTokens, (String)"<this>");
        StringUtilsKt.validateQuotes($this$splitKeyToTokens, lineNo);
        StringUtilsKt.validateSymbols($this$splitKeyToTokens, lineNo);
        boolean singleQuoteIsClosed = false;
        singleQuoteIsClosed = true;
        boolean doubleQuoteIsClosed = false;
        doubleQuoteIsClosed = true;
        List dotSeparatedParts = new ArrayList();
        StringBuilder currentPart = null;
        currentPart = new StringBuilder();
        CharSequence $this$forEach$iv = $this$splitKeyToTokens;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            StringBuilder stringBuilder;
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            char c = ch;
            if (c == '\'') {
                singleQuoteIsClosed = !singleQuoteIsClosed;
                stringBuilder = currentPart.append(ch);
                continue;
            }
            if (c == '\"') {
                doubleQuoteIsClosed = !doubleQuoteIsClosed;
                stringBuilder = currentPart.append(ch);
                continue;
            }
            if (c == '.') {
                if (singleQuoteIsClosed && doubleQuoteIsClosed) {
                    String string = currentPart.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    dotSeparatedParts.add(string);
                    currentPart = new StringBuilder();
                    stringBuilder = Unit.INSTANCE;
                    continue;
                }
                stringBuilder = currentPart.append(ch);
                continue;
            }
            stringBuilder = currentPart.append(ch);
        }
        String string = currentPart.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String keyPart = ((Object)StringsKt.trim((CharSequence)string)).toString();
        StringUtilsKt.validateSpaces(keyPart, lineNo, $this$splitKeyToTokens);
        dotSeparatedParts.add(keyPart);
        return dotSeparatedParts;
    }

    @NotNull
    public static final String trimSingleQuotes(@NotNull String $this$trimSingleQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$trimSingleQuotes, (String)"<this>");
        return StringUtilsKt.trimSymbols($this$trimSingleQuotes, "'", "'");
    }

    @NotNull
    public static final String trimMultilineLiteralQuotes(@NotNull String $this$trimMultilineLiteralQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$trimMultilineLiteralQuotes, (String)"<this>");
        return StringsKt.removePrefix((String)StringUtilsKt.trimMultilineQuotes($this$trimMultilineLiteralQuotes, "'''"), (CharSequence)String.valueOf(UtilsJvmKt.newLineChar()));
    }

    @NotNull
    public static final String convertLineEndingBackslash(@NotNull String $this$convertLineEndingBackslash) {
        Intrinsics.checkNotNullParameter((Object)$this$convertLineEndingBackslash, (String)"<this>");
        String[] stringArray = new String[]{"\\\n"};
        List splitEndingBackslash = StringsKt.split$default((CharSequence)$this$convertLineEndingBackslash, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return splitEndingBackslash.size() == 1 ? $this$convertLineEndingBackslash : CollectionsKt.joinToString$default((Iterable)splitEndingBackslash, (CharSequence)"", null, null, (int)0, null, StringUtilsKt::convertLineEndingBackslash$lambda$1, (int)30, null);
    }

    @NotNull
    public static final String trimQuotes(@NotNull String $this$trimQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$trimQuotes, (String)"<this>");
        return StringUtilsKt.trimSymbols($this$trimQuotes, "\"", "\"");
    }

    @NotNull
    public static final String trimMultilineQuotes(@NotNull String $this$trimMultilineQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$trimMultilineQuotes, (String)"<this>");
        return StringsKt.removePrefix((String)StringUtilsKt.trimMultilineQuotes($this$trimMultilineQuotes, "\"\"\""), (CharSequence)String.valueOf(UtilsJvmKt.newLineChar()));
    }

    @NotNull
    public static final String trimCurlyBraces(@NotNull String $this$trimCurlyBraces) {
        Intrinsics.checkNotNullParameter((Object)$this$trimCurlyBraces, (String)"<this>");
        return StringUtilsKt.trimSymbols($this$trimCurlyBraces, "{", "}");
    }

    @NotNull
    public static final String trimBrackets(@NotNull String $this$trimBrackets) {
        Intrinsics.checkNotNullParameter((Object)$this$trimBrackets, (String)"<this>");
        return StringUtilsKt.trimSymbols($this$trimBrackets, "[", "]");
    }

    @NotNull
    public static final String removeTrailingComma(@NotNull String $this$removeTrailingComma) {
        Intrinsics.checkNotNullParameter((Object)$this$removeTrailingComma, (String)"<this>");
        return StringsKt.removeSuffix((String)$this$removeTrailingComma, (CharSequence)",");
    }

    @NotNull
    public static final String trimDoubleBrackets(@NotNull String $this$trimDoubleBrackets) {
        Intrinsics.checkNotNullParameter((Object)$this$trimDoubleBrackets, (String)"<this>");
        return StringUtilsKt.trimSymbols($this$trimDoubleBrackets, "[[", "]]");
    }

    @NotNull
    public static final String takeBeforeComment(@NotNull String $this$takeBeforeComment, boolean allowEscapedQuotesInLiteralStrings) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$takeBeforeComment, (String)"<this>");
        int commentStartIndex = StringUtilsKt.getCommentStartIndex($this$takeBeforeComment, allowEscapedQuotesInLiteralStrings);
        if (commentStartIndex == -1) {
            string = ((Object)StringsKt.trim((CharSequence)$this$takeBeforeComment)).toString();
        } else {
            String string2 = $this$takeBeforeComment.substring(0, commentStartIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return string;
    }

    @NotNull
    public static final String trimComment(@NotNull String $this$trimComment, boolean allowEscapedQuotesInLiteralStrings) {
        Intrinsics.checkNotNullParameter((Object)$this$trimComment, (String)"<this>");
        int commentStartIndex = StringUtilsKt.getCommentStartIndex($this$trimComment, allowEscapedQuotesInLiteralStrings);
        return commentStartIndex == -1 ? "" : ((Object)StringsKt.trim((CharSequence)StringsKt.drop((String)$this$trimComment, (int)(commentStartIndex + 1)))).toString();
    }

    public static final int getCountOfOccurrencesOfSubstring(@NotNull String $this$getCountOfOccurrencesOfSubstring, @NotNull String substring) {
        Intrinsics.checkNotNullParameter((Object)$this$getCountOfOccurrencesOfSubstring, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        String[] stringArray = new String[]{substring};
        return StringsKt.split$default((CharSequence)$this$getCountOfOccurrencesOfSubstring, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() - 1;
    }

    private static final void validateSpaces(String $this$validateSpaces, int lineNo, String fullKey) {
        CharSequence $this$count$iv = ((Object)StringsKt.trim((CharSequence)$this$validateSpaces)).toString();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == ' ')) continue;
            ++count$iv;
        }
        if (count$iv > 0 && StringUtilsKt.isNotQuoted($this$validateSpaces)) {
            throw new ParseException("Not able to parse the key: [" + fullKey + "] as it has invalid spaces. If you would like to have spaces in the middle of the key - use quotes: \"WORD SPACE\"", lineNo);
        }
    }

    private static final void validateQuotes(String $this$validateQuotes, int lineNo) {
        block5: {
            block4: {
                char it;
                char element$iv;
                int n;
                CharSequence $this$count$iv = $this$validateQuotes;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    it = element$iv = $this$count$iv.charAt(n);
                    boolean bl = false;
                    if (!(it == '\"')) continue;
                    ++count$iv;
                }
                if (count$iv % 2 != 0) break block4;
                $this$count$iv = $this$validateQuotes;
                $i$f$count = false;
                count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    it = element$iv = $this$count$iv.charAt(n);
                    boolean bl = false;
                    if (!(it == '\'')) continue;
                    ++count$iv;
                }
                if (count$iv % 2 == 0) break block5;
            }
            throw new ParseException("Not able to parse the key: [" + $this$validateQuotes + "] as it does not have closing quote. Please note, that you cannot use even escaped quotes in the bare keys.", lineNo);
        }
    }

    private static final void validateSymbols(String $this$validateSymbols, int lineNo) {
        boolean singleQuoteIsClosed = false;
        singleQuoteIsClosed = true;
        boolean doubleQuoteIsClosed = false;
        doubleQuoteIsClosed = true;
        CharSequence $this$forEach$iv = StringUtilsKt.trimQuotes(((Object)StringsKt.trim((CharSequence)$this$validateSymbols)).toString());
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            Object[] objectArray;
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            char c = ch;
            if (c == '\'') {
                singleQuoteIsClosed = !singleQuoteIsClosed;
                continue;
            }
            if (c == '\"') {
                doubleQuoteIsClosed = !doubleQuoteIsClosed;
                continue;
            }
            if (!doubleQuoteIsClosed || !singleQuoteIsClosed || SetsKt.setOf((Object[])(objectArray = new Character[]{Character.valueOf('_'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf(' '), Character.valueOf('\t')})).contains(Character.valueOf(ch)) || StringUtilsKt.isLetterOrDigit(ch)) continue;
            throw new ParseException("Not able to parse the key: [" + $this$validateSymbols + "] as it contains invalid symbols. In case you would like to use special symbols - use quotes as it is required by TOML standard: \"My key with special (%, \u00b1) symbols\" = \"value\"", lineNo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int getCommentStartIndex(String $this$getCommentStartIndex, boolean allowEscapedQuotesInLiteralStrings) {
        boolean bl;
        if (allowEscapedQuotesInLiteralStrings) {
            Character firstQuoteLetter;
            Character c;
            block6: {
                CharSequence $this$firstOrNull$iv = $this$getCommentStartIndex;
                boolean $i$f$firstOrNull = false;
                for (int i = 0; i < $this$firstOrNull$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$firstOrNull$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(it == '\"' || it == '\'')) continue;
                    c = Character.valueOf(element$iv);
                    break block6;
                }
                c = null;
            }
            Character c2 = firstQuoteLetter = c;
            char $this$firstOrNull$iv = '\'';
            bl = c2 != null && c2.charValue() == $this$firstOrNull$iv;
        } else {
            bl = false;
        }
        boolean isEscapingDisabled = bl;
        char[] cArray = (!isEscapingDisabled ? StringsKt.replace$default((String)StringsKt.replace$default((String)$this$getCommentStartIndex, (String)"\\\"", (String)"__", (boolean)false, (int)4, null), (String)"\\'", (String)"__", (boolean)false, (int)4, null) : $this$getCommentStartIndex).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        Character currentQuoteChar = null;
        char[] $this$forEachIndexed$iv = chars;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (char item$iv : $this$forEachIndexed$iv) {
            void symbol;
            int n = index$iv++;
            char c = item$iv;
            int idx = n;
            boolean bl3 = false;
            if (symbol == 35 && currentQuoteChar == null) {
                return idx;
            }
            if (symbol != 34 && symbol != 39) continue;
            if (currentQuoteChar == null) {
                currentQuoteChar = Character.valueOf((char)symbol);
                continue;
            }
            void var14_17 = symbol;
            if (currentQuoteChar.charValue() != var14_17) continue;
            currentQuoteChar = null;
        }
        return -1;
    }

    private static final boolean isLetterOrDigit(char $this$isLetterOrDigit) {
        return new CharRange('A', 'Z').contains($this$isLetterOrDigit) || new CharRange('a', 'z').contains($this$isLetterOrDigit) || new CharRange('0', '9').contains($this$isLetterOrDigit);
    }

    private static final boolean isNotQuoted(String $this$isNotQuoted) {
        return !StringsKt.startsWith$default((String)$this$isNotQuoted, (String)"\"", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)$this$isNotQuoted, (String)"\"", (boolean)false, (int)2, null);
    }

    private static final String trimMultilineQuotes(String $this$trimMultilineQuotes, String quotes) {
        if (StringsKt.startsWith$default((String)$this$trimMultilineQuotes, (String)quotes, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$trimMultilineQuotes, (String)quotes, (boolean)false, (int)2, null)) {
            String trimmedStr = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$this$trimMultilineQuotes, (CharSequence)quotes), (CharSequence)quotes);
            int lastNewLine = StringsKt.lastIndexOf$default((CharSequence)trimmedStr, (char)UtilsJvmKt.newLineChar(), (int)0, (boolean)false, (int)6, null);
            if (lastNewLine != -1) {
                boolean bl;
                block4: {
                    String string = StringsKt.removePrefix((String)trimmedStr, (CharSequence)String.valueOf(UtilsJvmKt.newLineChar())).substring(lastNewLine);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    CharSequence $this$all$iv = string;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv.charAt(i);
                        boolean bl2 = false;
                        if (it == ' ') continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
                if (bl) {
                    String string = trimmedStr.substring(0, lastNewLine + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return string;
                }
            }
            return trimmedStr;
        }
        return $this$trimMultilineQuotes;
    }

    private static final String trimSymbols(String str, String prefix, String suffix) {
        if (StringsKt.startsWith$default((String)str, (String)prefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)str, (String)suffix, (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)str, (CharSequence)prefix), (CharSequence)suffix);
        }
        return str;
    }

    private static final CharSequence convertLineEndingBackslash$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimStart((CharSequence)it)).toString();
    }
}

