/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.ThreadedParameters;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.logging.log4j.Logger;

public final class StepStructureStart {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ChunkStatus STATUS = ChunkStatus.STRUCTURE_STARTS;
    private static final ReentrantLock STRUCTURE_PLACEMENT_LOCK = new ReentrantLock();
    private final BatchGenerationEnvironment environment;

    public StepStructureStart(BatchGenerationEnvironment batchGenerationEnvironment) {
        this.environment = batchGenerationEnvironment;
    }

    public void generateGroup(ThreadedParameters tParams, WorldGenRegion worldGenRegion, List<ChunkWrapper> chunkWrappers) throws InterruptedException {
        ArrayList chunksToDo = new ArrayList();
        for (ChunkWrapper chunkWrapper : chunkWrappers) {
            ChunkAccess chunk = chunkWrapper.getChunk();
            if (chunkWrapper.getStatus().isOrAfter(STATUS) || !(chunk instanceof ProtoChunk)) continue;
            chunkWrapper.trySetStatus(STATUS);
        }
        if (this.environment.params.worldOptions.generateStructures()) {
            for (ChunkAccess chunk : chunksToDo) {
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                STRUCTURE_PLACEMENT_LOCK.lock();
                this.environment.params.generator.createStructures(this.environment.params.registry, this.environment.params.level.getChunkSource().getGeneratorState(), (StructureManager)tParams.structFeat, chunk, this.environment.params.structures, this.environment.params.level.dimension());
                try {
                    tParams.structCheck.onStructureLoad(chunk.getPos(), chunk.getAllStarts());
                }
                catch (ArrayIndexOutOfBoundsException firstEx) {
                    tParams.recreateStructureCheck();
                    try {
                        tParams.structCheck.onStructureLoad(chunk.getPos(), chunk.getAllStarts());
                    }
                    catch (ArrayIndexOutOfBoundsException secondEx) {
                        LOGGER.error("Unable to create structure starts for " + String.valueOf(chunk.getPos()) + ". This is an error with MC's world generation. Ignoring and continuing generation. Error: " + secondEx.getMessage());
                    }
                }
                STRUCTURE_PLACEMENT_LOCK.unlock();
            }
        }
    }

    public static class StructStartCorruptedException
    extends RuntimeException {
        private static final long serialVersionUID = -8987434342051563358L;

        public StructStartCorruptedException(ArrayIndexOutOfBoundsException e) {
            super("StructStartCorruptedException");
            super.initCause(e);
            this.fillInStackTrace();
        }
    }
}

