/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge;

import com.seibel.distanthorizons.core.api.internal.ServerApi;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.function.Supplier;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.util.ProxyUtil;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.logging.log4j.Logger;

public class NeoforgeServerProxy
implements AbstractModInitializer.IEventProxy {
    private final ServerApi serverApi = ServerApi.INSTANCE;
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final boolean isDedicated;
    public static Supplier<Boolean> isGenerationThreadChecker = null;

    private static LevelAccessor GetEventLevel(LevelEvent e) {
        return e.getLevel();
    }

    public NeoforgeServerProxy(boolean isDedicated) {
        this.isDedicated = isDedicated;
        isGenerationThreadChecker = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
    }

    @Override
    public void registerEvents() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverTickEvent(ServerTickEvent.Post event) {
        this.serverApi.serverTickEvent();
    }

    @SubscribeEvent
    public void dedicatedWorldLoadEvent(ServerAboutToStartEvent event) {
        this.serverApi.serverLoadEvent(this.isDedicated);
    }

    @SubscribeEvent
    public void serverWorldUnloadEvent(ServerStoppingEvent event) {
        this.serverApi.serverUnloadEvent();
    }

    @SubscribeEvent
    public void serverLevelLoadEvent(LevelEvent.Load event) {
        if (NeoforgeServerProxy.GetEventLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelLoadEvent(NeoforgeServerProxy.getServerLevelWrapper((ServerLevel)NeoforgeServerProxy.GetEventLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverLevelUnloadEvent(LevelEvent.Unload event) {
        if (NeoforgeServerProxy.GetEventLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelUnloadEvent(NeoforgeServerProxy.getServerLevelWrapper((ServerLevel)NeoforgeServerProxy.GetEventLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverChunkLoadEvent(ChunkEvent.Load event) {
        ILevelWrapper levelWrapper = ProxyUtil.getLevelWrapper(NeoforgeServerProxy.GetEventLevel((LevelEvent)event));
        ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), levelWrapper);
        this.serverApi.serverChunkLoadEvent(chunk, levelWrapper);
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        this.serverApi.serverPlayerJoinEvent(NeoforgeServerProxy.getServerPlayerWrapper((PlayerEvent)event));
    }

    @SubscribeEvent
    public void playerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        this.serverApi.serverPlayerDisconnectEvent(NeoforgeServerProxy.getServerPlayerWrapper((PlayerEvent)event));
    }

    @SubscribeEvent
    public void playerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.serverApi.serverPlayerLevelChangeEvent(NeoforgeServerProxy.getServerPlayerWrapper((PlayerEvent)event), NeoforgeServerProxy.getServerLevelWrapper((ResourceKey<Level>)event.getFrom(), (PlayerEvent)event), NeoforgeServerProxy.getServerLevelWrapper((ResourceKey<Level>)event.getTo(), (PlayerEvent)event));
    }

    private static ServerLevelWrapper getServerLevelWrapper(ServerLevel level) {
        return ServerLevelWrapper.getWrapper(level);
    }

    private static ServerLevelWrapper getServerLevelWrapper(ResourceKey<Level> resourceKey, PlayerEvent event) {
        return NeoforgeServerProxy.getServerLevelWrapper(event.getEntity().getServer().getLevel(resourceKey));
    }

    private static ServerPlayerWrapper getServerPlayerWrapper(PlayerEvent event) {
        return ServerPlayerWrapper.getWrapper((ServerPlayer)event.getEntity());
    }
}

