/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.LoggerFactory;

public class CUtil {
    public static final ControlifyLogger LOGGER = ControlifyLogger.createMasterLogger(LoggerFactory.getLogger((String)"Controlify"));
    public static final boolean IS_POJAV_LAUNCHER = System.getenv("POJAV_NATIVEDIR") != null;

    public static class_2960 rl(String path) {
        return CUtil.rl("controlify", path);
    }

    public static class_2960 mcRl(String path) {
        return CUtil.rl("minecraft", path);
    }

    public static class_2960 rl(String namespace, String path) {
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static class_287 beginBuffer(VertexFormat.class_5596 mode, VertexFormat format) {
        return class_289.method_1348().method_60827(mode, format);
    }

    public static void openUri(String uri) {
        try {
            String[] command = URIOpener.get().openArguments(URI.create(uri));
            Process process = Runtime.getRuntime().exec(command);
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
        }
        catch (IOException | SecurityException e) {
            LOGGER.error("Failed to open URI: {}", uri, e);
        }
    }

    public static <T> Supplier<T> lazyInit(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private T created = null;

            @Override
            public T get() {
                if (this.created == null) {
                    this.created = supplier.get();
                }
                return this.created;
            }
        };
    }

    public static String createUIDFromBytes(byte[] ... bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not get MD5 hash.", e);
        }
        for (byte[] b : bytes) {
            md.update(b);
        }
        byte[] digest = md.digest();
        return Hex.encodeHexString((byte[])digest);
    }

    public static void sleepChecked(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to sleep for {}ms", e, millis);
        }
    }

    public static <E> Codec<E> stringResolver(Function<E, String> toString, Function<String, E> fromString) {
        return Codec.STRING.flatXmap(name -> Optional.ofNullable(fromString.apply((String)name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + name)), e -> Optional.ofNullable((String)toString.apply(e)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + String.valueOf(e))));
    }

    public static <T extends class_3542> Function<String, T> createNameLookup(T[] values, Function<String, String> keyFunction) {
        Map<String, class_3542> map = Arrays.stream(values).collect(Collectors.toMap(stringRepresentable -> (String)keyFunction.apply(stringRepresentable.method_15434()), stringRepresentable -> stringRepresentable));
        return string -> string == null ? null : (class_3542)map.get(string);
    }

    public static <E> MapCodec<E> orCompressed(final MapCodec<E> first, final MapCodec<E> second) {
        return new MapCodec<E>(){

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                return dynamicOps.compressMaps() ? second.encode(object, dynamicOps, recordBuilder) : first.encode(object, dynamicOps, recordBuilder);
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return dynamicOps.compressMaps() ? second.decode(dynamicOps, mapLike) : first.decode(dynamicOps, mapLike);
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return second.keys(dynamicOps);
            }

            public String toString() {
                return String.valueOf(first) + " orCompressed " + String.valueOf(second);
            }
        };
    }

    public static float positiveAxis(float value) {
        return value < 0.0f ? 0.0f : value;
    }

    public static float negativeAxis(float value) {
        return value > 0.0f ? 0.0f : -value;
    }

    public static float mapShortToFloat(short value) {
        return class_3532.method_37958((float)value, (float)-32768.0f, (float)0.0f, (float)-1.0f, (float)0.0f) + class_3532.method_37958((float)value, (float)0.0f, (float)32767.0f, (float)0.0f, (float)1.0f);
    }

    private static enum URIOpener {
        WINDOWS(class_156.class_158.field_1133),
        OSX(class_156.class_158.field_1137),
        LINUX(class_156.class_158.field_1135),
        SOLARIS(class_156.class_158.field_1134);

        private final class_156.class_158 mcOS;

        private URIOpener(class_156.class_158 mcOS) {
            this.mcOS = mcOS;
        }

        public String[] openArguments(URI uri) {
            String[] stringArray;
            switch (this.mcOS) {
                case field_1133: {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "rundll32";
                    stringArray2[1] = "url.dll,FileProtocolHandler";
                    stringArray = stringArray2;
                    stringArray2[2] = uri.toString();
                    break;
                }
                case field_1137: {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "open";
                    stringArray = stringArray3;
                    stringArray3[1] = uri.toString();
                    break;
                }
                case field_1135: 
                case field_1134: {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = "xdg-open";
                    stringArray = stringArray4;
                    stringArray4[1] = uri.toString();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported OS: " + String.valueOf(this.mcOS));
                }
            }
            return stringArray;
        }

        public static URIOpener get() {
            return switch (class_156.method_668()) {
                case class_156.class_158.field_1133 -> WINDOWS;
                case class_156.class_158.field_1137 -> OSX;
                case class_156.class_158.field_1135 -> LINUX;
                case class_156.class_158.field_1134 -> SOLARIS;
                default -> throw new UnsupportedOperationException("Unsupported OS: " + String.valueOf(class_156.method_668()));
            };
        }
    }
}

