/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.DebugOverlayHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_481;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_748;

public final class RadialItems {
    public static final RadialMenuScreen.RadialItem EMPTY_ACTION = new RadialItemRecord((class_2561)class_2561.method_43473(), RadialIcon.EMPTY, () -> false, RadialIcons.EMPTY);

    public static RadialMenuScreen.RadialItem[] createBindings(ControllerEntity controller) {
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[8];
        for (int i = 0; i < 8; ++i) {
            class_2960 bindingId = ((InputComponent.Config)controller.input().orElseThrow().confObj()).radialActions[i];
            items[i] = RadialItems.getItemForBinding(bindingId, controller);
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createGameModes() {
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[]{new GameModeItem(class_1934.field_9220), new GameModeItem(class_1934.field_9215), new GameModeItem(class_1934.field_9216), new GameModeItem(class_1934.field_9219)};
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarSave() {
        class_310 mc = class_310.method_1551();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < 9; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((class_2561)class_2561.method_43469((String)"controlify.radial.hotbar", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(j + 1))}), RadialItems.getIconForHotbar(i, true), () -> {
                class_481.method_2462((class_310)mc, (int)j, (boolean)false, (boolean)true);
                return true;
            }, CUtil.rl("hotbar_save/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarLoad() {
        class_310 mc = class_310.method_1551();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < items.length; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((class_2561)class_2561.method_43469((String)"controlify.radial.hotbar", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(j + 1))}), RadialItems.getIconForHotbar(i, true), () -> {
                class_481.method_2462((class_310)mc, (int)j, (boolean)true, (boolean)false);
                return true;
            }, CUtil.rl("hotbar_load/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarItemSelect() {
        class_310 mc = class_310.method_1551();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < items.length; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((class_2561)class_2561.method_43469((String)"controlify.radial.hotbar", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(j + 1))}), (graphics, x, y, tickDelta) -> graphics.method_51427(mc.field_1724.method_31548().method_5438(j), x, y), () -> {
                mc.field_1724.method_31548().method_61496(j);
                return true;
            }, CUtil.rl("hotbar_item_select/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createDebug() {
        RadialMenuScreen.RadialItem[] radialItemArray;
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[]{new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.reload_chunks"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8251)), () -> {
            DebugOverlayHelper.reloadChunks();
            return true;
        }, CUtil.rl("debug/reload_chunks")), new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.chunk_borders"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8204)), () -> {
            DebugOverlayHelper.toggleChunkBorders();
            return true;
        }, CUtil.rl("debug/chunk_borders")), new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.advanced_tooltips"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8674)), () -> {
            DebugOverlayHelper.toggleAdvancedTooltips();
            return true;
        }, CUtil.rl("debug/advanced_tooltips")), new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.entity_hitboxes"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8470)), () -> {
            DebugOverlayHelper.toggleEntityHitboxes();
            return true;
        }, CUtil.rl("debug/entity_hitboxes")), new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.reload_packs"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8330)), () -> {
            DebugOverlayHelper.reloadResourcePacks();
            return true;
        }, CUtil.rl("debug/reload_packs")), new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.clear_chat"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8884)), () -> {
            DebugOverlayHelper.clearChat();
            return true;
        }, CUtil.rl("debug/clear_chat")), new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.profile"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8238)), () -> {
            DebugOverlayHelper.startStopProfiling();
            return true;
        }, CUtil.rl("debug/profile"))};
        boolean overlayEnabled = DebugOverlayHelper.isOverlayEnabled();
        if (!overlayEnabled) {
            RadialMenuScreen.RadialItem[] radialItemArray2 = new RadialMenuScreen.RadialItem[4];
            radialItemArray2[0] = new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.overlay"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8688)), () -> {
                DebugOverlayHelper.toggleOverlay();
                return true;
            }, CUtil.rl("debug/overlay"));
            radialItemArray2[1] = new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.overlay_fps"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_8557)), () -> {
                DebugOverlayHelper.toggleFpsOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
            radialItemArray2[2] = new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.overlay_net"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_28101)), () -> {
                DebugOverlayHelper.toggleNetworkOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
            radialItemArray = radialItemArray2;
            radialItemArray2[3] = new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.overlay_prof"), RadialIcons.getIcons().get(RadialIcons.getItem(class_1802.field_22420)), () -> {
                DebugOverlayHelper.toggleProfilerOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
        } else {
            RadialMenuScreen.RadialItem[] radialItemArray3 = new RadialMenuScreen.RadialItem[1];
            radialItemArray = radialItemArray3;
            radialItemArray3[0] = new RadialItemRecord((class_2561)class_2561.method_43471((String)"controlify.radial.debug.hide_overlay"), RadialIcons.getIcons().get(RadialIcons.getEffect((class_6880<class_1291>)class_1294.field_5905)), () -> {
                DebugOverlayHelper.toggleOverlay();
                return true;
            }, CUtil.rl("debug/reload_chunks"));
        }
        RadialMenuScreen.RadialItem[] overlayItems = radialItemArray;
        RadialMenuScreen.RadialItem[] allItems = new RadialMenuScreen.RadialItem[items.length + overlayItems.length];
        System.arraycopy(overlayItems, 0, allItems, 0, overlayItems.length);
        System.arraycopy(items, 0, allItems, overlayItems.length, items.length);
        return allItems;
    }

    private static RadialIcon getIconForHotbar(int hotbarIndex, boolean showNumbers) {
        class_310 mc = class_310.method_1551();
        class_748 hotbar = mc.method_1571().method_1410(hotbarIndex);
        List hotbarItems = hotbar.method_56839((class_7225.class_7874)mc.field_1724.method_56673());
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = (class_1799)hotbarItems.get(i);
            if (stack.method_31574(class_1802.field_8162)) continue;
            return (graphics, x, y, tickDelta) -> {
                graphics.method_51427(stack, x, y);
                if (showNumbers) {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
                    graphics.method_25303(mc.field_1772, Integer.toString(hotbarIndex + 1), x, y, -1);
                    graphics.method_51448().method_22909();
                }
            };
        }
        return (graphics, x, y, tickDelta) -> {
            if (showNumbers) {
                graphics.method_25303(mc.field_1772, Integer.toString(hotbarIndex + 1), x, y, -1);
            }
        };
    }

    private static RadialMenuScreen.RadialItem getItemForBinding(class_2960 id, ControllerEntity controller) {
        InputBinding binding = controller.input().orElseThrow().getBinding(id);
        if (binding == null || binding.radialIcon().isEmpty()) {
            CUtil.LOGGER.warn("Binding {} does not exist or is not a radial candidate", binding);
            return EMPTY_ACTION;
        }
        RadialIcon icon = RadialIcons.getIcons().get(binding.radialIcon().get());
        return new RadialItemRecord(binding.name(), icon, () -> {
            binding.fakePress();
            return true;
        }, id);
    }

    private static class GameModeItem
    implements RadialMenuScreen.RadialItem {
        private final class_1934 gameType;
        private final class_2561 name;
        private final RadialIcon icon;
        private final String command;

        public GameModeItem(class_1934 gameType) {
            this.gameType = gameType;
            this.name = gameType.method_32763();
            class_2960 iconId = switch (gameType) {
                default -> throw new IncompatibleClassChangeError();
                case class_1934.field_9220 -> RadialIcons.getItem(class_1802.field_8270);
                case class_1934.field_9215 -> RadialIcons.getItem(class_1802.field_8371);
                case class_1934.field_9216 -> RadialIcons.getItem(class_1802.field_8895);
                case class_1934.field_9219 -> RadialIcons.getItem(class_1802.field_8449);
            };
            this.icon = RadialIcons.getIcons().get(iconId);
            this.command = switch (gameType) {
                default -> throw new IncompatibleClassChangeError();
                case class_1934.field_9220 -> "gamemode creative";
                case class_1934.field_9215 -> "gamemode survival";
                case class_1934.field_9216 -> "gamemode adventure";
                case class_1934.field_9219 -> "gamemode spectator";
            };
        }

        @Override
        public class_2561 name() {
            return this.name;
        }

        @Override
        public RadialIcon icon() {
            return this.icon;
        }

        @Override
        public boolean playAction() {
            class_310 client = class_310.method_1551();
            if (client.field_1761 != null && client.field_1724 != null && client.field_1724.method_64475(2) && client.field_1761.method_2920() != this.gameType) {
                client.field_1724.field_3944.method_45731(this.command);
                return true;
            }
            return false;
        }
    }

    private record RadialItemRecord(class_2561 name, RadialIcon icon, Supplier<Boolean> action, class_2960 id) implements RadialMenuScreen.RadialItem
    {
        @Override
        public boolean playAction() {
            return this.action.get();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RadialItemRecord) {
                RadialItemRecord record = (RadialItemRecord)obj;
                return this.id.equals((Object)record.id);
            }
            return false;
        }
    }

    public static class BindingEditMode
    implements RadialMenuScreen.EditMode {
        private final ControllerEntity controller;

        public BindingEditMode(ControllerEntity controller) {
            this.controller = controller;
        }

        @Override
        public void setRadialItem(int index, RadialMenuScreen.RadialItem item) {
            ((InputComponent.Config)this.controller.input().orElseThrow().confObj()).radialActions[index] = ((RadialItemRecord)item).id();
        }

        @Override
        public List<RadialMenuScreen.RadialItem> getEditCandidates() {
            ArrayList<RadialMenuScreen.RadialItem> items = new ArrayList<RadialMenuScreen.RadialItem>();
            this.controller.input().orElseThrow().getAllBindings().forEach(binding -> binding.radialIcon().ifPresent(icon -> items.add(new RadialItemRecord(binding.name(), RadialIcons.getIcons().get(icon), () -> false, binding.id()))));
            return items;
        }
    }
}

