/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.battery.BatteryLevelComponent;
import dev.isxander.controlify.controller.battery.PowerState;
import dev.isxander.controlify.controller.dualsense.DualSenseComponent;
import dev.isxander.controlify.controller.haptic.CompleteSoundData;
import dev.isxander.controlify.controller.haptic.HDHapticComponent;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.info.DriverNameComponent;
import dev.isxander.controlify.controller.info.GUIDComponent;
import dev.isxander.controlify.controller.info.UIDComponent;
import dev.isxander.controlify.controller.misc.BluetoothDeviceComponent;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.controller.rumble.TriggerRumbleComponent;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.sdl.DecodedGUID;
import dev.isxander.controlify.driver.sdl.SDLJoystickConnectionState;
import dev.isxander.controlify.driver.sdl.dualsense.DS5EffectsState;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import dev.isxander.sdl3java.api.audio.SDL_AudioDeviceID;
import dev.isxander.sdl3java.api.audio.SDL_AudioFormat;
import dev.isxander.sdl3java.api.audio.SDL_AudioSpec;
import dev.isxander.sdl3java.api.audio.SDL_AudioStream;
import dev.isxander.sdl3java.api.audio.SdlAudio;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.guid.SDL_GUID;
import dev.isxander.sdl3java.api.guid.SdlGuid;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickGUID;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import dev.isxander.sdl3java.api.properties.SdlProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_156;
import org.jetbrains.annotations.Nullable;

public abstract class SDLCommonDriver<SDL_Controller>
implements Driver {
    private static final int AUDIO_STREAM_TIMEOUT_TICKS = 360000;
    private final ControlifyLogger logger;
    protected SDL_Controller ptrController;
    protected BatteryLevelComponent batteryLevelComponent;
    protected RumbleComponent rumbleComponent;
    protected TriggerRumbleComponent triggerRumbleComponent;
    protected HDHapticComponent hdHapticComponent;
    protected DualSenseComponent dualSenseComponent;
    protected final boolean isRumbleSupported;
    protected final boolean isTriggerRumbleSupported;
    protected final boolean isDualsense;
    protected final SDL_JoystickGUID guid;
    protected final String guidString;
    @Nullable
    protected final String serial;
    protected final String name;
    protected final SDL_PropertiesID props;
    protected final short vendorId;
    protected final short productId;
    protected final SDLJoystickConnectionState connectionState;
    @Nullable
    protected SDL_AudioDeviceID dualsenseAudioDev;
    @Nullable
    protected SDL_AudioSpec dualsenseAudioSpec;
    protected final List<AudioStreamHandle> dualsenseAudioHandles;

    public SDLCommonDriver(SDL_Controller ptrController, SDL_JoystickID jid, ControllerType type, ControlifyLogger logger) {
        this.ptrController = ptrController;
        this.logger = logger;
        this.props = this.SDL_GetControllerProperties(ptrController);
        this.name = this.SDL_GetControllerName(ptrController);
        this.guid = this.SDL_GetControllerGUIDForID(jid);
        this.guidString = SdlGuid.SDL_GUIDToString((SDL_GUID)this.guid);
        logger.debugLog("SDL GUID: {}", this.guidString);
        this.serial = this.SDL_GetControllerSerial(ptrController);
        logger.debugLog("SDL Serial: {}", this.serial);
        this.vendorId = this.SDL_GetControllerVendor(ptrController);
        this.productId = this.SDL_GetControllerProduct(ptrController);
        logger.debugLog("SDL VID: {} PID: {}", this.vendorId, this.productId);
        this.connectionState = SDLJoystickConnectionState.fromInt(this.SDL_GetControllerConnectionState(ptrController));
        logger.debugLog("SDL Connection State: {}", new Object[]{this.connectionState});
        this.isRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)this.props, (String)"SDL.joystick.cap.rumble", (boolean)false);
        this.isTriggerRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)this.props, (String)"SDL.joystick.cap.trigger_rumble", (boolean)false);
        DecodedGUID decodedGuid = DecodedGUID.fromGUID((SDL_GUID)this.guid);
        logger.log("SDL GUID driver signature: {}", decodedGuid.getDriverHint());
        this.dualsenseAudioHandles = new ArrayList<AudioStreamHandle>();
        if (CUtil.rl("dualsense").equals((Object)type.namespace())) {
            this.isDualsense = true;
            logger.debugLog("DualSense controller detected.");
            if (class_156.method_668() != class_156.class_158.field_1137) {
                SDL_AudioDeviceID dualsenseAudioDev = null;
                SDL_AudioSpec.ByReference devSpec = new SDL_AudioSpec.ByReference();
                for (SDL_AudioDeviceID dev : SdlAudio.SDL_GetAudioPlaybackDevices()) {
                    String name = SdlAudio.SDL_GetAudioDeviceName((SDL_AudioDeviceID)dev).toLowerCase();
                    if (!name.contains("dualsense") && !name.contains("ps5") && !name.contains("wireless controller")) continue;
                    SdlAudio.SDL_GetAudioDeviceFormat((SDL_AudioDeviceID)dev, (SDL_AudioSpec.ByReference)devSpec, null);
                    if (devSpec.channels != 4) continue;
                    dualsenseAudioDev = dev;
                    break;
                }
                if (dualsenseAudioDev != null) {
                    logger.debugLog("DualSense HD Haptics audio device found.");
                    this.dualsenseAudioSpec = devSpec;
                    this.dualsenseAudioDev = SdlAudio.SDL_OpenAudioDevice(dualsenseAudioDev, (SDL_AudioSpec.ByReference)((SDL_AudioSpec.ByReference)this.dualsenseAudioSpec));
                } else {
                    logger.debugLog("DualSense HD Haptics audio device not found.");
                }
            }
        } else {
            this.isDualsense = false;
        }
    }

    @Override
    public void addComponents(ControllerEntity controller) {
        controller.setComponent(new DriverNameComponent(this.name));
        controller.setComponent(new GUIDComponent(this.guidString));
        controller.setComponent(new UIDComponent(this.createUid()));
        this.batteryLevelComponent = new BatteryLevelComponent();
        controller.setComponent(this.batteryLevelComponent);
        if (this.isRumbleSupported) {
            this.rumbleComponent = new RumbleComponent();
            controller.setComponent(this.rumbleComponent);
        }
        if (this.isTriggerRumbleSupported) {
            this.triggerRumbleComponent = new TriggerRumbleComponent();
            controller.setComponent(this.triggerRumbleComponent);
        }
        if (this.isDualsense) {
            this.dualSenseComponent = new DualSenseComponent();
            controller.setComponent(this.dualSenseComponent);
        }
        if (this.dualsenseAudioDev != null) {
            this.hdHapticComponent = new HDHapticComponent();
            controller.setComponent(this.hdHapticComponent);
            this.hdHapticComponent.acceptPlayHaptic(this::playHaptic);
        }
        if (this.isBluetooth()) {
            controller.setComponent(new BluetoothDeviceComponent());
        }
    }

    @Override
    public void update(ControllerEntity controller, boolean outOfFocus) {
        if (this.ptrController == null) {
            throw new IllegalStateException("Tried to update controller when it's closed.");
        }
        this.updateRumble();
        this.updateBatteryLevel();
        this.updateDualSense();
        this.updateHDHaptic();
    }

    @Override
    public void close() {
        if (this.ptrController == null) {
            throw new IllegalStateException("Tried to close controller when it's already closed.");
        }
        this.SDL_CloseController(this.ptrController);
        this.ptrController = null;
        if (this.dualsenseAudioDev != null) {
            SdlAudio.SDL_CloseAudioDevice((SDL_AudioDeviceID)this.dualsenseAudioDev);
            this.dualsenseAudioDev = null;
            for (AudioStreamHandle handle : this.dualsenseAudioHandles) {
                handle.close();
            }
        }
    }

    protected void updateRumble() {
        Optional<Record> stateOpt;
        if (this.isRumbleSupported) {
            stateOpt = this.rumbleComponent.consumeRumble();
            stateOpt.ifPresent(state -> {
                if (!this.SDL_RumbleController(this.ptrController, state.strong(), state.weak(), 5000)) {
                    CUtil.LOGGER.error("Could not rumble gamepad: {}", SdlError.SDL_GetError());
                }
            });
        }
        if (this.isTriggerRumbleSupported) {
            stateOpt = this.triggerRumbleComponent.consumeTriggerRumble();
            stateOpt.ifPresent(state -> {
                if (!this.SDL_RumbleControllerTriggers(this.ptrController, state.left(), state.right(), 0)) {
                    CUtil.LOGGER.error("Could not rumble triggers gamepad: {}", SdlError.SDL_GetError());
                }
            });
        }
    }

    private void updateBatteryLevel() {
        IntByReference percent = new IntByReference();
        int powerState = this.SDL_GetControllerPowerInfo(this.ptrController, percent);
        Record level = switch (powerState) {
            case -1, 0 -> new PowerState.Unknown();
            case 1 -> new PowerState.Depleting(percent.getValue());
            case 2 -> new PowerState.WiredOnly();
            case 3 -> new PowerState.Charging(percent.getValue());
            case 4 -> new PowerState.Full();
            default -> throw new IllegalStateException("Unexpected value");
        };
        this.batteryLevelComponent.setBatteryLevel((PowerState)((Object)level));
    }

    private void updateDualSense() {
        if (this.dualSenseComponent == null) {
            return;
        }
        DS5EffectsState.ByValue effectsState = new DS5EffectsState.ByValue();
        if (this.dualSenseComponent.consumeDirty()) {
            effectsState.ucEnableBits1 = (byte)(effectsState.ucEnableBits1 | 8);
            effectsState.rgucLeftTriggerEffect = this.dualSenseComponent.getLeftTriggerEffect();
            effectsState.ucEnableBits1 = (byte)(effectsState.ucEnableBits1 | 4);
            effectsState.rgucRightTriggerEffect = this.dualSenseComponent.getRightTriggerEffect();
            effectsState.ucEnableBits2 = (byte)(effectsState.ucEnableBits2 | 1);
            effectsState.ucMicLightMode = DS5EffectsState.MuteLightState.fromBoolean(this.dualSenseComponent.getMuteLight());
            effectsState.write();
            this.SDL_SendControllerEffect(this.ptrController, effectsState.getPointer(), Native.getNativeSize(DS5EffectsState.ByValue.class));
        }
    }

    private void updateHDHaptic() {
        for (int i = 0; i < this.dualsenseAudioHandles.size(); ++i) {
            AudioStreamHandle handle = this.dualsenseAudioHandles.get(i);
            if (handle.isTimedOut()) {
                handle.close();
                this.dualsenseAudioHandles.remove(handle);
                continue;
            }
            handle.tick();
        }
    }

    private void playHaptic(CompleteSoundData sound) {
        if (this.ptrController == null || this.dualsenseAudioDev == null || this.dualsenseAudioSpec == null) {
            return;
        }
        SDL_AudioSpec spec = new SDL_AudioSpec();
        spec.channels = sound.format().getChannels();
        spec.freq = (int)sound.format().getSampleRate();
        int ss = sound.format().getSampleSizeInBits();
        int byteSs = ss / 8;
        AudioFormat.Encoding encoding = sound.format().getEncoding();
        if (ss == 8) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat(32776L);
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                spec.format = new SDL_AudioFormat(8L);
            }
        } else if (sound.format().isBigEndian()) {
            SDLCommonDriver.audioFmtEndian(spec, ss, encoding, 36880, 36896, 37152);
        } else {
            SDLCommonDriver.audioFmtEndian(spec, ss, encoding, 32784, 32800, 33056);
        }
        if (spec.format == null) {
            throw new IllegalStateException("Unsupported format");
        }
        AudioStreamHandle handle = null;
        for (AudioStreamHandle stream : this.dualsenseAudioHandles) {
            SDL_AudioSpec streamSpec = stream.getSpec();
            if (streamSpec.format.intValue() != spec.format.intValue() || streamSpec.freq != spec.freq || streamSpec.channels != spec.channels || stream.isInUse()) continue;
            handle = stream;
            break;
        }
        int length = sound.audio().length / spec.freq / spec.channels / byteSs * 20;
        if (handle != null) {
            handle.queueAudio(sound.audio(), length);
        } else {
            if (this.dualsenseAudioHandles.size() >= 16) {
                this.dualsenseAudioHandles.remove(0).close();
            }
            AudioStreamHandle newHandle = AudioStreamHandle.createWithAudio(this.dualsenseAudioDev, spec, this.dualsenseAudioSpec, sound.audio(), length);
            this.dualsenseAudioHandles.add(newHandle);
        }
    }

    protected String createUid() {
        int identifiers = 0;
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        if (this.vendorId != 0 && this.productId != 0) {
            bytes.add(new byte[]{(byte)(this.vendorId >> 8), (byte)this.vendorId, (byte)(this.productId >> 8), (byte)this.productId});
            ++identifiers;
        }
        if (this.serial != null) {
            bytes.add(this.serial.getBytes());
            ++identifiers;
        }
        if (identifiers == 0) {
            bytes.add((byte[])this.guid.data.clone());
        }
        Object uid = CUtil.createUIDFromBytes((byte[][])bytes.toArray((T[])new byte[0][]));
        String nonDuplicateUid = uid;
        int duplicateCount = (int)Controlify.instance().getControllerManager().orElseThrow().getConnectedControllers().stream().filter(controller -> controller.uid().startsWith(nonDuplicateUid)).count();
        if (duplicateCount > 0) {
            uid = (String)uid + "-" + duplicateCount;
        }
        return uid;
    }

    protected boolean isBluetooth() {
        return this.connectionState == SDLJoystickConnectionState.WIRELESS;
    }

    protected abstract SDL_PropertiesID SDL_GetControllerProperties(SDL_Controller var1);

    protected abstract String SDL_GetControllerName(SDL_Controller var1);

    protected abstract SDL_JoystickGUID SDL_GetControllerGUIDForID(SDL_JoystickID var1);

    @Nullable
    protected abstract String SDL_GetControllerSerial(SDL_Controller var1);

    protected abstract short SDL_GetControllerVendor(SDL_Controller var1);

    protected abstract short SDL_GetControllerProduct(SDL_Controller var1);

    protected abstract int SDL_GetControllerConnectionState(SDL_Controller var1);

    protected abstract boolean SDL_CloseController(SDL_Controller var1);

    protected abstract boolean SDL_RumbleController(SDL_Controller var1, float var2, float var3, int var4);

    protected abstract boolean SDL_RumbleControllerTriggers(SDL_Controller var1, float var2, float var3, int var4);

    protected abstract int SDL_GetControllerPowerInfo(SDL_Controller var1, IntByReference var2);

    protected abstract boolean SDL_SendControllerEffect(SDL_Controller var1, Pointer var2, int var3);

    private static void audioFmtEndian(SDL_AudioSpec spec, int ss, AudioFormat.Encoding encoding, int signed16, int signed32, int float32) {
        if (ss == 16) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat((long)signed16);
            }
        } else if (ss == 32) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat((long)signed32);
            } else if (encoding == AudioFormat.Encoding.PCM_FLOAT) {
                spec.format = new SDL_AudioFormat((long)float32);
            }
        }
    }

    protected static class AudioStreamHandle {
        private int streamLastPlayed;
        private final SDL_AudioStream stream;
        private final SDL_AudioSpec spec;

        private AudioStreamHandle(SDL_AudioStream stream, SDL_AudioSpec spec) {
            this.stream = stream;
            this.spec = spec;
            this.streamLastPlayed = 0;
        }

        public void queueAudio(byte[] audio, int tickLength) {
            try (Memory memory = new Memory((long)audio.length);){
                memory.write(0L, audio, 0, audio.length);
                SdlAudio.SDL_PutAudioStreamData((SDL_AudioStream)this.stream, (Pointer)memory, (int)audio.length);
                this.streamLastPlayed = Math.min(0, this.streamLastPlayed);
                this.streamLastPlayed -= tickLength;
            }
        }

        public SDL_AudioSpec getSpec() {
            return this.spec;
        }

        public boolean isInUse() {
            return this.streamLastPlayed < 0;
        }

        public boolean isTimedOut() {
            return this.streamLastPlayed >= 360000;
        }

        public void tick() {
            ++this.streamLastPlayed;
        }

        public void close() {
            SdlAudio.SDL_DestroyAudioStream((SDL_AudioStream)this.stream);
        }

        public static AudioStreamHandle createWithAudio(SDL_AudioDeviceID device, SDL_AudioSpec audioSpec, SDL_AudioSpec devSpec, byte[] audio, int tickLength) {
            int[] nArray;
            SDL_AudioStream stream = SdlAudio.SDL_CreateAudioStream((SDL_AudioSpec)audioSpec, (SDL_AudioSpec)devSpec);
            SdlAudio.SDL_BindAudioStream((SDL_AudioDeviceID)device, (SDL_AudioStream)stream);
            switch (audioSpec.channels) {
                case 1: {
                    int[] nArray2 = new int[4];
                    nArray2[0] = -1;
                    nArray2[1] = -1;
                    nArray2[2] = 0;
                    nArray = nArray2;
                    nArray2[3] = 0;
                    break;
                }
                case 2: {
                    int[] nArray3 = new int[4];
                    nArray3[0] = -1;
                    nArray3[1] = -1;
                    nArray3[2] = 0;
                    nArray = nArray3;
                    nArray3[3] = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported channel count " + audioSpec.channels);
                }
            }
            int[] channelMap = nArray;
            if (!SdlAudio.SDL_SetAudioStreamOutputChannelMap((SDL_AudioStream)stream, (int[])channelMap)) {
                System.out.println(SdlError.SDL_GetError());
            }
            AudioStreamHandle handle = new AudioStreamHandle(stream, audioSpec);
            handle.queueAudio(audio, tickLength);
            return handle;
        }
    }
}

