/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.sign_text_buffering;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1044;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL30C;

public class SignAtlasFramebuffer
extends class_276
implements AutoCloseable {
    private static int nextId = 0;
    public static final int ATLAS_SIZE = 4096;
    private final class_2960 textureId;
    private final Slot rootSlot;

    public SignAtlasFramebuffer() {
        super("ImmediatelyFast Sign Atlas FBO", false);
        this.method_1234(4096, 4096);
        this.textureId = class_2960.method_60655((String)"immediatelyfast", (String)("sign_atlas/" + nextId++));
        class_310.method_1551().method_1531().method_4616(this.textureId, (class_1044)new FboTexture(this));
        this.rootSlot = new Slot(null, 0, 0, 4096, 4096);
    }

    public int bind(boolean setViewport) {
        int previousFramebuffer = GL11C.glGetInteger((int)36006);
        int fbo = ((class_10868)this.field_1475).method_68426(((class_10865)RenderSystem.getDevice()).method_68401(), null);
        GL30C.glBindFramebuffer((int)36160, (int)fbo);
        if (setViewport) {
            GL11C.glViewport((int)0, (int)0, (int)4096, (int)4096);
        }
        return previousFramebuffer;
    }

    public void unbind(int previousFbo) {
        GL30C.glBindFramebuffer((int)36160, (int)previousFbo);
        GL11C.glViewport((int)0, (int)0, (int)class_310.method_1551().method_22683().method_4489(), (int)class_310.method_1551().method_22683().method_4506());
    }

    @Override
    public void close() {
        this.method_1238();
    }

    public Slot findSlot(int width, int height) {
        return this.rootSlot.findSlot(width, height);
    }

    public void clearAtlas() {
        RenderSystem.getDevice().createCommandEncoder().clearColorTexture(this.method_30277(), 0);
        this.rootSlot.subSlot1 = null;
        this.rootSlot.subSlot2 = null;
    }

    public class_2960 getTextureId() {
        return this.textureId;
    }

    private class FboTexture
    extends class_1044 {
        private FboTexture(SignAtlasFramebuffer signAtlasFramebuffer) {
            this.field_56974 = signAtlasFramebuffer.field_1475;
        }

        public void close() {
        }
    }

    public class Slot {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final Slot parentSlot;
        public Slot subSlot1;
        public Slot subSlot2;
        public boolean occupied;

        public Slot(Slot parentSlot, int x, int y, int width, int height) {
            this.parentSlot = parentSlot;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void markFree() {
            if (this.subSlot1 != null || this.subSlot2 != null) {
                throw new UnsupportedOperationException("Cannot mark slot as free if it has sub slots");
            }
            if (!this.occupied) {
                throw new UnsupportedOperationException("Cannot mark slot as free if it is not occupied");
            }
            this.occupied = false;
            Slot.removeUnoccupiedSubSlots(this);
            GlStateManager._scissorBox((int)this.x, (int)(4096 - this.y - this.height), (int)this.width, (int)this.height);
            GlStateManager._enableScissorTest();
            int previousFbo = SignAtlasFramebuffer.this.bind(false);
            GL11C.glClear((int)16384);
            SignAtlasFramebuffer.this.unbind(previousFbo);
            GlStateManager._disableScissorTest();
        }

        public Slot findSlot(int width, int height) {
            if (this.subSlot1 != null && this.subSlot2 != null) {
                Slot slot = this.subSlot1.findSlot(width, height);
                if (slot == null) {
                    slot = this.subSlot2.findSlot(width, height);
                }
                return slot;
            }
            if (this.occupied) {
                return null;
            }
            if (width > this.width || height > this.height) {
                return null;
            }
            if (width == this.width && height == this.height) {
                this.occupied = true;
                return this;
            }
            int k = this.width - width;
            int l = this.height - height;
            if (k > l) {
                this.subSlot1 = new Slot(this, this.x, this.y, width, this.height);
                this.subSlot2 = new Slot(this, this.x + width, this.y, this.width - width, this.height);
            } else {
                this.subSlot1 = new Slot(this, this.x, this.y, this.width, height);
                this.subSlot2 = new Slot(this, this.x, this.y + height, this.width, this.height - height);
            }
            return this.subSlot1.findSlot(width, height);
        }

        private static void removeUnoccupiedSubSlots(Slot slot) {
            boolean subSlot2Unoccupied;
            if (slot == null) {
                return;
            }
            Slot.removeUnoccupiedSubSlots(slot.parentSlot);
            boolean subSlot1Unoccupied = slot.subSlot1 != null && !Slot.hasOccupiedSlot(slot.subSlot1);
            boolean bl = subSlot2Unoccupied = slot.subSlot2 != null && !Slot.hasOccupiedSlot(slot.subSlot2);
            if (subSlot1Unoccupied && subSlot2Unoccupied) {
                slot.subSlot1 = null;
                slot.subSlot2 = null;
            }
        }

        private static boolean hasOccupiedSlot(Slot slot) {
            if (slot == null) {
                return false;
            }
            if (slot.occupied) {
                return true;
            }
            return Slot.hasOccupiedSlot(slot.subSlot1) || Slot.hasOccupiedSlot(slot.subSlot2);
        }
    }
}

