/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.event.Event;
import dev.yumi.commons.event.SubsetInvoker;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilteredEvent<I extends Comparable<? super I>, T, C>
extends Event<I, T> {
    private final ReferenceQueue<SubsetInvoker<I, T, C>> queue = new ReferenceQueue();
    private final Set<WeakReference<SubsetInvoker<I, T, C>>> subsets = new HashSet<WeakReference<SubsetInvoker<I, T, C>>>();

    FilteredEvent(@NotNull Class<? super T> type, @NotNull I defaultPhaseId, @NotNull Function<T[], T> invokerFactory) {
        super(type, defaultPhaseId, invokerFactory);
    }

    @Override
    public void register(@NotNull T listener, @NotNull Predicate<C> filter) {
        this.register(this.defaultPhaseId(), listener, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NotNull I phaseIdentifier, @NotNull T listener, @NotNull Predicate<C> filter) {
        Objects.requireNonNull(phaseIdentifier, "Cannot register a listener for a null phase.");
        Objects.requireNonNull(listener, "Cannot register a null listener.");
        Objects.requireNonNull(filter, "Cannot register a listener with a null context filter.");
        this.lock.lock();
        try {
            ((FilteredPhaseData)this.getOrCreatePhase((Comparable)phaseIdentifier, true)).addListener(new Listener<T, C>(listener, filter));
            this.rebuildInvoker(this.listeners.length);
        }
        finally {
            this.lock.unlock();
        }
    }

    public SubsetInvoker<I, T, C> forContext(C context) {
        SubsetInvoker subset = new SubsetInvoker(this, context);
        this.lock.lock();
        try {
            this.purge();
            this.subsets.add(new WeakReference<SubsetInvoker<I, T, C>>(subset, this.queue));
        }
        finally {
            this.lock.unlock();
        }
        return subset;
    }

    FilteredPhaseData getOrCreatePhase(@NotNull I id, boolean sortIfCreate) {
        Event.PhaseData phase = (Event.PhaseData)((Object)this.phases.get(id));
        if (phase == null) {
            phase = new FilteredPhaseData(this, id, this.type());
            this.phases.put(id, phase);
            this.sortedPhases.add(phase);
            if (sortIfCreate) {
                this.sortPhases();
            }
        }
        return (FilteredPhaseData)phase;
    }

    @Override
    void rebuildInvoker(int newLength) {
        super.rebuildInvoker(newLength);
        this.purge();
        for (WeakReference<SubsetInvoker<I, T, C>> subset : this.subsets) {
            SubsetInvoker value = (SubsetInvoker)subset.get();
            if (value == null) continue;
            value.rebuildInvoker();
        }
    }

    private void purge() {
        Reference<SubsetInvoker<I, T, C>> ref = this.queue.poll();
        while (ref != null) {
            this.subsets.remove(ref);
            ref = this.queue.poll();
        }
    }

    @ApiStatus.Internal
    static final class FilteredPhaseData
    extends Event.PhaseData<I, T> {
        Listener<T, C>[] listenersData;
        final /* synthetic */ FilteredEvent this$0;

        FilteredPhaseData(@NotNull I id, Class<? super T> listenerType) {
            this.this$0 = this$0;
            super(id, listenerType);
            this.listenersData = new Listener[0];
        }

        @Override
        void addListener(@NotNull T listener) {
            super.addListener(listener);
            this.addListener(new Listener(listener, null));
        }

        @Override
        void addListener(@NotNull Listener<T, C> listener) {
            int oldLength = this.listenersData.length;
            this.listenersData = Arrays.copyOf(this.listenersData, oldLength + 1);
            this.listenersData[oldLength] = listener;
        }
    }

    @ApiStatus.Internal
    record Listener<T, C>(T listener, @Nullable Predicate<C> selector) {
        boolean shouldListen(C context) {
            return this.selector == null || this.selector.test(context);
        }
    }
}

