/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.Message;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_7940;
import net.minecraft.class_8086;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8662;
import org.jetbrains.annotations.Nullable;

public abstract class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    private static boolean reloadScreen = false;
    public static final Map<String, Class<? extends MidnightConfig>> configClass = new HashMap<String, Class<? extends MidnightConfig>>();
    private static Path path;
    private static final Gson gson;

    @Nullable
    public static Object getDefaultValue(String modid, String entry) {
        for (EntryInfo e : entries) {
            if (!modid.equals(e.modid) || !entry.equals(e.field.getName())) continue;
            return e.defaultValue;
        }
        return null;
    }

    public static void loadValuesFromJson(String modid) {
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), configClass.get(modid));
        }
        catch (Exception e) {
            MidnightConfig.write(modid);
        }
        for (EntryInfo info : entries) {
            if (info.field == null || info.entry == null) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.toTemporaryValue();
                info.updateConditions(info.tempValue);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static void init(String modid, Class<? extends MidnightConfig> config) {
        path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
        configClass.put(modid, config);
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo(field, modid);
            if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && PlatformFunctions.isClientEnv()) {
                MidnightConfig.initClient(modid, field, info);
            }
            if (!field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        MidnightConfig.loadValuesFromJson(modid);
    }

    @Environment(value=EnvType.CLIENT)
    private static void initClient(String modid, Field field, EntryInfo info) {
        Entry e = info.entry;
        if (e != null) {
            if (info.dataType == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (info.dataType == Float.TYPE) {
                MidnightConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (info.dataType == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (info.dataType == String.class || info.dataType == class_2960.class) {
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (info.dataType == Boolean.TYPE) {
                Function<Object, class_2561> func = value -> class_2561.method_43471((String)((Boolean)value != false ? "gui.yes" : "gui.no")).method_27692((Boolean)value != false ? class_124.field_1060 : class_124.field_1061);
                info.function = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    info.setValue((Boolean)info.value == false);
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            } else if (info.dataType.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, class_2561> func = value -> {
                    String translationKey = modid + ".midnightconfig.enum." + info.dataType.getSimpleName() + "." + info.toTemporaryValue();
                    return class_1074.method_4663((String)translationKey) ? class_2561.method_43471((String)translationKey) : class_2561.method_43470((String)info.toTemporaryValue());
                };
                info.function = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            }
        }
        entries.add(info);
    }

    public static Class<?> getUnderlyingType(Field field) {
        Class rawType = field.getType();
        if (field.getType() == List.class) {
            rawType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        try {
            return (Class)rawType.getField("TYPE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return rawType;
        }
    }

    public static class_7919 getTooltip(EntryInfo info, boolean isButton) {
        String key = info.modid + ".midnightconfig." + info.fieldName + (!isButton ? ".label" : "") + ".tooltip";
        return class_7919.method_47407((class_2561)(isButton && info.error != null ? info.error : (class_1074.method_4663((String)key) ? class_2561.method_43471((String)key) : class_2561.method_43473())));
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.function = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : class_2561.method_43470((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))).method_27692(class_124.field_1061);
                t.method_47400(MidnightConfig.getTooltip(info, true));
            }
            info.tempValue = s;
            t.method_1868(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.field_22763 = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                if (info.dataType == class_2960.class) {
                    info.setValue(class_2960.method_12829((String)s));
                } else {
                    info.setValue(isNumber ? value : s);
                }
            }
            if (info.entry.isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.actionButton.method_25355((class_2561)class_2561.method_43470((String)"\u2b1b").method_10862(class_2583.field_24360.method_36139(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static MidnightConfig getClass(String modid) {
        try {
            return configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String modid) {
        MidnightConfig.getClass(modid).writeChanges(modid);
    }

    public void writeChanges(String modid) {
        try {
            path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson((Object)MidnightConfig.getClass(modid)).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class_437 getScreen(class_437 parent, String modid) {
        return new MidnightConfigScreen(parent, modid);
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new NonEntryExclusionStrategy()).registerTypeAdapter(class_2960.class, (Object)new TypeAdapter<class_2960>(){

            public void write(JsonWriter out, class_2960 id) throws IOException {
                out.value(id.toString());
            }

            public class_2960 read(JsonReader in) throws IOException {
                return class_2960.method_60654((String)in.nextString());
            }
        }).setPrettyPrinting().create();
    }

    public static class EntryInfo {
        public Entry entry;
        public Comment comment;
        public Condition condition;
        public final Field field;
        public final Class<?> dataType;
        public final String modid;
        public final String fieldName;
        int listIndex;
        Object defaultValue;
        Object value;
        Object function;
        String tempValue;
        boolean inLimits = true;
        class_2561 name;
        class_2561 error;
        class_339 actionButton;
        class_8087 tab;
        boolean conditionsMet = true;

        public EntryInfo(Field field, String modid) {
            this.field = field;
            this.modid = modid;
            if (field != null) {
                this.fieldName = field.getName();
                this.dataType = MidnightConfig.getUnderlyingType(field);
                this.entry = field.getAnnotation(Entry.class);
                this.comment = field.getAnnotation(Comment.class);
                this.condition = field.getAnnotation(Condition.class);
            } else {
                this.fieldName = "";
                this.dataType = null;
            }
            if (this.entry != null && !this.entry.name().isEmpty()) {
                this.name = class_2561.method_43471((String)this.entry.name());
            } else if (this.comment != null && !this.comment.name().isEmpty()) {
                this.name = class_2561.method_43471((String)this.comment.name());
            }
        }

        public void setValue(Object value) {
            if (this.field.getType() != List.class) {
                this.value = value;
                this.tempValue = value.toString();
            } else {
                this.writeList(this.listIndex, value);
                this.tempValue = this.toTemporaryValue();
            }
        }

        public String toTemporaryValue() {
            if (this.field.getType() != List.class) {
                return this.value.toString();
            }
            try {
                return ((List)this.value).get(this.listIndex).toString();
            }
            catch (Exception ignored) {
                return "";
            }
        }

        public void updateFieldValue() {
            try {
                if (this.field.get(null) != this.value) {
                    this.updateConditions(this.tempValue);
                }
                this.field.set(null, this.value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public void updateConditions(String newTempValue) {
            for (EntryInfo info : entries) {
                boolean prevConditionState = info.conditionsMet;
                if (info.condition != null && ((String)(info.condition.requiredOption().contains(":") ? "" : info.modid + ":") + info.condition.requiredOption()).equals(this.modid + ":" + this.fieldName)) {
                    info.conditionsMet = Objects.equals(info.condition.requiredValue(), newTempValue);
                }
                if (info.condition != null && !info.condition.requiredModId().isEmpty() && !PlatformFunctions.isModLoaded(info.condition.requiredModId())) {
                    info.conditionsMet = false;
                }
                if (prevConditionState == info.conditionsMet) continue;
                reloadScreen = true;
            }
        }

        public <T> void writeList(int index, T value) {
            List list = (List)this.value;
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 400;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public int selectionMode() default -1;

        public int fileChooserType() default 0;

        public String[] fileExtensions() default {"*"};

        public int idMode() default -1;

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";

        public String name() default "";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @Environment(value=EnvType.CLIENT)
    public static class MidnightConfigScreen
    extends class_437 {
        public final String translationPrefix;
        public final String modid;
        public final class_437 parent;
        public MidnightConfigListWidget list;
        public class_8088 tabManager = new class_8088(a -> {}, a -> {});
        public Map<String, class_8087> tabs = new LinkedHashMap<String, class_8087>();
        public class_8087 prevTab;
        public class_8089 tabNavigation;
        public class_4185 done;
        public double scrollProgress = 0.0;

        protected MidnightConfigScreen(class_437 parent, String modid) {
            super((class_2561)class_2561.method_43471((String)(modid + ".midnightconfig.title")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".midnightconfig.";
            MidnightConfig.loadValuesFromJson(modid);
            for (EntryInfo e : entries) {
                if (!e.modid.equals(modid)) continue;
                String tabId = e.entry != null ? e.entry.category() : e.comment.category();
                String name = this.translationPrefix + "category." + tabId;
                if (!class_1074.method_4663((String)name) && tabId.equals("default")) {
                    name = this.translationPrefix + "title";
                }
                if (!this.tabs.containsKey(name)) {
                    class_8086 tab = new class_8086((class_2561)class_2561.method_43471((String)name));
                    e.tab = tab;
                    this.tabs.put(name, (class_8087)tab);
                    continue;
                }
                e.tab = this.tabs.get(name);
            }
            this.tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(this.tabs.values().toArray(new class_8087[0])).method_48627();
            this.tabNavigation.method_48987(0, false);
            this.tabNavigation.method_49613();
            this.prevTab = this.tabManager.method_48614();
        }

        public void method_25393() {
            super.method_25393();
            if (this.prevTab != null && this.prevTab != this.tabManager.method_48614()) {
                this.prevTab = this.tabManager.method_48614();
                this.updateList();
                this.list.method_44382(0.0);
            }
            this.scrollProgress = this.list.method_44387();
            for (EntryInfo info : entries) {
                info.updateFieldValue();
            }
            this.updateButtons();
            if (reloadScreen) {
                this.updateList();
                reloadScreen = false;
            }
        }

        public void updateButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.method_25396()) {
                    class_339 widget;
                    if (entry.buttons == null || entry.buttons.size() <= 1) continue;
                    class_339 class_3392 = entry.buttons.get(0);
                    if (class_3392 instanceof class_339 && ((widget = class_3392).method_25370() || widget.method_49606())) {
                        widget.method_47400(MidnightConfig.getTooltip(entry.info, true));
                    }
                    if (!((class_3392 = entry.buttons.get(1)) instanceof class_4185)) continue;
                    class_4185 button = (class_4185)class_3392;
                    button.field_22763 = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.tabNavigation.method_48988(keyCode)) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void method_25419() {
            MidnightConfig.loadValuesFromJson(this.modid);
            this.cleanup();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }

        private void cleanup() {
            entries.forEach(info -> {
                info.error = null;
                info.value = null;
                info.tempValue = null;
                info.actionButton = null;
                info.listIndex = 0;
                info.tab = null;
                info.inLimits = true;
            });
        }

        public void method_25426() {
            super.method_25426();
            this.tabNavigation.method_48618(this.field_22789);
            this.tabNavigation.method_49613();
            if (this.tabs.size() > 1) {
                this.method_37063((class_364)this.tabNavigation);
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 26, 150, 20).method_46431());
            this.done = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
                for (EntryInfo info : entries) {
                    if (!info.modid.equals(this.modid)) continue;
                    info.updateFieldValue();
                }
                MidnightConfig.write(this.modid);
                this.cleanup();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 26, 150, 20).method_46431());
            this.list = new MidnightConfigListWidget(this.field_22787, this.field_22789, this.field_22790 - 57, 24, 25);
            this.method_25429((class_364)this.list);
            this.fillList();
            if (this.tabs.size() > 1) {
                this.list.renderHeaderSeparator = false;
            }
        }

        public void updateList() {
            this.list.clear();
            this.fillList();
        }

        public void fillList() {
            for (EntryInfo info : entries) {
                if (!info.conditionsMet && info.condition != null && !info.condition.visibleButLocked()) continue;
                if (info.modid.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.method_48614())) {
                    class_2561 name = Objects.requireNonNullElseGet(info.name, () -> class_2561.method_43471((String)(this.translationPrefix + info.fieldName)));
                    class_8662 resetButton = class_8662.method_52723((class_2561)class_2561.method_43471((String)"controls.reset"), button -> {
                        info.value = info.defaultValue;
                        info.listIndex = 0;
                        info.tempValue = info.toTemporaryValue();
                        this.updateList();
                    }, (boolean)true).method_52727(class_2960.method_60655((String)"midnightlib", (String)"icon/reset"), 12, 12).method_52726(20, 20).method_52724();
                    resetButton.method_48229(this.field_22789 - 205 + 150 + 25, 0);
                    if (info.function != null) {
                        Object widget;
                        Entry e = info.entry;
                        if (info.function instanceof Map.Entry) {
                            Map.Entry values = (Map.Entry)info.function;
                            if (info.dataType.isEnum()) {
                                values.setValue(value -> class_2561.method_43471((String)(this.translationPrefix + "enum." + info.dataType.getSimpleName() + "." + info.value.toString())));
                            }
                            widget = class_4185.method_46430((class_2561)((class_2561)((Function)values.getValue()).apply(info.value)), (class_4185.class_4241)((class_4185.class_4241)values.getKey())).method_46434(this.field_22789 - 185, 0, 150, 20).method_46436(MidnightConfig.getTooltip(info, true)).method_46431();
                        } else {
                            widget = e.isSlider() ? new MidnightSliderWidget(this.field_22789 - 185, 0, 150, 20, class_2561.method_30163((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new class_342(this.field_22793, this.field_22789 - 185, 0, 150, 20, (class_2561)class_2561.method_43473());
                        }
                        if (widget instanceof class_342) {
                            class_342 textField = widget;
                            textField.method_1880(e.width());
                            textField.method_1852(info.tempValue);
                            Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                            textField.method_1890(processor);
                        }
                        widget.method_47400(MidnightConfig.getTooltip(info, true));
                        class_4185 cycleButton = null;
                        if (info.field.getType() == List.class) {
                            cycleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(info.listIndex)).method_27692(class_124.field_1065), button -> {
                                List values = (List)info.value;
                                values.remove("");
                                ++info.listIndex;
                                if (info.listIndex > values.size()) {
                                    info.listIndex = 0;
                                }
                                info.tempValue = info.toTemporaryValue();
                                if (info.listIndex == values.size()) {
                                    info.tempValue = "";
                                }
                                this.updateList();
                            }).method_46434(this.field_22789 - 185, 0, 20, 20).method_46431();
                        }
                        if (e.isColor()) {
                            class_4185 colorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b1b"), button -> new Thread(() -> {
                                Color newColor = JColorChooser.showDialog(null, class_2561.method_43471((String)"midnightconfig.colorChooser.title").getString(), Color.decode(!Objects.equals(info.tempValue, "") ? info.tempValue : "#FFFFFF"));
                                if (newColor != null) {
                                    info.setValue("#" + Integer.toHexString(newColor.getRGB()).substring(2));
                                    this.updateList();
                                }
                            }).start()).method_46434(this.field_22789 - 185, 0, 20, 20).method_46431();
                            try {
                                colorButton.method_25355((class_2561)class_2561.method_43470((String)"\u2b1b").method_10862(class_2583.field_24360.method_36139(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.actionButton = colorButton;
                        } else if (e.selectionMode() > -1) {
                            class_8662 explorerButton = class_8662.method_52723((class_2561)class_2561.method_43473(), button -> new Thread(() -> {
                                JFileChooser fileChooser = new JFileChooser(info.tempValue);
                                fileChooser.setFileSelectionMode(e.selectionMode());
                                fileChooser.setDialogType(e.fileChooserType());
                                fileChooser.setDialogTitle(class_2561.method_43471((String)(this.translationPrefix + info.fieldName + ".fileChooser")).getString());
                                if ((e.selectionMode() == 0 || e.selectionMode() == 2) && Arrays.stream(e.fileExtensions()).noneMatch("*"::equals)) {
                                    fileChooser.setFileFilter(new FileNameExtensionFilter(class_2561.method_43471((String)(this.translationPrefix + info.fieldName + ".fileFilter")).getString(), e.fileExtensions()));
                                }
                                if (fileChooser.showDialog(null, null) == 0) {
                                    info.setValue(fileChooser.getSelectedFile().getAbsolutePath());
                                    this.updateList();
                                }
                            }).start(), (boolean)true).method_52727(class_2960.method_60655((String)"midnightlib", (String)"icon/explorer"), 12, 12).method_52726(20, 20).method_52724();
                            explorerButton.method_48229(this.field_22789 - 185, 0);
                            info.actionButton = explorerButton;
                        }
                        if (!info.conditionsMet) {
                            widget.field_22763 = false;
                        }
                        ArrayList widgets = Lists.newArrayList((Object[])new class_339[]{widget, resetButton});
                        if (info.actionButton != null) {
                            if (class_310.field_1703) {
                                info.actionButton.field_22763 = false;
                            }
                            widget.method_25358(widget.method_25368() - 22);
                            widget.method_46421(widget.method_46426() + 22);
                            widgets.add(info.actionButton);
                        }
                        if (cycleButton != null) {
                            if (info.actionButton != null) {
                                info.actionButton.method_46421(info.actionButton.method_46426() + 22);
                            }
                            widget.method_25358(widget.method_25368() - 22);
                            widget.method_46421(widget.method_46426() + 22);
                            widgets.add(cycleButton);
                        }
                        this.list.addButton(widgets, name, info);
                    } else {
                        this.list.addButton(List.of(), name, info);
                    }
                }
                this.list.method_44382(this.scrollProgress);
                this.updateButtons();
            }
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            this.list.method_25394(context, mouseX, mouseY, delta);
            if (this.tabs.size() < 2) {
                context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
            }
        }
    }

    public static class NonEntryExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Condition {
        public String requiredModId() default "";

        public String requiredOption() default "";

        public String requiredValue() default "true";

        public boolean visibleButLocked() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class MidnightSliderWidget
    extends class_357 {
        private final EntryInfo info;
        private final Entry e;

        public MidnightSliderWidget(int x, int y, int width, int height, class_2561 text, double value, EntryInfo info) {
            super(x, y, width, height, text, value);
            this.e = info.entry;
            this.info = info;
        }

        public void method_25346() {
            this.method_25355(class_2561.method_30163((String)this.info.tempValue));
        }

        public void method_25344() {
            if (this.info.dataType == Integer.TYPE) {
                this.info.setValue(((Number)(this.e.min() + this.field_22753 * (this.e.max() - this.e.min()))).intValue());
            } else if (this.info.dataType == Double.TYPE) {
                this.info.setValue((double)Math.round((this.e.min() + this.field_22753 * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (double)this.e.precision());
            } else if (this.info.dataType == Float.TYPE) {
                this.info.setValue(Float.valueOf((float)Math.round((this.e.min() + this.field_22753 * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (float)this.e.precision()));
            }
        }
    }

    public static class ButtonEntry
    extends class_4265.class_4266<ButtonEntry> {
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        public final class_2561 text;
        public final List<class_339> buttons;
        public final EntryInfo info;
        public boolean centered = false;
        public class_7940 title;

        public ButtonEntry(List<class_339> buttons, class_2561 text, EntryInfo info) {
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            if (info != null && info.comment != null) {
                this.centered = info.comment.centered();
            }
            int scaledWidth = class_310.method_1551().method_22683().method_4486();
            if (!(text == null || text.getString().contains("spacer") && buttons.isEmpty())) {
                this.title = new class_7940(this.centered ? scaledWidth / 2 - textRenderer.method_27525((class_5348)text) / 2 : 12, 0, class_2561.method_54155((Message)text), textRenderer);
                if (info != null) {
                    this.title.method_47400(MidnightConfig.getTooltip(info, false));
                }
                this.title.method_48984(buttons.size() > 1 ? buttons.get(1).method_46426() - 24 : scaledWidth - 24);
            }
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.method_46419(y);
                b.method_25394(context, mouseX, mouseY, tickDelta);
            });
            if (this.title != null) {
                class_339 class_3392;
                boolean tooltipVisible;
                this.title.method_46419(y + 9);
                this.title.method_48579(context, mouseX, mouseY, tickDelta);
                boolean bl = tooltipVisible = mouseX >= this.title.method_46426() && mouseX < this.title.method_25368() + this.title.method_46426() && mouseY >= this.title.method_46427() && mouseY < this.title.method_25364() + this.title.method_46427();
                if (tooltipVisible && this.title.method_51254() != null) {
                    context.method_51447(textRenderer, this.title.method_51254().method_47405(class_310.method_1551()), mouseX, mouseY);
                }
                if (this.info.entry != null && !this.buttons.isEmpty() && (class_3392 = this.buttons.getFirst()) instanceof class_339) {
                    class_339 widget = class_3392;
                    int idMode = this.info.entry.idMode();
                    if (idMode != -1) {
                        context.method_51427(idMode == 0 ? ((class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)this.info.tempValue))).method_7854() : ((class_2248)class_7923.field_41175.method_63535(class_2960.method_12829((String)this.info.tempValue))).method_8389().method_7854(), widget.method_46426() + widget.method_25368() - 18, y + 2);
                    }
                }
            }
        }

        public List<? extends class_364> method_25396() {
            return Lists.newArrayList(this.buttons);
        }

        public List<? extends class_6379> method_37025() {
            return Lists.newArrayList(this.buttons);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class MidnightConfigListWidget
    extends class_4265<ButtonEntry> {
        public boolean renderHeaderSeparator = true;

        public MidnightConfigListWidget(class_310 client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
        }

        public int method_65507() {
            return this.field_22758 - 7;
        }

        protected void method_57713(class_332 context) {
            if (this.renderHeaderSeparator) {
                super.method_57713(context);
            } else {
                context.method_25290(class_1921::method_62277, this.field_22740.field_1687 == null ? class_437.field_49896 : class_437.field_49898, this.method_46426(), this.method_55443(), 0.0f, 0.0f, this.method_25368(), 2, 32, 2);
            }
        }

        public void addButton(List<class_339> buttons, class_2561 text, EntryInfo info) {
            this.method_25321((class_350.class_351)new ButtonEntry(buttons, text, info));
        }

        public void clear() {
            this.method_25339();
        }

        public int method_25322() {
            return 10000;
        }
    }
}

