/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import java.util.Arrays;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.CommonRegisterPayload;
import net.fabricmc.fabric.impl.networking.CommonVersionPayload;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.server.ServerConfigurationNetworkAddon;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_8605;

public class CommonPacketsImpl {
    public static final int PACKET_VERSION_1 = 1;
    public static final int[] SUPPORTED_COMMON_PACKET_VERSIONS = new int[]{1};

    public static void init() {
        PayloadTypeRegistry.configurationC2S().register(CommonVersionPayload.ID, CommonVersionPayload.CODEC);
        PayloadTypeRegistry.configurationS2C().register(CommonVersionPayload.ID, CommonVersionPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CommonVersionPayload.ID, CommonVersionPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CommonVersionPayload.ID, CommonVersionPayload.CODEC);
        PayloadTypeRegistry.configurationC2S().register(CommonRegisterPayload.ID, CommonRegisterPayload.CODEC);
        PayloadTypeRegistry.configurationS2C().register(CommonRegisterPayload.ID, CommonRegisterPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CommonRegisterPayload.ID, CommonRegisterPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CommonRegisterPayload.ID, CommonRegisterPayload.CODEC);
        ServerConfigurationNetworking.registerGlobalReceiver(CommonVersionPayload.ID, (payload, context) -> {
            ServerConfigurationNetworkAddon addon = ServerNetworkingImpl.getAddon(context.networkHandler());
            addon.onCommonVersionPacket(CommonPacketsImpl.getNegotiatedVersion(payload));
            context.networkHandler().completeTask(CommonVersionConfigurationTask.KEY);
        });
        ServerConfigurationNetworking.registerGlobalReceiver(CommonRegisterPayload.ID, (payload, context) -> {
            ServerConfigurationNetworkAddon addon = ServerNetworkingImpl.getAddon(context.networkHandler());
            if ("play".equals(payload.phase())) {
                if (payload.version() != addon.getNegotiatedVersion()) {
                    throw new IllegalStateException("Negotiated common packet version: %d but received packet with version: %d".formatted(addon.getNegotiatedVersion(), payload.version()));
                }
                addon.getChannelInfoHolder().fabric_getPendingChannelsNames(class_2539.field_20591).addAll(payload.channels());
                NetworkingImpl.LOGGER.debug("Received accepted channels from the client for play phase");
            } else {
                addon.onCommonRegisterPacket((CommonRegisterPayload)payload);
            }
            context.networkHandler().completeTask(CommonRegisterConfigurationTask.KEY);
        });
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            ServerConfigurationNetworkAddon addon = ServerNetworkingImpl.getAddon(handler);
            if (ServerConfigurationNetworking.canSend(handler, CommonVersionPayload.ID)) {
                handler.addTask((class_8605)new CommonVersionConfigurationTask(addon));
                if (ServerConfigurationNetworking.canSend(handler, CommonRegisterPayload.ID)) {
                    handler.addTask((class_8605)new CommonRegisterConfigurationTask(addon));
                }
            }
        });
    }

    private static int getNegotiatedVersion(CommonVersionPayload payload) {
        int version = CommonPacketsImpl.getHighestCommonVersion(payload.versions(), SUPPORTED_COMMON_PACKET_VERSIONS);
        if (version <= 0) {
            throw new UnsupportedOperationException("server does not support any requested versions from client");
        }
        return version;
    }

    public static int getHighestCommonVersion(int[] a, int[] b) {
        int[] as = (int[])a.clone();
        int[] bs = (int[])b.clone();
        Arrays.sort(as);
        Arrays.sort(bs);
        int ap = as.length - 1;
        int bp = bs.length - 1;
        while (ap >= 0 && bp >= 0) {
            if (as[ap] == bs[bp]) {
                return as[ap];
            }
            if (as[ap] > bs[bp]) {
                --ap;
                continue;
            }
            --bp;
        }
        return -1;
    }

    private record CommonVersionConfigurationTask(ServerConfigurationNetworkAddon addon) implements class_8605
    {
        public static final class_8605.class_8606 KEY = new class_8605.class_8606(CommonVersionPayload.ID.comp_2242().toString());

        public void method_52376(Consumer<class_2596<?>> sender) {
            this.addon.sendPacket(new CommonVersionPayload(SUPPORTED_COMMON_PACKET_VERSIONS));
        }

        public class_8605.class_8606 method_52375() {
            return KEY;
        }
    }

    private record CommonRegisterConfigurationTask(ServerConfigurationNetworkAddon addon) implements class_8605
    {
        public static final class_8605.class_8606 KEY = new class_8605.class_8606(CommonRegisterPayload.ID.comp_2242().toString());

        public void method_52376(Consumer<class_2596<?>> sender) {
            this.addon.sendPacket(new CommonRegisterPayload(this.addon.getNegotiatedVersion(), "play", ServerPlayNetworking.getGlobalReceivers()));
        }

        public class_8605.class_8606 method_52375() {
            return KEY;
        }
    }
}

