/*
 * Decompiled with CFR 0.152.
 */
package net.platinumdigitalgroup.jvdf;

import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class VDFNode
extends LinkedHashMap<String, Object[]> {
    @Override
    public Object put(String key, Object value) {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            value = i.toString();
        }
        if (!(value instanceof String) && !(value instanceof VDFNode)) {
            throw new IllegalArgumentException("VDFNode value must be String or VDFNode");
        }
        Object[] values = (Object[])this.get(key);
        if (values == null) {
            this.put(key, new Object[]{value});
        } else {
            Object[] appendTo = Arrays.copyOf(values, values.length + 1);
            appendTo[values.length] = value;
            this.put(key, appendTo);
        }
        return value;
    }

    public int values(String key) {
        Object[] values = (Object[])this.get(key);
        if (values == null) {
            return 0;
        }
        return values.length;
    }

    public String getString(String key, int index) {
        Object[] objects = (Object[])this.get(key);
        return objects != null ? (String)objects[index] : null;
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key, 0);
        return value != null ? value : defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, 0);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.getString(key);
        return value != null ? Float.parseFloat(value) : defaultValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public long getPointer(String key) {
        return Long.parseLong(this.getString(key), 16);
    }

    public String getWideString(String key) {
        return this.getString(key);
    }

    public Color getColor(String key) {
        return Color.getColor(this.getString(key));
    }

    public Color getColor(String key, Color defaultValue) {
        String value = this.getString(key);
        return value != null ? Color.getColor(value) : defaultValue;
    }

    public VDFNode getSubNode(String key) {
        return this.getSubNode(key, 0);
    }

    public VDFNode getSubNode(String key, int index) {
        return (VDFNode)((Object[])this.get(key))[index];
    }

    public VDFNode reduce(boolean recursive) {
        this.entrySet().parallelStream().filter(e -> ((Object[])e.getValue())[0] instanceof VDFNode).forEach((? super T e) -> this.reduceKeyValue((Map.Entry<String, Object[]>)e, recursive));
        return this;
    }

    private void reduceKeyValue(Map.Entry<String, Object[]> entry, boolean recursive) {
        Object[] nodes = entry.getValue();
        VDFNode newNode = (VDFNode)nodes[0];
        if (recursive) {
            newNode.reduce(true);
        }
        if (nodes.length <= 1) {
            return;
        }
        int nodesLength = nodes.length;
        for (int i = 1; i < nodesLength; ++i) {
            VDFNode node = (VDFNode)nodes[i];
            node.join(newNode);
        }
        this.put(entry.getKey(), new Object[]{newNode});
    }

    public void join(VDFNode other) {
        for (Map.Entry e : this.entrySet()) {
            for (Object o : (Object[])e.getValue()) {
                other.put((String)e.getKey(), o);
            }
        }
    }

    public VDFNode reduce() {
        return this.reduce(true);
    }
}

