/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.deckapi.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import dev.isxander.deckapi.api.ControllerInfo;
import dev.isxander.deckapi.api.ControllerState;
import dev.isxander.deckapi.api.ControllerType;
import dev.isxander.deckapi.api.SteamDeck;
import dev.isxander.deckapi.api.SteamDeckException;
import dev.isxander.deckapi.impl.ControllerTypeTypeAdapter;
import dev.isxander.deckapi.impl.JSBooleanResult;
import dev.isxander.deckapi.impl.JSStringResult;
import dev.isxander.deckapi.impl.JSTab;
import dev.isxander.deckapi.impl.TabInfo;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.imageio.ImageIO;
import net.platinumdigitalgroup.jvdf.VDFNode;
import net.platinumdigitalgroup.jvdf.VDFParser;
import net.platinumdigitalgroup.jvdf.VDFWriter;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SteamDeckImpl
implements SteamDeck {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SteamDeck4j");
    private final HttpClient httpClient;
    private final JSTab sharedJsContext;
    private final Gson gson;
    private ControllerState currentState = ControllerState.ZERO;
    @Nullable
    private ControllerInfo deckInfo;
    private Long appId;
    private boolean isGameInFocus;

    public SteamDeckImpl(String url) throws SteamDeckException {
        HttpResponse<String> tabsResponse;
        this.httpClient = HttpClient.newHttpClient();
        this.gson = new GsonBuilder().registerTypeAdapter(ControllerType.class, (Object)new ControllerTypeTypeAdapter()).create();
        String tabsUrl = "%s/json".formatted(url);
        HttpRequest tabsRequest = HttpRequest.newBuilder().uri(URI.create(tabsUrl)).timeout(Duration.of(5L, ChronoUnit.SECONDS)).GET().build();
        LOGGER.info("Requesting tabs from CEF at {}", (Object)tabsUrl);
        try {
            tabsResponse = this.httpClient.send(tabsRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new SteamDeckException("Failed to talk to CEF", e);
        }
        if (tabsResponse.statusCode() != 200) {
            throw new SteamDeckException("Failed to talk to CEF with code %d. PLEASE ENSURE DECKY IS RUNNING!".formatted(tabsResponse.statusCode()));
        }
        TabInfo[] tabs = (TabInfo[])this.gson.fromJson(tabsResponse.body(), TabInfo[].class);
        TabInfo sharedJsContextTabInfo = Arrays.stream(tabs).filter(tab -> "SharedJSContext".equals(tab.title())).findAny().orElseThrow(() -> new IllegalStateException("Could not find SharedJSContext tab"));
        String wsUrl = sharedJsContextTabInfo.webSocketDebuggerUrl();
        this.sharedJsContext = JSTab.open(wsUrl, this.httpClient).join();
        LOGGER.info("Successfully connected to SharedJSContext tab");
        System.out.println(this.sharedJsContext.eval("// we don't want to keep adding more and more listeners between launches when not closed gracefully\nif (window.controlifyListUnregister) {\n    window.controlifyListUnregister.unregister();\n}\nif (window.controlifyStateUnregister) {\n    window.controlifyStateUnregister.unregister();\n}\n\nwindow.controlifyListUnregister = SteamClient.Input.RegisterForControllerListChanges((controllers) => {\n    window.controlifySteamDeckInfo = controllers.find((controller) => controller.eControllerType == 4);\n});\n\nwindow.controlifyStateUnregister = SteamClient.Input.RegisterForControllerStateChanges((controllerStates) => {\n    for (state of controllerStates) {\n        if (state.unControllerIndex === window.controlifySteamDeckInfo.nControllerIndex) {\n            window.controlifySteamDeckState = state;\n        }\n    }\n});\n\nSteamUIStore.MainRunningAppID\n", JsonObject.class, new Object[0]).join());
    }

    @Override
    public ControllerState getControllerState() {
        return this.currentState;
    }

    @Override
    public ControllerInfo getControllerInfo() {
        return this.deckInfo;
    }

    @Override
    public CompletableFuture<Void> poll() {
        CompletionStage stateResult = ((CompletableFuture)this.sharedJsContext.eval("SteamClient.Input.RequestGyroActive(window.controlifySteamDeckInfo.nControllerIndex, true);\nJSON.stringify(window.controlifySteamDeckState)\n", JSStringResult.class, new Object[0]).thenAccept(json -> {
            this.currentState = (ControllerState)this.gson.fromJson(json.getValue(), ControllerState.class);
        })).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
        CompletionStage listResult = ((CompletableFuture)this.sharedJsContext.eval("JSON.stringify(window.controlifySteamDeckInfo)", JSStringResult.class, new Object[0]).thenAccept(json -> {
            this.deckInfo = (ControllerInfo)this.gson.fromJson(json.getValue(), ControllerInfo.class);
        })).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
        CompletionStage focusResult = this.getGameFocusState().thenAccept(focus -> {
            this.isGameInFocus = focus;
        });
        return CompletableFuture.allOf(new CompletableFuture[]{stateResult, listResult, focusResult});
    }

    @Override
    public CompletableFuture<Void> openModalKeyboard(boolean enterDismissesKeyboard) {
        if (this.deckInfo == null) {
            throw new IllegalStateException("Cannot open modal keyboard without controller info. Make sure to poll first");
        }
        return this.sharedJsContext.eval("SteamUIStore.OnModalKeyboardMessage({\n      nAppID: 0,\n      bChordInvoked: false,\n      bEnterDismissesKeyboard: $$,\n      nControllerIndex: $$,\n      nXPosition: 0,\n      nYPosition: 0\n})\n", JsonObject.class, enterDismissesKeyboard, this.deckInfo.nControllerIndex()).thenAccept(json -> {});
    }

    @Override
    public CompletableFuture<Path> doSteamScreenshot(Path screenshotPath, String caption) {
        return this.getScreenshotPath().thenCompose(gameScreenshotFolder -> {
            BufferedImage image;
            Path targetScreenshotPath = gameScreenshotFolder.resolve(screenshotPath.getFileName());
            try {
                Files.copy(screenshotPath, targetScreenshotPath, new CopyOption[0]);
                image = ImageIO.read(targetScreenshotPath.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Image thumbnailImage = image.getScaledInstance((int)((double)image.getWidth() / 6.4), (int)((double)image.getHeight() / 6.4), 4);
            BufferedImage thumbnail = new BufferedImage(thumbnailImage.getWidth(null), thumbnailImage.getHeight(null), 2);
            Graphics2D g2d = thumbnail.createGraphics();
            g2d.drawImage(thumbnailImage, 0, 0, null);
            g2d.dispose();
            Path thumbnailPath = targetScreenshotPath.getParent().resolve("thumbnails").resolve(targetScreenshotPath.getFileName());
            try {
                Files.createDirectories(thumbnailPath.getParent(), new FileAttribute[0]);
                ImageIO.write((RenderedImage)thumbnail, "png", thumbnailPath.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int screenshotAppId = (int)(this.appId & 0x3FFFFFL);
            Path rootScreenshotFolder = gameScreenshotFolder.getParent().getParent();
            Path screenshotsVDF = rootScreenshotFolder.resolve("screenshots.vdf");
            String screenshotsVDFString = null;
            try {
                screenshotsVDFString = Files.readString(screenshotsVDF);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            VDFNode screenshotsNode = new VDFParser().parse(screenshotsVDFString).getSubNode("screenshots");
            VDFNode currentGameScreenshots = screenshotsNode.getSubNode(String.valueOf(screenshotAppId));
            int freeIndex = 0;
            while (currentGameScreenshots.getSubNode(String.valueOf(freeIndex)) != null) {
                if (++freeIndex <= 50000) continue;
                throw new IllegalStateException("Potential stack overflow. 50k screenshots?");
            }
            long creationTime = System.currentTimeMillis() / 1000L;
            VDFNode newScreenshot = new VDFNode();
            newScreenshot.put("type", "1");
            newScreenshot.put("filename", targetScreenshotPath.relativize(rootScreenshotFolder).toString());
            newScreenshot.put("thumbnail", thumbnailPath.relativize(rootScreenshotFolder).toString());
            newScreenshot.put("vrfilename", "");
            newScreenshot.put("imported", "1");
            newScreenshot.put("width", String.valueOf(image.getWidth()));
            newScreenshot.put("height", String.valueOf(image.getHeight()));
            newScreenshot.put("gameid", String.valueOf(screenshotAppId));
            newScreenshot.put("creation", String.valueOf(creationTime));
            newScreenshot.put("caption", caption);
            newScreenshot.put("Permissions", "2");
            newScreenshot.put("hscreenshot", "18446744073709551615");
            newScreenshot.put("publishedfileid", "0");
            currentGameScreenshots.put(String.valueOf(freeIndex), newScreenshot);
            try {
                Files.writeString(screenshotsVDF, (CharSequence)new VDFWriter().write(screenshotsNode, true), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.sharedJsContext.eval("const listeners = [\n    screenshotStore.OnScreenshotNotification,\n    appSpotlightStore.OnScreenshotNotification,\n    appActivityStore.OnScreenshotNotification\n];\nconst onScreenshotNotification = (notification) => {\n    listeners.forEach(listener => listener(notification));\n};\n\nonScreenshotNotification({\n    strOperation: 'started'\n});\nonScreenshotNotification({\n    strOperation: 'written',\n    details: {\n        bSpoilers: false,\n        bUploaded: false,\n        ePrivacy: 2,\n        hHandle: $$,\n        nAppID: $$,\n        nCreated: $$,\n        nHeight: $$,\n        nWidth: $$,\n        publishedFileID: \"0\",\n        strCaption: \"$$\",\n        strGameID: \"$$\",\n        strUrl: \"https://steamloopback.host/screenshots/$$/screenshots/$$\",\n        ugcHandle: 18446744073709551615\n    }\n})\n", JsonObject.class, freeIndex, screenshotAppId, creationTime, image.getHeight(), image.getWidth(), caption, screenshotAppId, screenshotAppId, targetScreenshotPath.getFileName()).thenApply(json -> targetScreenshotPath);
        });
    }

    @Override
    public CompletableFuture<Path> getScreenshotPath() {
        return this.sharedJsContext.eval("// non-steam games use 22-bit app ids for screenshots (thanks Valve)\nawait SteamClient.Screenshots.GetLocalScreenshotPath($$, 0)\n", JSStringResult.class, this.appId & 0x3FFFFFL).thenApply(string -> Path.of(string.getValue(), new String[0]));
    }

    @Override
    public boolean isGameInFocus() {
        return this.isGameInFocus;
    }

    private CompletableFuture<Boolean> getGameFocusState() {
        return this.sharedJsContext.eval("SteamUIStore.MainRunningAppID === FocusedAppWindowStore.m_unFocusedAppID\n", JSBooleanResult.class, new Object[0]).thenApply(JSBooleanResult::getValue);
    }

    @Override
    public void close() {
        this.sharedJsContext.eval("window.controlifyListUnregister.unregister()\nwindow.controlifyStateUnregister.unregister()\nSteamClient.Input.RequestGyroActive(window.controlifySteamDeckInfo.nControllerIndex, false);\n", JsonObject.class, new Object[0]).join();
        this.sharedJsContext.close();
    }
}

