/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.deckapi.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.isxander.deckapi.impl.CEFIncomingMessage;
import dev.isxander.deckapi.impl.CEFOutgoingMessage;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.intellij.lang.annotations.Language;

public class JSTab
implements WebSocket.Listener,
Closeable {
    private WebSocket ws;
    private final Gson gson;
    private final AtomicInteger nextId = new AtomicInteger(0);
    private final Map<Integer, ResponseFuture<?>> pendingEvals = new HashMap();
    private final StringBuilder message = new StringBuilder();

    private JSTab() {
        this.gson = new Gson();
    }

    public static CompletableFuture<JSTab> open(String wsUrl, HttpClient httpClient) {
        JSTab tab = new JSTab();
        return httpClient.newWebSocketBuilder().buildAsync(URI.create(wsUrl), tab).thenApply(webSocket -> {
            tab.ws = webSocket;
            return tab;
        });
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.message.append(data);
        if (!last) {
            return WebSocket.Listener.super.onText(webSocket, data, last);
        }
        String completeMessage = this.message.toString();
        this.message.setLength(0);
        CEFIncomingMessage decodedMessage = (CEFIncomingMessage)this.gson.fromJson(completeMessage, CEFIncomingMessage.class);
        ResponseFuture<?> responseFuture = this.pendingEvals.remove(decodedMessage.id());
        if (responseFuture != null) {
            responseFuture.complete(decodedMessage.result(), this.gson);
        } else {
            System.out.println("Received message with no pending eval: " + data);
        }
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        System.out.println("WebSocket closed: " + statusCode + " " + reason);
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    public <T> CompletableFuture<T> eval(@Language(value="JavaScript", prefix="\n\n// noinspection TypeScriptUnresolvedReference\nconst SteamClient = {\n    Apps: Apps,\n    Auth: Auth,\n    Broadcast: Broadcast,\n    Browser: Browser,\n    BrowserView: BrowserView,\n    ClientNotifications: ClientNotifications,\n    Cloud: Cloud,\n    CommunityItems: CommunityItems,\n    Console: Console,\n    Customization: Customization,\n    Downloads: Downloads,\n    FamilySharing: FamilySharing,\n    Friends: Friends,\n    FriendSettings: FriendSettings,\n    GameNotes: GameNotes,\n    GameSessions: GameSessions,\n    Input: Input,\n    InstallFolder: InstallFolder,\n    Installs: Installs,\n    MachineStorage: Storage,\n    Messaging: Messaging,\n    Music: Music,\n    Notifications: Notifications,\n    OpenVR: OpenVR,\n    Overlay: Overlay,\n    Parental: Parental,\n    RemotePlay: RemotePlay,\n    RoamingStorage: Storage,\n    Screenshots: Screenshots,\n    ServerBrowser: ServerBrowser,\n    Settings: Settings,\n    SharedConnection: SharedConnection,\n    Stats: Stats,\n    SteamChina: SteamChina,\n    Storage: Storage,\n    Streaming: Streaming,\n    System: System,\n    UI: UI,\n    URL: URL,\n    Updates: Updates,\n    User: User,\n    WebChat: WebChat,\n    WebUITransport: WebUITransport,\n    Window: Window,\n}\n\n") String javascript, Class<T> type, Object ... args) {
        int id = this.nextId.getAndIncrement();
        CEFOutgoingMessage message = new CEFOutgoingMessage(id, "Runtime.evaluate", Map.of("expression", javascript.stripIndent().replace("$$", "%s").formatted(args), "userGesture", true));
        this.ws.request(1L);
        String json = this.gson.toJson((Object)message);
        return this.ws.sendText(json, true).thenCompose(ws1 -> {
            CompletableFuture f = new CompletableFuture();
            this.pendingEvals.put(id, new ResponseFuture(f, type));
            return f;
        });
    }

    @Override
    public void close() {
        this.ws.sendClose(1000, "Closing").join();
    }

    private record ResponseFuture<T>(CompletableFuture<T> future, Type type) {
        public void complete(JsonElement response, Gson gson) {
            try {
                Object result = gson.fromJson(response, this.type);
                this.future.complete(result);
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
            }
        }
    }
}

