/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.rendering.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_239;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class WorldRenderEvents {
    public static final Event<Start> START = EventFactory.createArrayBacked(Start.class, context -> {}, callbacks -> context -> {
        for (Start callback : callbacks) {
            callback.onStart(context);
        }
    });
    public static final Event<AfterSetup> AFTER_SETUP = EventFactory.createArrayBacked(AfterSetup.class, context -> {}, callbacks -> context -> {
        for (AfterSetup callback : callbacks) {
            callback.afterSetup(context);
        }
    });
    public static final Event<BeforeEntities> BEFORE_ENTITIES = EventFactory.createArrayBacked(BeforeEntities.class, context -> {}, callbacks -> context -> {
        for (BeforeEntities callback : callbacks) {
            callback.beforeEntities(context);
        }
    });
    public static final Event<AfterEntities> AFTER_ENTITIES = EventFactory.createArrayBacked(AfterEntities.class, context -> {}, callbacks -> context -> {
        for (AfterEntities callback : callbacks) {
            callback.afterEntities(context);
        }
    });
    public static final Event<BeforeBlockOutline> BEFORE_BLOCK_OUTLINE = EventFactory.createArrayBacked(BeforeBlockOutline.class, (context, hit) -> true, callbacks -> (context, hit) -> {
        boolean shouldRender = true;
        for (BeforeBlockOutline callback : callbacks) {
            if (callback.beforeBlockOutline(context, hit)) continue;
            shouldRender = false;
        }
        return shouldRender;
    });
    public static final Event<BlockOutline> BLOCK_OUTLINE = EventFactory.createArrayBacked(BlockOutline.class, (worldRenderContext, blockOutlineContext) -> true, callbacks -> (worldRenderContext, blockOutlineContext) -> {
        boolean shouldRender = true;
        for (BlockOutline callback : callbacks) {
            if (callback.onBlockOutline(worldRenderContext, blockOutlineContext)) continue;
            shouldRender = false;
        }
        return shouldRender;
    });
    public static final Event<DebugRender> BEFORE_DEBUG_RENDER = EventFactory.createArrayBacked(DebugRender.class, context -> {}, callbacks -> context -> {
        for (DebugRender callback : callbacks) {
            callback.beforeDebugRender(context);
        }
    });
    public static final Event<AfterTranslucent> AFTER_TRANSLUCENT = EventFactory.createArrayBacked(AfterTranslucent.class, context -> {}, callbacks -> context -> {
        for (AfterTranslucent callback : callbacks) {
            callback.afterTranslucent(context);
        }
    });
    public static final Event<Last> LAST = EventFactory.createArrayBacked(Last.class, context -> {}, callbacks -> context -> {
        for (Last callback : callbacks) {
            callback.onLast(context);
        }
    });
    public static final Event<End> END = EventFactory.createArrayBacked(End.class, context -> {}, callbacks -> context -> {
        for (End callback : callbacks) {
            callback.onEnd(context);
        }
    });

    private WorldRenderEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface End {
        public void onEnd(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Last {
        public void onLast(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterTranslucent {
        public void afterTranslucent(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DebugRender {
        public void beforeDebugRender(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BlockOutline {
        public boolean onBlockOutline(WorldRenderContext var1, WorldRenderContext.BlockOutlineContext var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeBlockOutline {
        public boolean beforeBlockOutline(WorldRenderContext var1, @Nullable class_239 var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterEntities {
        public void afterEntities(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeEntities {
        public void beforeEntities(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterSetup {
        public void afterSetup(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Start {
        public void onStart(WorldRenderContext var1);
    }
}

