/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.rendering.v1;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.rendering.EntityModelLayerImpl;
import net.fabricmc.fabric.mixin.client.rendering.EntityModelLayersAccessor;
import net.minecraft.class_5601;
import net.minecraft.class_5607;

@Environment(value=EnvType.CLIENT)
public final class EntityModelLayerRegistry {
    public static void registerModelLayer(class_5601 modelLayer, TexturedModelDataProvider provider) {
        Objects.requireNonNull(modelLayer, "EntityModelLayer cannot be null");
        Objects.requireNonNull(provider, "TexturedModelDataProvider cannot be null");
        if (EntityModelLayerImpl.PROVIDERS.putIfAbsent(modelLayer, provider) != null) {
            throw new IllegalArgumentException(String.format("Cannot replace registration for entity model layer \"%s\"", modelLayer));
        }
        EntityModelLayersAccessor.getLayers().add(modelLayer);
    }

    private EntityModelLayerRegistry() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface TexturedModelDataProvider {
        public class_5607 createModelData();
    }
}

