/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser;

import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.placeholders.api.node.DirectTextNode;
import eu.pb4.placeholders.api.node.KeybindNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.NbtNode;
import eu.pb4.placeholders.api.node.ScoreNode;
import eu.pb4.placeholders.api.node.SelectorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.BoldNode;
import eu.pb4.placeholders.api.node.parent.ClickActionNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.node.parent.FontNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.node.parent.HoverNode;
import eu.pb4.placeholders.api.node.parent.InsertNode;
import eu.pb4.placeholders.api.node.parent.ItalicNode;
import eu.pb4.placeholders.api.node.parent.ObfuscatedNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.StrikethroughNode;
import eu.pb4.placeholders.api.node.parent.TransformNode;
import eu.pb4.placeholders.api.node.parent.UnderlinedNode;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_10104;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2575;
import net.minecraft.class_2576;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4616;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Internal
public final class TextTagsV1 {
    public static void register() {
        HashMap<String, List<String>> aliases = new HashMap<String, List<String>>();
        aliases.put("gold", List.of("orange"));
        aliases.put("gray", List.of("grey"));
        aliases.put("light_purple", List.of("pink"));
        aliases.put("dark_gray", List.of("dark_grey"));
        for (class_124 formatting : class_124.values()) {
            if (formatting.method_542()) continue;
            TextParserV1.registerDefault(TextParserV1.TextTag.of(formatting.method_537(), aliases.containsKey(formatting.method_537()) ? (List)aliases.get(formatting.method_537()) : List.of(), "color", true, TextTagsV1.wrap((nodes, arg) -> new FormattingNode(nodes, formatting))));
        }
        TextParserV1.registerDefault(TextParserV1.TextTag.of("bold", List.of("b"), "formatting", true, TextTagsV1.bool(BoldNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("underline", List.of("underlined", "u"), "formatting", true, TextTagsV1.bool(UnderlinedNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("strikethrough", List.of("st"), "formatting", true, TextTagsV1.bool(StrikethroughNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("obfuscated", List.of("obf", "matrix"), "formatting", true, TextTagsV1.bool(ObfuscatedNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("italic", List.of("i", "em"), "formatting", true, TextTagsV1.bool(ItalicNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("color", List.of("colour", "c"), "color", true, TextTagsV1.wrap((nodes, data) -> new ColorNode(nodes, class_5251.method_27719((String)TextParserImpl.cleanArgument(data)).result().orElse(null)))));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("font", "other_formatting", false, TextTagsV1.wrap((nodes, data) -> new FontNode(nodes, class_2960.method_12829((String)TextParserImpl.cleanArgument(data))))));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("lang", List.of("translate"), "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            if (lines.length > 0) {
                ArrayList<ParentNode> textList = new ArrayList<ParentNode>();
                boolean skipped = false;
                for (String part : lines) {
                    if (!skipped) {
                        skipped = true;
                        continue;
                    }
                    textList.add(new ParentNode(TextParserImpl.parse(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(part)), handlers)));
                }
                TranslatedNode out = TranslatedNode.of(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(lines[0])), textList.toArray(TextParserImpl.CASTER));
                return new TextParserV1.TagNodeValue(out, 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("lang_fallback", List.of("translatef", "langf", "translate_fallback"), "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            if (lines.length > 1) {
                ArrayList<ParentNode> textList = new ArrayList<ParentNode>();
                int skipped = 0;
                for (String part : lines) {
                    if (skipped < 2) {
                        ++skipped;
                        continue;
                    }
                    textList.add(new ParentNode(TextParserImpl.parse(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(part)), handlers)));
                }
                TranslatedNode out = TranslatedNode.ofFallback(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(lines[0])), TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(lines[1])), textList.toArray(TextParserImpl.CASTER));
                return new TextParserV1.TagNodeValue(out, 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("keybind", List.of("key"), "special", false, (tag, data, input, handlers, endAt) -> {
            if (!data.isEmpty()) {
                return new TextParserV1.TagNodeValue(new KeybindNode(TextParserImpl.cleanArgument(data)), 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("run_command", List.of("run_cmd"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickActionNode.Action.RUN_COMMAND, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("suggest_command", List.of("cmd"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickActionNode.Action.SUGGEST_COMMAND, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("open_url", List.of("url"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickActionNode.Action.OPEN_URL, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("copy_to_clipboard", List.of("copy"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickActionNode.Action.COPY_TO_CLIPBOARD, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("change_page", List.of("page"), "click_action", true, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickActionNode.Action.CHANGE_PAGE, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("hover", "hover_event", true, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out;
            block11: {
                String[] lines = data.split(":", 2);
                out = TextParserImpl.recursiveParsing(input, handlers, endAt);
                try {
                    if (lines.length > 1) {
                        class_2568.class_5247 action = class_2568.class_5247.field_46604.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)TextParserImpl.cleanArgument(lines[0].toLowerCase(Locale.ROOT)))).result().orElse(null);
                        if (action == class_2568.class_5247.field_24342) {
                            return out.value(new HoverNode<ParentNode, class_2568.class_10613>(out.nodes(), HoverNode.Action.TEXT_NODE, new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1])), handlers))));
                        }
                        if (action == class_2568.class_5247.field_24344) {
                            if ((lines = lines[1].split(":", 3)).length == 3) {
                                return out.value(new HoverNode<HoverNode.EntityNodeContent, class_2568.class_10611>(out.nodes(), HoverNode.Action.ENTITY_NODE, new HoverNode.EntityNodeContent(class_1299.method_5898((String)TextParserImpl.restoreOriginalEscaping(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[0])))).orElse(class_1299.field_6093), UUID.fromString(TextParserImpl.cleanArgument(lines[1])), new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[2]))), handlers)))));
                            }
                            break block11;
                        }
                        if (action == class_2568.class_5247.field_24343) {
                            try {
                                class_2487 nbt = class_2522.method_67315((String)TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1])));
                                return out.value(new HoverNode<HoverNode.LazyItemStackNodeContent<Object>, class_2568.class_10612>(out.nodes(), HoverNode.Action.LAZY_ITEM_STACK, new HoverNode.LazyItemStackNodeContent<Object>(class_2960.method_60654((String)nbt.method_68564("id", "")), nbt.method_10545("count") ? nbt.method_68083("count", 1) : 1, (DynamicOps<Object>)class_2509.field_11560, (nbt.method_10545("components") ? (class_2520)nbt.method_10562("components").orElse(null) : null))));
                            }
                            catch (Throwable e) {
                                lines = lines[1].split(":", 2);
                                if (lines.length > 0) {
                                    class_1799 stack = ((class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)lines[0]))).method_7854();
                                    if (lines.length > 1) {
                                        stack.method_7939(Integer.parseInt(lines[1]));
                                    }
                                    return out.value(new HoverNode<class_2568.class_10612, class_2568.class_10612>(out.nodes(), HoverNode.Action.VANILLA_ITEM_STACK, new class_2568.class_10612(stack)));
                                }
                                break block11;
                            }
                        }
                        return out.value(new HoverNode<ParentNode, class_2568.class_10613>(out.nodes(), HoverNode.Action.TEXT_NODE, new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)), handlers))));
                    }
                    return out.value(new HoverNode<ParentNode, class_2568.class_10613>(out.nodes(), HoverNode.Action.TEXT_NODE, new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)), handlers))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("insert", List.of("insertion"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(new InsertNode(out.nodes(), (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("clear_color", List.of("uncolor", "colorless"), "special", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(GeneralUtils.removeColors(new ParentNode(out.nodes())));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("rainbow", List.of("rb"), "gradient", true, (tag, data, input, handlers, endAt) -> {
            String[] val = data.split(":");
            float freq = 1.0f;
            float saturation = 1.0f;
            float offset = 0.0f;
            int overriddenLength = -1;
            if (val.length >= 1) {
                try {
                    freq = Float.parseFloat(val[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val.length >= 2) {
                try {
                    saturation = Float.parseFloat(val[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val.length >= 3) {
                try {
                    offset = Float.parseFloat(val[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val.length >= 4) {
                try {
                    overriddenLength = Integer.parseInt(val[3]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(overriddenLength < 0 ? GradientNode.rainbow(saturation, 1.0f, freq, offset, out.nodes()) : GradientNode.rainbow(saturation, 1.0f, freq, offset, overriddenLength, out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("gradient", List.of("gr"), "gradient", true, (tag, data, input, handlers, endAt) -> {
            String[] val = data.split(":");
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            ArrayList<class_5251> textColors = new ArrayList<class_5251>();
            for (String string : val) {
                class_5251.method_27719((String)string).result().ifPresent(textColors::add);
            }
            return out.value(GradientNode.colors(textColors, out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("hard_gradient", List.of("hgr"), "gradient", true, (tag, data, input, handlers, endAt) -> {
            String[] val = data.split(":");
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            ArrayList<class_5251> textColors = new ArrayList<class_5251>();
            for (String string : val) {
                class_5251.method_27719((String)string).result().ifPresent(textColors::add);
            }
            if (textColors.isEmpty()) {
                return out.value(new ParentNode(out.nodes()));
            }
            return out.value(GradientNode.colorsHard(textColors, out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("clear", "special", false, (tag, data, input, handlers, endAt) -> {
            String[] val = data.isEmpty() ? new String[]{} : data.split(":");
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(new TransformNode(out.nodes(), TextTagsV1.getTransform(val)));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("raw_style", "special", false, (tag, data, input, handlers, endAt) -> new TextParserV1.TagNodeValue(new DirectTextNode((class_2561)class_2561.class_2562.method_10873((String)TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)), (class_7225.class_7874)class_5455.field_40585)), 0)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("score", "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            if (lines.length == 2) {
                return new TextParserV1.TagNodeValue(new ScoreNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[0])), TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1]))), 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("selector", "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            String pattern = TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[0]));
            Optional optional = class_10104.method_62667((String)pattern).result();
            if (optional.isEmpty()) {
                return TextParserV1.TagNodeValue.EMPTY;
            }
            if (lines.length == 2) {
                return new TextParserV1.TagNodeValue(new SelectorNode((class_10104)optional.get(), Optional.of(TextNode.asSingle(TextParserImpl.recursiveParsing(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1])), handlers, null).nodes()))), 0);
            }
            if (lines.length == 1) {
                return new TextParserV1.TagNodeValue(new SelectorNode((class_10104)optional.get(), Optional.empty()), 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("nbt", "special", false, (tag, data, input, handlers, endAt) -> {
            class_2575 type;
            String[] lines = data.split(":");
            if (lines.length < 3) {
                return TextParserV1.TagNodeValue.EMPTY;
            }
            String cleanLine1 = TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1]));
            switch (lines[0]) {
                case "block": {
                    class_2575 class_25752 = new class_2575(cleanLine1);
                    break;
                }
                case "entity": {
                    class_2575 class_25752 = new class_2576(cleanLine1);
                    break;
                }
                case "storage": {
                    class_2575 class_25752 = new class_4616(class_2960.method_12829((String)cleanLine1));
                    break;
                }
                default: {
                    class_2575 class_25752 = type = null;
                }
            }
            if (type == null) {
                return TextParserV1.TagNodeValue.EMPTY;
            }
            Optional<TextNode> separator = lines.length > 3 ? Optional.of(TextNode.asSingle(TextParserImpl.recursiveParsing(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[3])), handlers, null).nodes())) : Optional.empty();
            boolean shouldInterpret = lines.length > 4 && Boolean.parseBoolean(lines[4]);
            return new TextParserV1.TagNodeValue(new NbtNode(lines[2], shouldInterpret, separator, (class_7419)type), 0);
        }));
    }

    private static Function<class_5250, class_2561> getTransform(String[] val) {
        if (val.length == 0) {
            return GeneralUtils.MutableTransformer.CLEAR;
        }
        Function<class_2583, class_2583> func = x -> x;
        String[] stringArray = val;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String arg;
            func = func.andThen(switch (arg = stringArray[i]) {
                case "hover" -> x -> x.method_10949(null);
                case "click" -> x -> x.method_10958(null);
                case "color" -> x -> x.method_27703((class_5251)null);
                case "insertion" -> x -> x.method_10975(null);
                case "font" -> x -> x.method_27704(null);
                case "bold" -> x -> x.method_10982(null);
                case "italic" -> x -> x.method_10978(null);
                case "underline" -> x -> x.method_30938(null);
                case "strikethrough" -> x -> x.method_36140(null);
                case "all" -> x -> class_2583.field_24360;
                default -> x -> x;
            });
        }
        return new GeneralUtils.MutableTransformer(func);
    }

    private static boolean isntFalse(String arg) {
        return arg.isEmpty() || !arg.equals("false");
    }

    private static TextParserV1.TagNodeBuilder wrap(Wrapper wrapper) {
        return (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return new TextParserV1.TagNodeValue(wrapper.wrap(out.nodes(), data), out.length());
        };
    }

    private static TextParserV1.TagNodeBuilder bool(BooleanTag wrapper) {
        return (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return new TextParserV1.TagNodeValue(wrapper.wrap(out.nodes(), TextTagsV1.isntFalse(data)), out.length());
        };
    }

    static interface Wrapper {
        public TextNode wrap(TextNode[] var1, String var2);
    }

    static interface BooleanTag {
        public TextNode wrap(TextNode[] var1, boolean var2);
    }
}

