/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;

@Environment(value=EnvType.CLIENT)
public final class LayerInjectionPoint
extends InjectionPoint {
    private final MemberInfo target;

    public LayerInjectionPoint(InjectionPointData data) {
        super(data);
        this.target = (MemberInfo)data.getTarget();
    }

    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        ArrayList<AbstractInsnNode> targetNodes = new ArrayList<AbstractInsnNode>();
        ListIterator iterator = insns.iterator();
        block0: while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (insn.getOpcode() != 186 || !this.matchesInvokeDynamic((InvokeDynamicInsnNode)insn)) continue;
            while (iterator.hasNext()) {
                insn = (AbstractInsnNode)iterator.next();
                if (insn.getOpcode() != 182) continue;
                targetNodes.add(insn);
                break block0;
            }
        }
        nodes.addAll(targetNodes);
        return !targetNodes.isEmpty();
    }

    private boolean matchesInvokeDynamic(InvokeDynamicInsnNode insnNode) {
        for (Object bsmArg : insnNode.bsmArgs) {
            Handle handle;
            if (!(bsmArg instanceof Handle) || !this.matchesHandle(handle = (Handle)bsmArg)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesHandle(Handle handle) {
        return handle.getOwner().equals(this.target.getOwner()) && handle.getName().equals(this.target.getName()) && handle.getDesc().equals(this.target.getDesc());
    }
}

