/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.event;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.DataProviders;
import dev.schmarrn.lighty.Renderers;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.compat.IrisCompat;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.event.BufferHolder;
import dev.schmarrn.lighty.overlaystate.SMACH;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;

public class Compute {
    private static final int INITIAL_HASHSET_CAPACITY = 550;
    private static HashSet<class_4076> toBeUpdated = new HashSet(550);
    private static HashSet<class_4076> toBeRemoved = new HashSet(550);
    private static final Map<class_4076, BufferHolder> cachedBuffers = new HashMap<class_4076, BufferHolder>();
    private static class_1923 playerPos = null;
    private static int computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753() + 1);

    private static boolean outOfRange(class_4076 pos) {
        int computationDistanceSquared = computationDistance * computationDistance;
        if (playerPos == null) {
            return true;
        }
        int sqX = (pos.method_18674() - Compute.playerPos.field_9181) * (pos.method_18674() - Compute.playerPos.field_9181);
        int sqZ = (pos.method_18687() - Compute.playerPos.field_9180) * (pos.method_18687() - Compute.playerPos.field_9180);
        return sqX > computationDistanceSquared || sqZ > computationDistanceSquared;
    }

    public static void clear() {
        toBeUpdated = new HashSet(550);
        cachedBuffers.forEach((sectionPos, vertexBuffer) -> vertexBuffer.close());
        cachedBuffers.clear();
        computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753() + 1);
    }

    public static void updateBlockPos(class_2338 pos) {
        class_4076 spos = class_4076.method_18682((class_2338)pos);
        if (spos.method_19528() == pos.method_10264()) {
            Compute.updateSubChunk(spos.method_34591(0, -1, 0));
        }
        Compute.updateSubChunk(spos);
    }

    public static void updateSubChunk(class_4076 pos) {
        if (Compute.outOfRange(pos)) {
            return;
        }
        toBeUpdated.add(pos);
    }

    private static BufferHolder buildChunk(OverlayRenderer renderer, List<OverlayDataProvider> dataProviders, class_4076 chunkPos, class_638 world) {
        ArrayList<OverlayData> overlayData = new ArrayList<OverlayData>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    class_2338 pos = chunkPos.method_19767().method_10069(x, y, z);
                    for (OverlayDataProvider dataProvider : dataProviders) {
                        OverlayData data = dataProvider.compute(world, pos, new class_2382(x, y, z));
                        if (!data.valid()) continue;
                        overlayData.add(data);
                    }
                }
            }
        }
        BufferHolder buffer = cachedBuffers.get(chunkPos);
        if (buffer == null) {
            buffer = new BufferHolder();
        }
        if (!overlayData.isEmpty()) {
            class_287 builder = class_289.method_1348().method_60827(renderer.getRenderType().method_23033(), renderer.getRenderType().method_23031());
            int overlayBrightness = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
            int lightmap = class_765.method_23687((int)overlayBrightness, (int)overlayBrightness);
            for (OverlayData data : overlayData) {
                renderer.build(world, data.pos(), data, builder, lightmap);
            }
            buffer.upload(builder.method_60800());
        }
        return buffer;
    }

    public static void computeCache(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        SMACH.updateCompute(client);
        if (!SMACH.isEnabled()) {
            return;
        }
        List<OverlayDataProvider> dataProviders = DataProviders.getActiveProviders();
        OverlayRenderer renderer = Renderers.getRenderer();
        class_638 world = client.field_1687;
        if (client.field_1724 == null || world == null) {
            return;
        }
        cachedBuffers.forEach((sectionPos, bufferHolder) -> {
            if (Compute.outOfRange(sectionPos)) {
                toBeRemoved.add((class_4076)sectionPos);
            }
        });
        HashSet<class_4076> removeFromToBeUpdated = new HashSet<class_4076>(550);
        int sectionsComputeCounter = client.field_1687.method_32890() * (Integer)Config.CHUNKS_PER_TICK.getValue();
        for (class_4076 sectionPos2 : toBeUpdated) {
            if (Compute.outOfRange(sectionPos2)) {
                toBeRemoved.add(sectionPos2);
                continue;
            }
            if (sectionsComputeCounter <= 0 || !client.field_1769.method_40050(sectionPos2.method_19767())) continue;
            removeFromToBeUpdated.add(sectionPos2);
            --sectionsComputeCounter;
            cachedBuffers.compute(sectionPos2, (pos, vertexBuffer) -> {
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                return Compute.buildChunk(renderer, dataProviders, pos, world);
            });
        }
        for (class_4076 pos2 : removeFromToBeUpdated) {
            toBeUpdated.remove(pos2);
        }
        for (class_4076 sectionPos2 : toBeRemoved) {
            toBeUpdated.remove(sectionPos2);
            BufferHolder buf = cachedBuffers.remove(sectionPos2);
            if (buf == null) continue;
            buf.close();
        }
        toBeRemoved.clear();
    }

    public static void render(@Nullable class_4604 frustum) {
        if (!SMACH.isEnabled()) {
            return;
        }
        if (frustum == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_638 world = minecraft.field_1687;
        if (world == null) {
            return;
        }
        OverlayRenderer renderer = Renderers.getRenderer();
        class_757 gameRenderer = minecraft.field_1773;
        class_4184 camera = gameRenderer.method_19418();
        playerPos = new class_1923(camera.method_19328());
        IrisCompat.fixIrisShaders();
        class_243 camPos = camera.method_19326();
        ArrayList<RenderPass.class_10884> drawList = new ArrayList<RenderPass.class_10884>();
        for (int x = -computationDistance + 1; x < computationDistance; ++x) {
            for (int z = -computationDistance + 1; z < computationDistance; ++z) {
                class_1923 chunkPos = new class_1923(Compute.playerPos.field_9181 + x, Compute.playerPos.field_9180 + z);
                for (int i = 0; i < world.method_32890(); ++i) {
                    class_4076 chunkSection = class_4076.method_18681((class_1923)chunkPos, (int)(world.method_32891() + i));
                    if (cachedBuffers.containsKey(chunkSection)) {
                        BufferHolder cachedBuffer = cachedBuffers.get(chunkSection);
                        if (!cachedBuffer.isValid() || !frustum.method_23093(class_238.method_54784((class_2338)chunkSection.method_19767().method_10069(-1, -1, -1), (class_2338)chunkSection.method_19767().method_10069(16, 16, 16)))) continue;
                        class_243 origin = new class_243((class_2382)chunkSection.method_19767());
                        class_243 dPos = origin.method_1020(camPos);
                        List<GpuBuffer> gpuBuffers = cachedBuffer.getGpuBuffers();
                        for (GpuBuffer gpuBuffer : gpuBuffers) {
                            drawList.add(new RenderPass.class_10884(0, gpuBuffer, null, null, 0, gpuBuffer.size(), uniformUploader -> uniformUploader.upload("ModelOffset", new float[]{(float)dPos.method_10216(), (float)dPos.method_10214(), (float)dPos.method_10215()})));
                        }
                        continue;
                    }
                    toBeUpdated.add(chunkSection);
                }
            }
        }
        GpuDevice device = RenderSystem.getDevice();
        class_1921 renderType = renderer.getRenderType();
        GpuTexture tex = minecraft.method_1531().method_4619(renderer.getTextureLocation()).method_68004();
        GpuTexture lightTexture = minecraft.field_1773.method_22974().method_67882();
        try (RenderPass pass = device.createCommandEncoder().createRenderPass(renderType.method_68494().method_30277(), OptionalInt.empty(), renderType.method_68494().method_30278(), OptionalDouble.empty());){
            pass.setPipeline(renderType.method_68495());
            pass.bindSampler("Sampler0", tex);
            pass.bindSampler("Sampler2", lightTexture);
            RenderSystem.class_5590 asib = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
            pass.drawMultipleIndexed(drawList, asib.method_68274(0), asib.method_31924());
        }
    }

    private Compute() {
    }
}

