/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9851;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class SpriteRenderer {
    public static RenderPass beginPass() {
        return new RenderPass();
    }

    public static class RenderPass {
        private float x1 = 0.0f;
        private float x2 = 1.0f;
        private float y1 = 0.0f;
        private float y2 = 0.0f;
        private float z1 = 0.0f;
        private float uStart = 0.0f;
        private float uEnd = 1.0f;
        private float vStart = 0.0f;
        private float vEnd = 1.0f;
        private int u = 0;
        private int v = 1;
        private int r = 255;
        private int g = 255;
        private int b = 255;
        private int a = 255;
        private int l = 0;
        private float nX = 0.0f;
        private float nY = 0.0f;
        private float nZ = 0.0f;
        private class_1058 sprite;
        private class_4588 consumer;
        private class_4597 consumers;
        private class_4587 matrices;
        private Matrix4f model;
        private Matrix3f normal;
        private class_1921 layer;

        private RenderPass() {
        }

        public RenderPass setup(class_4597 consumers, class_1921 type) {
            this.consumers = consumers;
            this.setup(consumers.getBuffer(type), type);
            return this;
        }

        public RenderPass setup(class_4588 consumer, class_1921 type) {
            this.consumer = consumer;
            this.matrices = new class_4587();
            this.layer = type;
            return this;
        }

        public RenderPass setup(class_4597 consumers, class_332 graphics, class_1921 type) {
            this.consumers = consumers;
            this.consumer = consumers.getBuffer(type);
            this.matrices = graphics.method_51448();
            this.layer = type;
            return this;
        }

        public RenderPass position(Matrix4f model, float x1, float y1, float x2, float y2, float z1) {
            this.position(x1, y1, x2, y2, z1);
            this.model = model;
            return this;
        }

        public RenderPass position(float x1, float y1, float x2, float y2, float z1) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.z1 = z1;
            return this;
        }

        public RenderPass sprite(class_1058 sprite) {
            this.uStart = sprite.method_4594();
            this.uEnd = sprite.method_4577();
            this.vStart = sprite.method_4593();
            this.vEnd = sprite.method_4575();
            this.sprite = sprite;
            return this;
        }

        public RenderPass sprite(float uStart, float uEnd, float vStart, float vEnd) {
            this.uStart = uStart;
            this.uEnd = uEnd;
            this.vStart = vStart;
            this.vEnd = vEnd;
            return this;
        }

        public RenderPass overlay(int uv) {
            return this.overlay(uv & 0xFFFF, uv >> 16 & 0xFFFF);
        }

        public RenderPass overlay(int u, int v) {
            this.u = u;
            this.v = v;
            return this;
        }

        public RenderPass color(int color) {
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            return this;
        }

        public RenderPass color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public RenderPass alpha(int a) {
            this.a = a;
            return this;
        }

        public RenderPass light(int l) {
            this.l = l;
            return this;
        }

        public RenderPass normal(Matrix3f normal, float nX, float nY, float nZ) {
            this.normal(nX, nY, nZ);
            this.normal = normal;
            return this;
        }

        public RenderPass normal(float nX, float nY, float nZ) {
            this.nX = nX;
            this.nY = nY;
            this.nZ = nZ;
            return this;
        }

        public void next() {
            if (this.sprite == null) {
                throw new RuntimeException("Invalid Sprite!");
            }
            this.next(this.sprite.method_45851().method_45816());
        }

        private static class_4588 normal(class_4588 consumer, Matrix3f var1, float var2, float var3, float var4) {
            Vector3f var5 = var1.transform(new Vector3f(var2, var3, var4));
            return consumer.method_22914(var5.x(), var5.y(), var5.z());
        }

        public void next(class_2960 texture) {
            if (this.consumer == null) {
                throw new RuntimeException("Invalid VertexConsumer!");
            }
            if (this.matrices == null) {
                throw new RuntimeException("Invalid MatrixStack!");
            }
            if (this.sprite == null) {
                throw new RuntimeException("Invalid Sprite!");
            }
            if (this.model == null) {
                this.model = this.matrices.method_23760().method_23761();
            }
            if (this.normal == null) {
                this.normal = this.matrices.method_23760().method_23762();
            }
            float sX = this.sprite.method_45851().method_45807();
            float sY = this.sprite.method_45851().method_45815();
            class_1060 textureManager = class_310.method_1551().method_1531();
            class_1044 abstractTexture = textureManager.method_4619(texture);
            abstractTexture.method_65923(class_9851.field_52395, false);
            RenderSystem.setShaderTexture((int)0, (GpuTexture)abstractTexture.method_68004());
            for (float y = this.y1; y < this.y2; y += Math.min(this.y2 - y, sY)) {
                for (float x = this.x1; x < this.x2; x += Math.min(this.x2 - x, sX)) {
                    float nSX = Math.min(this.x2 - x, sX);
                    float nSY = Math.min(this.y2 - y, sY);
                    boolean isOverX = nSX < sX;
                    boolean isOverY = nSY < sY;
                    float dX = 0.0f;
                    float dY = 0.0f;
                    if (isOverX) {
                        dX = (this.uEnd - this.uStart) * (1.0f - nSX / sX);
                    }
                    if (isOverY) {
                        dY = (this.vEnd - this.vStart) * (1.0f - nSY / sY);
                    }
                    this.consumer = this.consumers.getBuffer(this.layer);
                    RenderPass.normal(this.consumer.method_22918(this.model, x, y + nSY, this.z1).method_1336(this.r, this.g, this.b, this.a).method_22913(this.uStart, this.vEnd - dY).method_22921(this.u, this.v).method_22922(this.l), this.normal, this.nX, this.nY, this.nZ);
                    RenderPass.normal(this.consumer.method_22918(this.model, x + nSX, y + nSY, this.z1).method_1336(this.r, this.g, this.b, this.a).method_22913(this.uEnd - dX, this.vEnd - dY).method_22921(this.u, this.v).method_22922(this.l), this.normal, this.nX, this.nY, this.nZ);
                    RenderPass.normal(this.consumer.method_22918(this.model, x + nSX, y, this.z1).method_1336(this.r, this.g, this.b, this.a).method_22913(this.uEnd - dX, this.vStart).method_22921(this.u, this.v).method_22922(this.l), this.normal, this.nX, this.nY, this.nZ);
                    RenderPass.normal(this.consumer.method_22918(this.model, x, y, this.z1).method_1336(this.r, this.g, this.b, this.a).method_22913(this.uStart, this.vStart).method_22921(this.u, this.v).method_22922(this.l), this.normal, this.nX, this.nY, this.nZ);
                }
            }
        }
    }
}

