/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.jna;

import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.ptr.ByReference;
import dev.isxander.sdl3java.api.endian.SdlEndianConst;

public final class size_t
extends IntegerType {
    private static final long serialVersionUID = 2398288011955445078L;
    public static int SIZE = Native.SIZE_T_SIZE;

    public size_t() {
        this(0L);
    }

    public size_t(long value) {
        super(SIZE, value);
    }

    public static final class Ref
    extends ByReference {
        public Ref() {
            super(SIZE);
        }

        public Ref(size_t initialValue) {
            super(SIZE);
            this.setValue(initialValue);
        }

        public void setValue(size_t newValue) {
            long currentValue = newValue.longValue();
            if (SIZE == 4) {
                this.getPointer().setInt(0L, (int)currentValue);
            } else if (SIZE == 8) {
                this.getPointer().setLong(0L, currentValue);
            } else {
                switch (SdlEndianConst.SDL_BYTEORDER) {
                    case 1234: {
                        for (long i = 0L; i < (long)SIZE; ++i) {
                            this.getPointer().setByte(i, (byte)(currentValue & 0xFFL));
                            currentValue >>= 8;
                        }
                        break;
                    }
                    case 4321: {
                        for (long i = (long)(SIZE - 1); i >= 0L; --i) {
                            this.getPointer().setByte(i, (byte)(currentValue & 0xFFL));
                            currentValue >>= 8;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Endianness of the platform has not been defined");
                    }
                }
            }
        }

        public size_t getValue() {
            if (SIZE == 4) {
                return new size_t(this.getPointer().getInt(0L));
            }
            if (SIZE == 8) {
                return new size_t(this.getPointer().getLong(0L));
            }
            long currentValue = 0L;
            int rotation = 0;
            switch (SdlEndianConst.SDL_BYTEORDER) {
                case 1234: {
                    for (long i = 0L; i < (long)SIZE; ++i) {
                        currentValue += ((long)this.getPointer().getByte(i) & 0xFFL) << rotation;
                        rotation += 8;
                    }
                    break;
                }
                case 4321: {
                    for (long i = (long)(SIZE - 1); i >= 0L; --i) {
                        currentValue += ((long)this.getPointer().getByte(i) & 0xFFL) << rotation;
                        rotation += 8;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Endianness of the platform has not been defined");
                }
            }
            return new size_t(currentValue);
        }
    }
}

