/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import java.util.HashMap;

public final class SdlNativeLibraryLoader {
    public static final String SDL_LIBRARY_NAME = "SDL3";
    private static NativeLibrary libSDL3;

    private SdlNativeLibraryLoader() {
    }

    public static synchronized void registerNativeMethods(Class<?> nativeClass) {
        if (libSDL3 == null) {
            libSDL3 = SdlNativeLibraryLoader.loadLibSDL3();
        }
        Native.register(nativeClass, (NativeLibrary)libSDL3);
    }

    public static void loadLibSDL3FromFilePathNow(String path) {
        if (libSDL3 != null) {
            throw new IllegalStateException("libSDL3 is already loaded");
        }
        libSDL3 = NativeLibrary.getInstance((String)path);
    }

    private static NativeLibrary loadLibSDL3() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("string-encoding", "UTF-8");
        options.put("classloader", SdlNativeLibraryLoader.class.getClassLoader());
        return NativeLibrary.getInstance((String)SDL_LIBRARY_NAME, options);
    }

    public static <T extends Library> T loadLibSDL3InterfaceInstance(Class<T> libraryInterface) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("string-encoding", "UTF-8");
        options.put("classloader", SdlNativeLibraryLoader.class.getClassLoader());
        return (T)Native.load((String)SDL_LIBRARY_NAME, libraryInterface, options);
    }
}

