/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import dev.isxander.sdl3java.api.stdinc.SdlStdinc;
import dev.isxander.sdl3java.jna.PojoStructure;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public final class JnaUtils {
    public static String extractStringAndReleaseNativeSdlMemory(Pointer pointer) {
        if (Pointer.nativeValue((Pointer)pointer) == 0L) {
            return null;
        }
        String result = pointer.getString(0L, "UTF-8");
        SdlStdinc.SDL_free(pointer);
        return result;
    }

    public static Memory writeArrayToNativeMemory(byte[] data) {
        if (data == null) {
            return null;
        }
        Memory memory = new Memory((long)data.length);
        memory.write(0L, data, 0, data.length);
        return memory;
    }

    public static Memory writeArrayToNativeMemory(short[] data) {
        if (data == null) {
            return null;
        }
        Memory memory = new Memory((long)data.length * 2L);
        memory.write(0L, data, 0, data.length);
        return memory;
    }

    public static Memory writeArrayToNativeMemory(int[] data) {
        if (data == null) {
            return null;
        }
        Memory memory = new Memory((long)data.length * 4L);
        memory.write(0L, data, 0, data.length);
        return memory;
    }

    public static Memory writeListToNativeMemory(List<? extends PojoStructure> objects) {
        long structSize = objects.get(0).size();
        Memory buffer = new Memory((long)objects.size() * structSize);
        long offset = 0L;
        for (PojoStructure pojoStructure : objects) {
            pojoStructure.write((Pointer)buffer, offset);
            offset += structSize;
        }
        return buffer;
    }

    public static String flagsUnknown(int value) {
        return "UNKNOWN(" + Integer.toBinaryString(value) + ")";
    }

    public static <T extends Structure> T copyStruct(T original) {
        Structure copy;
        try {
            copy = (Structure)original.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to construct copy of struct", e);
        }
        Pointer cp = copy.getPointer();
        Pointer op = original.getPointer();
        int size = original.size();
        original.write();
        cp.write(0L, op.getByteArray(0L, size), 0, size);
        copy.read();
        return (T)copy;
    }
}

