/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.api.version;

import java.util.Objects;

public final class SdlVersionRecord {
    private final int major;
    private final int minor;
    private final int micro;

    public SdlVersionRecord(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int micro() {
        return this.micro;
    }

    public int packed() {
        return this.major * 1000000 + this.minor * 1000 + this.micro;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdlVersionRecord that = (SdlVersionRecord)o;
        return this.major == that.major && this.minor == that.minor && this.micro == that.micro;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.micro);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro;
    }

    public static SdlVersionRecord fromPacked(int packed) {
        return new SdlVersionRecord(SdlVersionRecord.unpackMajor(packed), SdlVersionRecord.unpackMinor(packed), SdlVersionRecord.unpackMicro(packed));
    }

    public static int unpackMajor(int packed) {
        return packed / 1000000;
    }

    public static int unpackMinor(int packed) {
        return packed / 1000 % 1000;
    }

    public static int unpackMicro(int packed) {
        return packed % 1000;
    }
}

