/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.api.gamepad;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import dev.isxander.sdl3java.api.gamepad.SDL_Gamepad;
import dev.isxander.sdl3java.api.gamepad.SDL_GamepadBinding;
import dev.isxander.sdl3java.api.iostream.SDL_IOStream;
import dev.isxander.sdl3java.api.iostream.SdlIOStream;
import dev.isxander.sdl3java.api.joystick.SDL_Joystick;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickGUID;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import dev.isxander.sdl3java.jna.SdlNativeLibraryLoader;

public final class SdlGamepad {
    private SdlGamepad() {
    }

    public static native int SDL_AddGamepadMapping(String var0);

    public static native int SDL_AddGamepadMappingsFromIO(SDL_IOStream var0, boolean var1);

    public static int SDL_AddGamepadMappingsFromFile(String file) {
        return SdlGamepad.SDL_AddGamepadMappingsFromIO(SdlIOStream.SDL_IOFromFile(file, "rb"), true);
    }

    public static native boolean SDL_ReloadGamepadMappings();

    public static native String SDL_GetGamepadMappingForGUID(SDL_JoystickGUID var0);

    public static native String SDL_GetGamepadMapping(SDL_Gamepad var0);

    public static native boolean SDL_SetGamepadMapping(SDL_JoystickID var0, String var1);

    public static native boolean SDL_HasGamepad();

    public static SDL_JoystickID[] SDL_GetGamepads() {
        IntByReference count = new IntByReference();
        Pointer p = InternalNativeFunctions.SDL_GetGamepads(count);
        if (p == null) {
            return new SDL_JoystickID[0];
        }
        SDL_JoystickID[] gamepads = new SDL_JoystickID[count.getValue()];
        for (int i = 0; i < gamepads.length; ++i) {
            gamepads[i] = new SDL_JoystickID(p.getNativeLong((long)i * (long)Native.getNativeSize(SDL_JoystickID.class)).longValue());
        }
        return gamepads;
    }

    public static native boolean SDL_IsGamepad(SDL_JoystickID var0);

    public static native String SDL_GetGamepadNameForID(SDL_JoystickID var0);

    public static native String SDL_GetGamepadPathForID(SDL_JoystickID var0);

    public static native int SDL_GetGamepadPlayerIndexForID(SDL_JoystickID var0);

    public static native SDL_JoystickGUID SDL_GetGamepadGUIDForID(SDL_JoystickID var0);

    public static native char SDL_GetGamepadVendorForID(SDL_JoystickID var0);

    public static native char SDL_GetGamepadProductForID(SDL_JoystickID var0);

    public static native char SDL_GetGamepadProductVersionForID(SDL_JoystickID var0);

    public static native int SDL_GetGamepadTypeForID(SDL_JoystickID var0);

    public static native int SDL_GetRealGamepadTypeForID(SDL_JoystickID var0);

    public static native String SDL_GetGamepadMappingForID(SDL_JoystickID var0);

    public static native SDL_Gamepad SDL_OpenGamepad(SDL_JoystickID var0);

    public static native SDL_Gamepad SDL_GetGamepadFromID(SDL_JoystickID var0);

    public static native SDL_Gamepad SDL_GetGamepadFromPlayerIndex(int var0);

    public static native SDL_PropertiesID SDL_GetGamepadProperties(SDL_Gamepad var0);

    public static native SDL_JoystickID SDL_GetGamepadID(SDL_Gamepad var0);

    public static native String SDL_GetGamepadName(SDL_Gamepad var0);

    public static native String SDL_GetGamepadPath(SDL_Gamepad var0);

    public static native int SDL_GetGamepadType(SDL_Gamepad var0);

    public static native int SDL_GetRealGamepadType(SDL_Gamepad var0);

    public static native int SDL_GetGamepadPlayerIndex(SDL_Gamepad var0);

    public static native boolean SDL_SetGamepadPlayerIndex(SDL_Gamepad var0, int var1);

    public static native char SDL_GetGamepadVendor(SDL_Gamepad var0);

    public static native char SDL_GetGamepadProduct(SDL_Gamepad var0);

    public static native char SDL_GetGamepadProductVersion(SDL_Gamepad var0);

    public static native char SDL_GetGamepadFirmwareVersion(SDL_Gamepad var0);

    public static native String SDL_GetGamepadSerial(SDL_Gamepad var0);

    public static native long SDL_GetGamepadSteamHandle(SDL_Gamepad var0);

    public static native int SDL_GetGamepadConnectionState(SDL_Gamepad var0);

    public static native int SDL_GetGamepadPowerInfo(SDL_Gamepad var0, IntByReference var1);

    public static native boolean SDL_GamepadConnected(SDL_Gamepad var0);

    public static native SDL_Joystick SDL_GetGamepadJoystick(SDL_Gamepad var0);

    public static native void SDL_SetGamepadEventsEnabled(boolean var0);

    public static native boolean SDL_GamepadEventsEnabled();

    public static native SDL_GamepadBinding SDL_GetGamepadBindings(SDL_Gamepad var0, IntByReference var1);

    public static native void SDL_UpdateGamepads();

    public static native int SDL_GetGamepadTypeFromString(String var0);

    public static native String SDL_GetGamepadStringForType(int var0);

    public static native int SDL_GetGamepadAxisFromString(String var0);

    public static native String SDL_GetGamepadStringForAxis(int var0);

    public static native boolean SDL_GamepadHasAxis(SDL_Gamepad var0, int var1);

    public static native short SDL_GetGamepadAxis(SDL_Gamepad var0, int var1);

    public static native int SDL_GetGamepadButtonFromString(String var0);

    public static native String SDL_GetGamepadStringForButton(int var0);

    public static native boolean SDL_GamepadHasButton(SDL_Gamepad var0, int var1);

    public static native boolean SDL_GetGamepadButton(SDL_Gamepad var0, int var1);

    public static native int SDL_GetGamepadButtonLabelForType(int var0, int var1);

    public static native int SDL_GetGamepadButtonLabel(SDL_Gamepad var0, int var1);

    public static native int SDL_GetNumGamepadTouchpads(SDL_Gamepad var0);

    public static native int SDL_GetNumGamepadTouchpadFingers(SDL_Gamepad var0, int var1);

    public static native boolean SDL_GetGamepadTouchpadFinger(SDL_Gamepad var0, int var1, int var2, ByteByReference var3, FloatByReference var4, FloatByReference var5, FloatByReference var6);

    public static native boolean SDL_GamepadHasSensor(SDL_Gamepad var0, int var1);

    public static native boolean SDL_SetGamepadSensorEnabled(SDL_Gamepad var0, int var1, boolean var2);

    public static native boolean SDL_GamepadSensorEnabled(SDL_Gamepad var0, int var1);

    public static native float SDL_GetGamepadSensorDataRate(SDL_Gamepad var0, int var1);

    public static native boolean SDL_GetGamepadSensorData(SDL_Gamepad var0, int var1, Pointer var2, int var3);

    public static native boolean SDL_RumbleGamepad(SDL_Gamepad var0, char var1, char var2, long var3);

    public static native boolean SDL_RumbleGamepadTriggers(SDL_Gamepad var0, char var1, char var2, long var3);

    public static native boolean SDL_SetGamepadLED(SDL_Gamepad var0, byte var1, byte var2, byte var3);

    public static native boolean SDL_SendGamepadEffect(SDL_Gamepad var0, Pointer var1, int var2);

    public static native boolean SDL_CloseGamepad(SDL_Gamepad var0);

    public static native String SDL_GetGamepadAppleSFSymbolsNameForButton(SDL_Gamepad var0, int var1);

    public static native String SDL_GetGamepadAppleSFSymbolsNameForAxis(SDL_Gamepad var0, int var1);

    static {
        SdlNativeLibraryLoader.registerNativeMethods(SdlGamepad.class);
        SdlNativeLibraryLoader.registerNativeMethods(InternalNativeFunctions.class);
    }

    private static final class InternalNativeFunctions {
        private InternalNativeFunctions() {
        }

        public static native Pointer SDL_GetGamepads(IntByReference var0);
    }
}

