/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.api.gamepad;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;

@Structure.FieldOrder(value={"bindType", "value"})
public final class SDL_GamepadBinding
extends Structure {
    public int inputType;
    public InputTypeValue input;
    public int outputType;
    public OutputTypeValue output;

    public SDL_GamepadBinding() {
    }

    public SDL_GamepadBinding(Pointer p) {
        super(p);
    }

    public void read() {
        this.readField("bindType");
        switch (this.inputType) {
            case 1: {
                this.input.setType("button");
                break;
            }
            case 2: {
                this.input.setType("axis");
                break;
            }
            case 3: {
                this.input.setType("hat");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid bind type: " + this.inputType);
            }
        }
        switch (this.outputType) {
            case 1: {
                this.output.setType("button");
                break;
            }
            case 2: {
                this.output.setType("axis");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid bind type: " + this.outputType);
            }
        }
        super.read();
    }

    public static final class InputTypeValue
    extends Union {
        public int button;
        public Axis axis;
        public Hat hat;

        public InputTypeValue() {
        }

        public InputTypeValue(Pointer p) {
            super(p);
        }
    }

    public static final class OutputTypeValue
    extends Union {
        public int button;
        public Axis axis;
    }

    @Structure.FieldOrder(value={"hat", "hat_mask"})
    public static final class Hat
    extends Structure {
        public int hat;
        public int hat_mask;

        public Hat() {
        }

        public Hat(Pointer p) {
            super(p);
        }
    }

    @Structure.FieldOrder(value={"axis", "axis_min", "axis_max"})
    public static final class Axis
    extends Structure {
        public int axis;
        public int axis_min;
        public int axis_max;

        public Axis() {
        }

        public Axis(Pointer p) {
            super(p);
        }
    }
}

