/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.api.audio;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import dev.isxander.sdl3java.api.audio.SDL_AudioDeviceID;
import dev.isxander.sdl3java.api.audio.SDL_AudioFormat;
import dev.isxander.sdl3java.api.audio.SDL_AudioPostmixCallback;
import dev.isxander.sdl3java.api.audio.SDL_AudioSpec;
import dev.isxander.sdl3java.api.audio.SDL_AudioStream;
import dev.isxander.sdl3java.api.audio.SDL_AudioStreamCallback;
import dev.isxander.sdl3java.api.iostream.SDL_IOStream;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import dev.isxander.sdl3java.jna.SdlNativeLibraryLoader;
import org.jetbrains.annotations.Nullable;

public final class SdlAudio {
    public static native int SDL_GetNumAudioDrivers();

    public static native String SDL_GetAudioDriver(int var0);

    public static native String SDL_GetCurrentAudioDriver();

    public static SDL_AudioDeviceID[] SDL_GetAudioPlaybackDevices() {
        IntByReference count = new IntByReference();
        Pointer pointer = InternalNativeFunctions.SDL_GetAudioPlaybackDevices(count);
        return SdlAudio.pointerToDevList(pointer, count);
    }

    public static SDL_AudioDeviceID[] SDL_GetAudioRecordingDevices() {
        IntByReference count = new IntByReference();
        Pointer pointer = InternalNativeFunctions.SDL_GetAudioRecordingDevices(count);
        return SdlAudio.pointerToDevList(pointer, count);
    }

    public static native String SDL_GetAudioDeviceName(SDL_AudioDeviceID var0);

    public static native boolean SDL_GetAudioDeviceFormat(SDL_AudioDeviceID var0, SDL_AudioSpec.ByReference var1, IntByReference var2);

    public static native SDL_AudioDeviceID SDL_OpenAudioDevice(SDL_AudioDeviceID var0, SDL_AudioSpec.ByReference var1);

    public static native boolean SDL_PauseAudioDevice(SDL_AudioDeviceID var0);

    public static native boolean SDL_ResumeAudioDevice(SDL_AudioDeviceID var0);

    public static native boolean SDL_AudioDevicePaused(SDL_AudioDeviceID var0);

    public static native float SDL_GetAudioDeviceGain(SDL_AudioDeviceID var0);

    public static native void SDL_CloseAudioDevice(SDL_AudioDeviceID var0);

    public static boolean SDL_BindAudioStreams(SDL_AudioDeviceID devid, SDL_AudioStream[] streams) {
        long size = Native.getNativeSize(SDL_AudioStream.class);
        try (Memory memory = new Memory((long)streams.length * size);){
            Pointer[] ps = new Pointer[streams.length];
            for (int i = 0; i < streams.length; ++i) {
                ps[i] = streams[i].getPointer();
            }
            memory.write(0L, ps, 0, streams.length);
            boolean bl = InternalNativeFunctions.SDL_BindAudioStreams(devid, (Pointer)memory, streams.length);
            return bl;
        }
    }

    public static native boolean SDL_BindAudioStream(SDL_AudioDeviceID var0, SDL_AudioStream var1);

    public static void SDL_UnbindAudioStreams(SDL_AudioStream[] streams) {
        long size = Native.getNativeSize(SDL_AudioStream.class);
        try (Memory memory = new Memory((long)streams.length * size);){
            Pointer[] ps = new Pointer[streams.length];
            for (int i = 0; i < streams.length; ++i) {
                ps[i] = streams[i].getPointer();
            }
            memory.write(0L, ps, 0, streams.length);
            InternalNativeFunctions.SDL_UnbindAudioStreams((Pointer)memory, streams.length);
        }
    }

    public static native void SDL_UnbindAudioStream(SDL_AudioStream var0);

    public static native SDL_AudioDeviceID SDL_GetAudioStreamDevice(SDL_AudioStream var0);

    public static native SDL_AudioStream SDL_CreateAudioStream(SDL_AudioSpec var0, SDL_AudioSpec var1);

    public static native SDL_PropertiesID SDL_GetAudioStreamProperties(SDL_AudioStream var0);

    public static native boolean SDL_GetAudioStreamFormat(SDL_AudioStream var0, SDL_AudioSpec.ByReference var1, SDL_AudioSpec.ByReference var2);

    public static native boolean SDL_SetAudioStreamFormat(SDL_AudioStream var0, @Nullable SDL_AudioSpec.ByValue var1, @Nullable SDL_AudioSpec.ByValue var2);

    public static native float SDL_GetAudioStreamFrequencyRatio(SDL_AudioStream var0);

    public static native boolean SDL_SetAudioStreamFrequencyRatio(SDL_AudioStream var0, float var1);

    public static native float SDL_GetAudioStreamGain(SDL_AudioStream var0);

    public static native boolean SDL_SetAudioStreamGain(SDL_AudioStream var0, float var1);

    public static int[] SDL_GetAudioStreamInputChannelMap(SDL_AudioStream stream) {
        return SdlAudio.getChannelMap(stream, InternalNativeFunctions::SDL_GetAudioStreamInputChannelMap);
    }

    public static int[] SDL_GetAudioStreamOutputChannelMap(SDL_AudioStream stream) {
        return SdlAudio.getChannelMap(stream, InternalNativeFunctions::SDL_GetAudioStreamOutputChannelMap);
    }

    public static boolean SDL_SetAudioStreamInputChannelMap(SDL_AudioStream stream, int[] map) {
        return SdlAudio.setChannelMap(stream, map, InternalNativeFunctions::SDL_SetAudioStreamInputChannelMap);
    }

    public static boolean SDL_SetAudioStreamOutputChannelMap(SDL_AudioStream stream, int[] map) {
        return SdlAudio.setChannelMap(stream, map, InternalNativeFunctions::SDL_SetAudioStreamOutputChannelMap);
    }

    public static native boolean SDL_PutAudioStreamData(SDL_AudioStream var0, Pointer var1, int var2);

    public static native int SDL_GetAudioStreamData(SDL_AudioStream var0, Pointer var1, int var2);

    public static native int SDL_GetAudioStreamAvailable(SDL_AudioStream var0);

    public static native int SDL_GetAudioStreamQueued(SDL_AudioStream var0);

    public static native boolean SDL_FlushAudioStream(SDL_AudioStream var0);

    public static native boolean SDL_ClearAudioStream(SDL_AudioStream var0);

    public static native boolean SDL_PauseAudioStreamDevice(SDL_AudioStream var0);

    public static native boolean SDL_ResumeAudioStreamDevice(SDL_AudioStream var0);

    public static native boolean SDL_LockAudioStream(SDL_AudioStream var0);

    public static native boolean SDL_UnlockAudioStream(SDL_AudioStream var0);

    public static native boolean SDL_SetAudioStreamGetCallback(SDL_AudioStream var0, SDL_AudioStreamCallback var1, Pointer var2);

    public static native boolean SDL_SetAudioStreamPutCallback(SDL_AudioStream var0, SDL_AudioStreamCallback var1, Pointer var2);

    public static native void SDL_DestroyAudioStream(SDL_AudioStream var0);

    public static native SDL_AudioStream SDL_OpenAudioDeviceStream(SDL_AudioDeviceID var0, SDL_AudioSpec var1, SDL_AudioStreamCallback var2, Pointer var3);

    public static native boolean SDL_SetAudioPostmixCallback(SDL_AudioDeviceID var0, SDL_AudioPostmixCallback var1, Pointer var2);

    public static native boolean SDL_LoadWAV_IO(SDL_IOStream var0, boolean var1, SDL_AudioSpec var2, PointerByReference var3, IntByReference var4);

    public static native boolean SDL_LoadWAV(String var0, SDL_AudioSpec var1, PointerByReference var2, IntByReference var3);

    public static native boolean SDL_MixAudio(PointerByReference var0, Pointer var1, SDL_AudioFormat var2, long var3, float var5);

    public static native boolean SDL_ConvertAudioSamples(SDL_AudioSpec var0, Pointer var1, int var2, SDL_AudioSpec var3, PointerByReference var4, IntByReference var5);

    public static native int SDL_GetSilenceValueForFormat(SDL_AudioFormat var0);

    private static SDL_AudioDeviceID[] pointerToDevList(Pointer pointer, IntByReference count) {
        if (pointer == null) {
            return new SDL_AudioDeviceID[0];
        }
        SDL_AudioDeviceID[] devs = new SDL_AudioDeviceID[count.getValue()];
        for (int i = 0; i < count.getValue(); ++i) {
            devs[i] = new SDL_AudioDeviceID(pointer.getInt((long)i * 4L));
        }
        return devs;
    }

    private static int[] getChannelMap(SDL_AudioStream stream, ChannelMapGetter getter) {
        IntByReference count = new IntByReference();
        Pointer channelMap = getter.getChannelMap(stream, count);
        if (channelMap == null) {
            return null;
        }
        int[] map = new int[count.getValue()];
        for (int i = 0; i < count.getValue(); ++i) {
            map[i] = channelMap.getInt((long)i * 4L);
        }
        return map;
    }

    private static boolean setChannelMap(SDL_AudioStream stream, int[] map, ChannelMapSetter setter) {
        try (Memory memory = new Memory((long)map.length * 4L);){
            memory.write(0L, map, 0, map.length);
            boolean bl = setter.setChannelMap(stream, (Pointer)memory, map.length);
            return bl;
        }
    }

    static {
        SdlNativeLibraryLoader.registerNativeMethods(SdlAudio.class);
        SdlNativeLibraryLoader.registerNativeMethods(InternalNativeFunctions.class);
    }

    private static final class InternalNativeFunctions {
        private InternalNativeFunctions() {
        }

        public static native Pointer SDL_GetAudioPlaybackDevices(IntByReference var0);

        public static native Pointer SDL_GetAudioRecordingDevices(IntByReference var0);

        public static native boolean SDL_BindAudioStreams(SDL_AudioDeviceID var0, Pointer var1, int var2);

        public static native void SDL_UnbindAudioStreams(Pointer var0, int var1);

        public static native Pointer SDL_GetAudioStreamInputChannelMap(SDL_AudioStream var0, IntByReference var1);

        public static native Pointer SDL_GetAudioStreamOutputChannelMap(SDL_AudioStream var0, IntByReference var1);

        public static native boolean SDL_SetAudioStreamInputChannelMap(SDL_AudioStream var0, Pointer var1, int var2);

        public static native boolean SDL_SetAudioStreamOutputChannelMap(SDL_AudioStream var0, Pointer var1, int var2);
    }

    @FunctionalInterface
    private static interface ChannelMapGetter {
        public Pointer getChannelMap(SDL_AudioStream var1, IntByReference var2);
    }

    @FunctionalInterface
    private static interface ChannelMapSetter {
        public boolean setChannelMap(SDL_AudioStream var1, Pointer var2, int var3);
    }
}

