/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.conditionalmixin.api.util.fabric;

import java.lang.reflect.Method;
import java.util.Optional;
import me.fallenbreath.conditionalmixin.ConditionalMixinMod;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public class VersionCheckerImpl {
    public static boolean isModPresent(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static Optional<String> getModVersionString(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(c -> c.getMetadata().getVersion().getFriendlyString());
    }

    private static boolean doesVersionSatisfyPredicateImpl(Version version, String versionPredicate) {
        try {
            return VersionPredicate.parse((String)versionPredicate).test((Object)version);
        }
        catch (NoClassDefFoundError e) {
            try {
                Class<?> clazz = Class.forName("net.fabricmc.loader.util.version.VersionPredicateParser");
                Method matches = clazz.getMethod("matches", Version.class, String.class);
                return (Boolean)matches.invoke(null, version, versionPredicate);
            }
            catch (Exception ex) {
                ConditionalMixinMod.LOGGER.error("Failed to invoke VersionPredicateParser#matches", (Throwable)ex);
            }
        }
        catch (Exception e) {
            ConditionalMixinMod.LOGGER.error("Failed to parse version or version predicate {} {}: {}", (Object)version.getFriendlyString(), (Object)versionPredicate, (Object)e);
        }
        return false;
    }

    @Deprecated
    public static boolean doesVersionSatisfyPredicate(Object version, String versionPredicate) {
        return VersionCheckerImpl.doesVersionSatisfyPredicateImpl((Version)version, versionPredicate);
    }

    public static boolean doesModVersionSatisfyPredicate(String modId, String versionPredicate) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        return mod.isPresent() && VersionCheckerImpl.doesVersionSatisfyPredicateImpl(((ModContainer)mod.get()).getMetadata().getVersion(), versionPredicate);
    }
}

