/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.util.HttpUtil;
import com.terraformersmc.modmenu.util.UpdateCheckerThreadFactory;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModrinthUpdateInfo;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckerUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu/Update Checker");
    private static boolean modrinthApiV2Deprecated = false;

    private static boolean allowsUpdateChecks(Mod mod) {
        return mod.allowsUpdateChecks();
    }

    public static void checkForUpdates() {
        if (!ModMenuConfig.UPDATE_CHECKER.getValue()) {
            return;
        }
        LOGGER.info("Checking mod updates...");
        class_156.method_18349().execute(UpdateCheckerUtil::checkForUpdates0);
    }

    private static void checkForUpdates0() {
        try (ExecutorService executor = Executors.newThreadPerTaskExecutor(new UpdateCheckerThreadFactory());){
            ArrayList<Mod> withoutUpdateChecker = new ArrayList<Mod>();
            List<Mod> updatableMods = ModMenu.MODS.values().stream().filter(UpdateCheckerUtil::allowsUpdateChecks).toList();
            for (Mod mod : updatableMods) {
                UpdateChecker updateChecker = mod.getUpdateChecker();
                if (updateChecker == null) {
                    withoutUpdateChecker.add(mod);
                    continue;
                }
                executor.submit(() -> {
                    Thread.currentThread().setName("ModMenu/Update Checker/%s".formatted(mod.getName()));
                    UpdateInfo update = updateChecker.checkForUpdates();
                    if (update == null) {
                        return;
                    }
                    mod.setUpdateInfo(update);
                    LOGGER.info("Update available for '{}@{}'", (Object)mod.getId(), (Object)mod.getVersion());
                });
            }
            if (modrinthApiV2Deprecated) {
                return;
            }
            Map<String, Set<Mod>> modHashes = UpdateCheckerUtil.getModHashes(withoutUpdateChecker);
            Future<Map> currentVersionsFuture = executor.submit(() -> UpdateCheckerUtil.getCurrentVersions(modHashes.keySet()));
            Future<Map> updatedVersionsFuture = executor.submit(() -> UpdateCheckerUtil.getUpdatedVersions(modHashes.keySet()));
            Map currentVersions = null;
            Map updatedVersions = null;
            try {
                currentVersions = currentVersionsFuture.get();
                updatedVersions = updatedVersionsFuture.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (currentVersions == null || updatedVersions == null) {
                return;
            }
            for (String hash : modHashes.keySet()) {
                Instant date = (Instant)currentVersions.get(hash);
                VersionUpdate data = (VersionUpdate)updatedVersions.get(hash);
                if (date == null || data == null || Objects.equals(hash, data.hash) || date.compareTo(data.releaseDate) >= 0) continue;
                for (Mod mod : modHashes.get(hash)) {
                    mod.setUpdateInfo(data.asUpdateInfo());
                    LOGGER.info("Update available for '{}@{}', (-> {})", new Object[]{mod.getId(), mod.getVersion(), data.versionNumber});
                }
            }
        }
    }

    private static Map<String, Set<Mod>> getModHashes(Collection<Mod> mods) {
        HashMap<String, Set<Mod>> results = new HashMap<String, Set<Mod>>();
        for (Mod mod : mods) {
            String modId = mod.getId();
            try {
                String hash = mod.getSha512Hash();
                if (hash == null) continue;
                LOGGER.debug("Hash for {} is {}", (Object)modId, (Object)hash);
                results.putIfAbsent(hash, new HashSet());
                ((Set)results.get(hash)).add(mod);
            }
            catch (IOException e) {
                LOGGER.error("Error getting mod hash for mod {}: ", (Object)modId, (Object)e);
            }
        }
        return results;
    }

    public static void triggerV2DeprecatedToast() {
        if (modrinthApiV2Deprecated && ModMenuConfig.UPDATE_CHECKER.getValue()) {
            class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"modmenu.modrinth.v2_deprecated.title"), (class_2561)class_2561.method_43471((String)"modmenu.modrinth.v2_deprecated.description")));
        }
    }

    @Nullable
    private static Map<String, Instant> getCurrentVersions(Collection<String> modHashes) {
        String body = ModMenu.GSON_MINIFIED.toJson((Object)new CurrentVersionsFromHashes(modHashes));
        HttpRequest.Builder request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/json").uri(URI.create("https://api.modrinth.com/v2/version_files"));
        try {
            HttpResponse<String> response = HttpUtil.request(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 410) {
                modrinthApiV2Deprecated = true;
                LOGGER.warn("Modrinth API v2 is deprecated, unable to check for mod updates.");
            } else if (response.statusCode() == 200) {
                HashMap<String, Instant> results = new HashMap<String, Instant>();
                JsonObject data = JsonParser.parseString((String)response.body()).getAsJsonObject();
                data.asMap().forEach((hash, inner) -> {
                    Instant date;
                    JsonObject version = inner.getAsJsonObject();
                    try {
                        date = Instant.parse(version.get("date_published").getAsString());
                    }
                    catch (DateTimeParseException e) {
                        return;
                    }
                    results.put((String)hash, date);
                });
                return results;
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Error checking for versions: ", (Throwable)e);
        }
        return null;
    }

    private static UpdateChannel getUpdateChannel(String versionType) {
        try {
            return UpdateChannel.valueOf(versionType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return UpdateChannel.RELEASE;
        }
    }

    @Nullable
    private static Map<String, VersionUpdate> getUpdatedVersions(Collection<String> modHashes) {
        String mcVer = class_155.method_16673().method_48019();
        List<String> loaders = ModMenu.RUNNING_QUILT ? List.of("fabric", "quilt") : List.of("fabric");
        UpdateChannel preferredChannel = UpdateChannel.getUserPreference();
        List<UpdateChannel> updateChannels = preferredChannel == UpdateChannel.RELEASE ? List.of(UpdateChannel.RELEASE) : (preferredChannel == UpdateChannel.BETA ? List.of(UpdateChannel.BETA, UpdateChannel.RELEASE) : List.of(UpdateChannel.ALPHA, UpdateChannel.BETA, UpdateChannel.RELEASE));
        String body = ModMenu.GSON_MINIFIED.toJson((Object)new LatestVersionsFromHashesBody(modHashes, loaders, mcVer, updateChannels));
        LOGGER.debug("Body: {}", (Object)body);
        HttpRequest.Builder latestVersionsRequest = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/json").uri(URI.create("https://api.modrinth.com/v2/version_files/update"));
        try {
            HttpResponse<String> latestVersionsResponse = HttpUtil.request(latestVersionsRequest, HttpResponse.BodyHandlers.ofString());
            int status = latestVersionsResponse.statusCode();
            LOGGER.debug("Status: {}", (Object)status);
            if (status == 410) {
                modrinthApiV2Deprecated = true;
                LOGGER.warn("Modrinth API v2 is deprecated, unable to check for mod updates.");
            } else if (status == 200) {
                HashMap<String, VersionUpdate> results = new HashMap<String, VersionUpdate>();
                JsonObject responseObject = JsonParser.parseString((String)latestVersionsResponse.body()).getAsJsonObject();
                LOGGER.debug(String.valueOf(responseObject));
                responseObject.asMap().forEach((lookupHash, versionJson) -> {
                    Instant date;
                    JsonObject versionObj = versionJson.getAsJsonObject();
                    String projectId = versionObj.get("project_id").getAsString();
                    String versionType = versionObj.get("version_type").getAsString();
                    String versionNumber = versionObj.get("version_number").getAsString();
                    String versionId = versionObj.get("id").getAsString();
                    Optional<JsonElement> primaryFile = versionObj.get("files").getAsJsonArray().asList().stream().filter(file -> file.getAsJsonObject().get("primary").getAsBoolean()).findFirst();
                    if (primaryFile.isEmpty()) {
                        return;
                    }
                    try {
                        date = Instant.parse(versionObj.get("date_published").getAsString());
                    }
                    catch (DateTimeParseException e) {
                        return;
                    }
                    UpdateChannel updateChannel = UpdateCheckerUtil.getUpdateChannel(versionType);
                    String versionHash = primaryFile.get().getAsJsonObject().get("hashes").getAsJsonObject().get("sha512").getAsString();
                    results.put((String)lookupHash, new VersionUpdate(projectId, versionId, versionNumber, date, updateChannel, versionHash));
                });
                return results;
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Error checking for updates: ", (Throwable)e);
        }
        return null;
    }

    private record VersionUpdate(String projectId, String versionId, String versionNumber, Instant releaseDate, UpdateChannel updateChannel, String hash) {
        private UpdateInfo asUpdateInfo() {
            return new ModrinthUpdateInfo(this.projectId, this.versionId, this.versionNumber, this.updateChannel);
        }
    }

    public static class CurrentVersionsFromHashes {
        public Collection<String> hashes;
        public String algorithm = "sha512";

        public CurrentVersionsFromHashes(Collection<String> hashes) {
            this.hashes = hashes;
        }
    }

    public static class LatestVersionsFromHashesBody {
        public Collection<String> hashes;
        public String algorithm = "sha512";
        public Collection<String> loaders;
        @SerializedName(value="game_versions")
        public Collection<String> gameVersions;
        @SerializedName(value="version_types")
        public Collection<String> versionTypes;

        public LatestVersionsFromHashesBody(Collection<String> hashes, Collection<String> loaders, String mcVersion, Collection<UpdateChannel> updateChannels) {
            this.hashes = hashes;
            this.loaders = loaders;
            this.gameVersions = Set.of(mcVersion);
            this.versionTypes = updateChannels.stream().map(value -> value.toString().toLowerCase()).toList();
        }
    }
}

