/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.entries.ChildEntry;
import com.terraformersmc.modmenu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ModListWidget
extends class_4280<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private final FabricIconHandler iconHandler = new FabricIconHandler();
    private Double restoreScrollY = null;

    public ModListWidget(class_310 client, int width, int height, int y, int itemHeight, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
            this.restoreScrollY = list.method_44387();
        }
    }

    public void method_44382(double amount) {
        super.method_44382(amount);
        int denominator = Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4));
        if (denominator == 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.method_44387() / (double)Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)));
        }
    }

    public boolean method_25370() {
        return this.parent.method_25399() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            Mod mod = entry.getMod();
            this.field_22740.method_44713().method_19788(class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{mod.getTranslatedName()}).getString());
        }
    }

    public void setSelected(@Nullable ModListEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.selectedModId = entry == null ? null : entry.getMod().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.method_25334());
    }

    protected boolean method_25332(int index) {
        ModListEntry selected = (ModListEntry)this.method_25334();
        return selected != null && selected.getMod().getId().equals(((ModListEntry)this.method_25326(index)).getMod().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int i = super.method_25321((class_350.class_351)entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        return super.method_25330((class_350.class_351)entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(((ModListEntry)this.method_25326((int)index)).mod);
        return (ModListEntry)super.method_25338(index);
    }

    public void finalizeInit() {
        this.reloadFilters();
        if (this.restoreScrollY != null) {
            this.method_44382(this.restoreScrollY);
            this.restoreScrollY = null;
        }
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = !ModMenuConfig.SHOW_LIBRARIES.getValue();
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains((Object)Mod.Badge.LIBRARY));
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.method_25339();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            if (ModMenuConfig.CONFIG_MODE.getValue()) {
                return !this.parent.getModHasConfigScreen(mod.getId());
            }
            return !mod.isHidden();
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
        }
        for (Mod mod2 : ModSearch.search(this.parent, searchTerm, this.mods)) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains((Object)Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(ModMenuConfig.SORTING.getValue().getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.method_25396().isEmpty() || this.method_25334() != null && ((ModListEntry)this.method_25334()).getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.method_25396()) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.method_25334() == null && !this.method_25396().isEmpty() && this.method_25326(0) != null) {
            this.setSelected((ModListEntry)this.method_25326(0));
        }
        if (this.method_44387() > (double)Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4))) {
            this.method_44382(Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)));
        }
    }

    protected void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int entryCount = this.method_25340();
        for (int index = 0; index < entryCount; ++index) {
            int entryLeft;
            int entryTop = this.method_25337(index) + 2;
            int entryBottom = this.method_25337(index) + this.field_22741;
            if (entryBottom < this.method_46427() || entryTop > this.method_55443()) continue;
            int entryHeight = this.field_22741 - 4;
            ModListEntry entry = (ModListEntry)this.method_25326(index);
            int rowWidth = this.method_25322();
            if (this.method_25332(index)) {
                Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
                entryLeft = this.method_25342() - 2 + entry.getXOffset();
                int selectionRight = this.method_25342() + rowWidth + 2;
                float float_2 = this.method_25370() ? 1.0f : 0.5f;
                int topColor = class_9848.method_61318((float)1.0f, (float)float_2, (float)float_2, (float)float_2);
                int bottomColor = class_9848.method_61318((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                RenderPipeline pipeline = class_10799.field_56879;
                try (class_9799 alloc = new class_9799(pipeline.getVertexFormat().getVertexSize() * 4);){
                    class_287 bufferBuilder = new class_287(alloc, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
                    bufferBuilder.method_22918(matrix, (float)entryLeft, (float)(entryTop + entryHeight + 2), 0.0f).method_39415(topColor);
                    bufferBuilder.method_22918(matrix, (float)selectionRight, (float)(entryTop + entryHeight + 2), 0.0f).method_39415(topColor);
                    bufferBuilder.method_22918(matrix, (float)selectionRight, (float)(entryTop - 2), 0.0f).method_39415(topColor);
                    bufferBuilder.method_22918(matrix, (float)entryLeft, (float)(entryTop - 2), 0.0f).method_39415(topColor);
                    bufferBuilder.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop + entryHeight + 1), 0.0f).method_39415(bottomColor);
                    bufferBuilder.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop + entryHeight + 1), 0.0f).method_39415(bottomColor);
                    bufferBuilder.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop - 1), 0.0f).method_39415(bottomColor);
                    bufferBuilder.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop - 1), 0.0f).method_39415(bottomColor);
                    try (class_9801 builtBuffer = bufferBuilder.method_60794();){
                        if (builtBuffer == null) {
                            alloc.close();
                            return;
                        }
                        class_276 framebuffer = class_310.method_1551().method_1522();
                        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
                        VertexFormat.class_5595 indexType = autoStorageIndexBuffer.method_31924();
                        GpuBuffer indexBuffer = autoStorageIndexBuffer.method_68274(builtBuffer.method_60822().comp_751());
                        GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Mod List", BufferType.VERTICES, BufferUsage.DYNAMIC_WRITE, builtBuffer.method_60818().remaining());
                        RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer, builtBuffer.method_60818(), 0);
                        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(framebuffer.method_30277(), OptionalInt.empty(), framebuffer.method_30278(), OptionalDouble.empty());){
                            renderPass.setPipeline(pipeline);
                            renderPass.setVertexBuffer(0, vertexBuffer);
                            renderPass.setIndexBuffer(indexBuffer, indexType);
                            renderPass.drawIndexed(0, builtBuffer.method_60822().comp_751());
                        }
                    }
                }
            }
            entryLeft = this.method_25342();
            entry.method_25343(drawContext, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    public void ensureVisible(ModListEntry entry) {
        super.method_25328((class_350.class_351)entry);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265 || keyCode == 264) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.method_25334() != null) {
            return ((ModListEntry)this.method_25334()).method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.method_46427())) - this.field_22748 + (int)this.method_44387() - 4;
        int index = int_5 / this.field_22741;
        return x < (double)this.method_65507() && x >= (double)this.method_25342() && x <= (double)(this.method_25342() + this.method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? (ModListEntry)((Object)this.method_25396().get(index)) : null;
    }

    protected int method_65507() {
        return this.field_22758 - 6;
    }

    public int method_25322() {
        return this.field_22758 - (Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.method_46426() + 6;
    }

    public int getTop() {
        return this.method_46427();
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int method_44395() {
        return super.method_44395() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.method_25396()) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public FabricIconHandler getFabricIconHandler() {
        return this.iconHandler;
    }
}

