/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.irisshaders.iris.compat.SkipList;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.blending.DepthColorStorage;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.irisshaders.iris.mixinterface.ShaderInstanceInterface;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.samplers.IrisSamplers;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.class_10789;
import net.minecraft.class_284;
import net.minecraft.class_5944;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public class ExtendedShader
extends class_5944 {
    private static final Matrix4f identity;
    private static final Logger LOGGER;
    private static ExtendedShader lastApplied;
    private final boolean intensitySwizzle;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final boolean hasOverrides;
    private final class_284 modelViewInverse;
    private final class_284 projectionInverse;
    private final Matrix3f normalMatrix = new Matrix3f();
    private final CustomUniforms customUniforms;
    private final IrisRenderingPipeline parent;
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private final GlFramebuffer writingToBeforeTranslucent;
    private final GlFramebuffer writingToAfterTranslucent;
    private final BlendModeOverride blendModeOverride;
    private final float alphaTest;
    private final boolean usesTessellation;
    private final Matrix4f tempMatrix4f = new Matrix4f();
    private final Matrix3f tempMatrix3f = new Matrix3f();
    private final float[] tempFloats = new float[16];
    private final float[] tempFloats2 = new float[9];
    private final int normalMat;
    private int textureToUnswizzle;
    private float[] tempF = new float[9];

    public ExtendedShader(int programId, String string, VertexFormat vertexFormat, boolean usesTessellation, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, BlendModeOverride blendModeOverride, AlphaTest alphaTest, Consumer<DynamicLocationalUniformHolder> uniformCreator, BiConsumer<SamplerHolder, ImageHolder> samplerCreator, boolean isIntensity, IrisRenderingPipeline parent, @Nullable List<BufferBlendOverride> bufferBlendOverrides, CustomUniforms customUniforms) throws IOException {
        super(programId, string);
        GLDebug.nameObject(33506, programId, string);
        ((ShaderInstanceInterface)((Object)this)).setShouldSkip(SkipList.NONE);
        ArrayList<RenderPipeline.UniformDescription> uniformList = new ArrayList<RenderPipeline.UniformDescription>();
        ArrayList<String> samplerList = new ArrayList<String>();
        uniformList.add(new RenderPipeline.UniformDescription("iris_ModelViewMat", class_10789.field_56747));
        uniformList.add(new RenderPipeline.UniformDescription("iris_ModelViewMatInverse", class_10789.field_56747));
        uniformList.add(new RenderPipeline.UniformDescription("iris_ProjMat", class_10789.field_56747));
        uniformList.add(new RenderPipeline.UniformDescription("iris_ProjMatInverse", class_10789.field_56747));
        uniformList.add(new RenderPipeline.UniformDescription("iris_TextureMat", class_10789.field_56747));
        uniformList.add(new RenderPipeline.UniformDescription("iris_ColorModulator", class_10789.field_56746));
        uniformList.add(new RenderPipeline.UniformDescription("iris_FogColor", class_10789.field_56746));
        uniformList.add(new RenderPipeline.UniformDescription("iris_FogStart", class_10789.field_56743));
        uniformList.add(new RenderPipeline.UniformDescription("iris_FogEnd", class_10789.field_56743));
        uniformList.add(new RenderPipeline.UniformDescription("iris_GlintAlpha", class_10789.field_56743));
        uniformList.add(new RenderPipeline.UniformDescription("iris_ModelOffset", class_10789.field_56745));
        if (vertexFormat.contains(VertexFormatElement.UV)) {
            samplerList.add("Sampler0");
        }
        if (vertexFormat.contains(VertexFormatElement.UV1)) {
            samplerList.add("Sampler1");
        }
        if (vertexFormat.contains(VertexFormatElement.UV2)) {
            samplerList.add("Sampler2");
        }
        this.method_62900(uniformList, samplerList);
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder(string, programId);
        ProgramSamplers.Builder samplerBuilder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        uniformCreator.accept(uniformBuilder);
        this.normalMat = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"iris_NormalMat");
        ProgramImages.Builder builder = ProgramImages.builder(programId);
        samplerCreator.accept(samplerBuilder, builder);
        customUniforms.mapholderToPass(uniformBuilder, (Object)this);
        this.usesTessellation = usesTessellation;
        this.uniforms = uniformBuilder.buildUniforms();
        this.customUniforms = customUniforms;
        this.samplers = samplerBuilder.build();
        this.images = builder.build();
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = bufferBlendOverrides;
        this.hasOverrides = bufferBlendOverrides != null && !bufferBlendOverrides.isEmpty();
        this.alphaTest = alphaTest.reference();
        this.parent = parent;
        this.modelViewInverse = this.method_34582("ModelViewMatInverse");
        this.projectionInverse = this.method_34582("ProjMatInverse");
        this.intensitySwizzle = isIntensity;
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    public void method_34585() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        if (this.blendModeOverride != null || this.hasOverrides) {
            BlendModeOverride.restore();
        }
        super.method_34585();
    }

    public void method_60897(VertexFormat.class_5596 mode, Matrix4f modelView, Matrix4f projection, float width, float height) {
        DepthColorStorage.unlockDepthColor();
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        GlStateManager._glUseProgram((int)this.method_1270());
        super.method_60897(mode, modelView, projection, width, height);
        if (this.modelViewInverse != null) {
            this.modelViewInverse.method_1250(modelView.invert(this.tempMatrix4f));
        }
        if (this.normalMat > -1) {
            this.tempF = modelView.invert(this.tempMatrix4f).transpose3x3(this.normalMatrix).get(this.tempF);
            IrisRenderSystem.uniformMatrix3fv(this.normalMat, false, this.tempF);
        }
        if (this.projectionInverse != null) {
            this.projectionInverse.method_1250(projection.invert(this.tempMatrix4f));
        }
        if (this.intensitySwizzle) {
            IrisRenderSystem.addUnswizzle(RenderSystem.getShaderTexture((int)0).iris$getGlId());
            IrisRenderSystem.texParameteriv(RenderSystem.getShaderTexture((int)0).iris$getGlId(), TextureType.TEXTURE_2D.getGlType(), 36422, new int[]{6403, 6403, 6403, 6403});
        }
        ImmediateState.usingTessellation = this.usesTessellation;
        this.uploadIfNotNull(this.projectionInverse);
        this.uploadIfNotNull(this.modelViewInverse);
        this.samplers.update();
        this.uniforms.update();
        List uniformList = this.field_29490;
        for (class_284 uniform : uniformList) {
            this.uploadIfNotNull(uniform);
        }
        this.customUniforms.push((Object)this);
        this.images.update();
        BlendModeOverride.restore();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.hasOverrides) {
            this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    @Nullable
    public class_284 method_34582(@NotNull String name) {
        class_284 uniform = super.method_34582("iris_" + name);
        if (uniform == null && (name.equalsIgnoreCase("OverlayUV") || name.equalsIgnoreCase("LightUV"))) {
            return null;
        }
        return uniform;
    }

    public List<class_284> method_68406() {
        return super.method_68406();
    }

    public void method_62900(List<RenderPipeline.UniformDescription> list, List<String> list2) {
        RenderSystem.assertOnRenderThread();
        for (RenderPipeline.UniformDescription uniformDescription : list) {
            String string = uniformDescription.name();
            int i = class_284.method_22096((int)this.method_1270(), (CharSequence)string);
            if (i == -1) continue;
            class_284 uniform = this.method_67880(uniformDescription);
            uniform.method_1297(i);
            this.field_29490.add(uniform);
            this.field_53841.put(string, uniform);
        }
        for (String string2 : list2) {
            int j = class_284.method_22096((int)this.method_1270(), (CharSequence)string2);
            if (j == -1) continue;
            this.field_53838.add(string2);
            this.field_53840.add(j);
        }
        this.field_29470 = super.method_34582("iris_ModelViewMat");
        this.field_29471 = super.method_34582("iris_ProjMat");
        this.field_29472 = super.method_34582("iris_TextureMat");
        this.field_29473 = super.method_34582("iris_ScreenSize");
        this.field_29474 = super.method_34582("iris_ColorModulator");
        this.field_29475 = super.method_34582("iris_Light0_Direction");
        this.field_29476 = super.method_34582("iris_Light1_Direction");
        this.field_42231 = super.method_34582("iris_GlintAlpha");
        this.field_29477 = super.method_34582("iris_FogStart");
        this.field_29478 = super.method_34582("iris_FogEnd");
        this.field_29479 = super.method_34582("iris_FogColor");
        this.field_36373 = super.method_34582("iris_FogShape");
        this.field_29480 = super.method_34582("iris_LineWidth");
        this.field_29481 = super.method_34582("iris_GameTime");
        this.field_53139 = super.method_34582("iris_ModelOffset");
    }

    private void uploadIfNotNull(class_284 uniform) {
        if (uniform != null) {
            uniform.method_1300();
        }
    }

    public boolean hasActiveImages() {
        return this.images.getActiveImages() > 0;
    }

    static {
        LOGGER = LogUtils.getLogger();
        identity = new Matrix4f();
        identity.identity();
    }
}

