/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.compat;

import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.compat.CompatLayer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.slf4j.Logger;

final class CuriosCompat
implements CompatLayer {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MethodHandle curios$getCuriosInventory;
    private final MethodHandle curios$ICuriosItemHandler$getCurios;
    private final MethodHandle curios$ICurioStacksHandler$getStacks;
    private final MethodHandle curios$IDynamicStackHandler$getSlots;
    private final MethodHandle curios$IDynamicStackHandler$getStackInSlot;
    private boolean firstError = true;

    CuriosCompat() {
        Class<?> class$CuriosApi = CuriosCompat.getCuriosClass("CuriosApi");
        Class<?> class$ICuriosItemHandler = CuriosCompat.getCuriosClass("type.capability.ICuriosItemHandler");
        Class<?> class$ICurioStacksHandler = CuriosCompat.getCuriosClass("type.inventory.ICurioStacksHandler");
        Class<?> class$IDynamicStackHandler = CuriosCompat.getCuriosClass("type.inventory.IDynamicStackHandler");
        try {
            this.curios$getCuriosInventory = LOOKUP.findStatic(class$CuriosApi, "getCuriosInventory", MethodType.methodType(Optional.class, class_1309.class));
            this.curios$ICuriosItemHandler$getCurios = LOOKUP.findVirtual(class$ICuriosItemHandler, "getCurios", MethodType.methodType(Map.class));
            this.curios$ICurioStacksHandler$getStacks = LOOKUP.findVirtual(class$ICurioStacksHandler, "getStacks", MethodType.methodType(class$IDynamicStackHandler));
            this.curios$IDynamicStackHandler$getSlots = LOOKUP.findVirtual(class$IDynamicStackHandler, "getSlots", MethodType.methodType(Integer.TYPE));
            this.curios$IDynamicStackHandler$getStackInSlot = LOOKUP.findVirtual(class$IDynamicStackHandler, "getStackInSlot", MethodType.methodType(class_1799.class, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Cannot access Curios methods.", e);
        }
    }

    @Override
    public int getLivingEntityLuminanceFromItems(ItemLightSourceManager itemLightSources, class_1309 entity, boolean submergedInWater) {
        int luminance;
        block5: {
            luminance = 0;
            try {
                Optional component = this.curios$getCuriosInventory.invokeExact(entity);
                if (component.isPresent()) {
                    for (Object stacksHandler : this.curios$ICuriosItemHandler$getCurios.invoke(component.get()).values()) {
                        Object stacks = this.curios$ICurioStacksHandler$getStacks.invoke(stacksHandler);
                        int slots = this.curios$IDynamicStackHandler$getSlots.invoke(stacks);
                        for (int i = 0; i < slots && (luminance = Math.max(luminance, itemLightSources.getLuminance(this.curios$IDynamicStackHandler$getStackInSlot.invoke(stacks, i), submergedInWater))) < 15; ++i) {
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!this.firstError) break block5;
                LambDynLights.error(LOGGER, "Could not get luminance from curios. This error may repeat but won't be logged again to avoid clogging the log output.", e);
                this.firstError = false;
            }
        }
        return luminance;
    }

    private static Class<?> getCuriosClass(String name) {
        try {
            return Class.forName("top.theillusivec4.curios.api." + name);
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Could not find curios class " + name + ".", e);
        }
    }
}

