/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceNamedTextFieldWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class SpruceDoubleInputOption
extends SpruceOption {
    private final Supplier<Double> getter;
    private final Consumer<Double> setter;

    public SpruceDoubleInputOption(String key, Supplier<Double> getter, Consumer<Double> setter, @Nullable class_2561 tooltip) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.DOUBLE_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            try {
                Double.parseDouble(textField.getText());
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360);
            }
            catch (NumberFormatException e) {
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
            }
        });
        textField.setChangedListener(input -> {
            double value;
            try {
                value = Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                value = 0.0;
            }
            this.set(value);
        });
        this.getOptionTooltip().ifPresent(textField::setTooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(double value) {
        this.setter.accept(value);
    }

    public double get() {
        return this.getter.get();
    }
}

