/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.util;

import com.google.common.collect.ImmutableList;
import dev.architectury.fluid.FluidStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.Internals;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_3611;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;

public final class EntryIngredients {
    private EntryIngredients() {
    }

    public static EntryIngredient of(class_1935 stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(class_1935 stack, int amount) {
        return EntryIngredient.of(EntryStacks.of(stack, amount));
    }

    public static EntryIngredient of(class_1799 stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(class_3611 fluid) {
        return EntryIngredient.of(EntryStacks.of(fluid));
    }

    public static EntryIngredient of(class_3611 fluid, long amount) {
        return EntryIngredient.of(EntryStacks.of(fluid, amount));
    }

    public static EntryIngredient of(FluidStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient ofFluidHolder(class_6880<class_3611> fluid) {
        return EntryIngredient.of(EntryStacks.ofFluidHolder(fluid));
    }

    public static EntryIngredient ofFluidHolder(class_6880<class_3611> fluid, long amount) {
        return EntryIngredient.of(EntryStacks.ofFluidHolder(fluid, amount));
    }

    public static EntryIngredient ofItemHolder(class_6880<? extends class_1935> item) {
        return EntryIngredient.of(EntryStacks.ofItemHolder(item));
    }

    public static EntryIngredient ofItemHolder(class_6880<? extends class_1935> item, int amount) {
        return EntryIngredient.of(EntryStacks.ofItemHolder(item, amount));
    }

    public static <T> EntryIngredient of(EntryType<T> type, Collection<T> values) {
        return EntryIngredients.of(type.getDefinition(), values);
    }

    public static <T> EntryIngredient of(EntryDefinition<T> definition, Collection<T> values) {
        if (values.size() == 0) {
            return EntryIngredient.empty();
        }
        if (values.size() == 1) {
            return EntryIngredient.of(EntryStack.of(definition, values.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(values.size());
        for (T value : values) {
            result.add((EntryStack<?>)EntryStack.of(definition, value));
        }
        return result.build();
    }

    public static <T> EntryIngredient from(Iterable<T> stacks, Function<T, ? extends EntryStack<?>> function) {
        if (stacks instanceof Collection) {
            Collection collection = (Collection)stacks;
            return EntryIngredients.from(collection, collection.size(), function);
        }
        if (!stacks.iterator().hasNext()) {
            return EntryIngredient.empty();
        }
        EntryIngredient.Builder result = EntryIngredient.builder();
        for (T t : stacks) {
            EntryStack<?> stack = function.apply(t);
            if (stack.isEmpty()) continue;
            result.add(stack);
        }
        return result.build();
    }

    public static <T> EntryIngredient from(Iterable<T> stacks, int size, Function<T, ? extends EntryStack<?>> function) {
        if (size == 0) {
            return EntryIngredient.empty();
        }
        if (size == 1) {
            return EntryIngredient.of(function.apply(stacks.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(size);
        for (T t : stacks) {
            EntryStack<?> stack = function.apply(t);
            if (stack.isEmpty()) continue;
            result.add(stack);
        }
        return result.build();
    }

    public static EntryIngredient ofItems(Collection<class_1935> stacks) {
        return EntryIngredients.ofItems(stacks, 1);
    }

    public static EntryIngredient ofItems(Collection<class_1935> stacks, int amount) {
        return EntryIngredients.from(stacks, stack -> EntryStacks.of(stack, amount));
    }

    public static EntryIngredient ofItemStacks(Collection<class_1799> stacks) {
        return EntryIngredients.of(VanillaEntryTypes.ITEM, stacks);
    }

    public static EntryIngredient ofIngredient(class_1856 ingredient) {
        return EntryIngredients.ofItemsHolderSet((class_6885<class_1792>)ingredient.field_9019);
    }

    public static List<EntryIngredient> ofIngredients(List<class_1856> ingredients) {
        if (ingredients.size() == 0) {
            return Collections.emptyList();
        }
        if (ingredients.size() == 1) {
            class_1856 ingredient = ingredients.get(0);
            if (ingredient.field_9019.method_40247() == 0) {
                return List.of();
            }
            return List.of(EntryIngredients.ofIngredient(ingredient));
        }
        boolean emptyFlag = true;
        ArrayList<EntryIngredient> result = new ArrayList<EntryIngredient>(ingredients.size());
        for (int i = ingredients.size() - 1; i >= 0; --i) {
            class_1856 ingredient = ingredients.get(i);
            if (emptyFlag && ingredient.field_9019.method_40247() == 0) continue;
            result.add(0, EntryIngredients.ofIngredient(ingredient));
            emptyFlag = false;
        }
        return ImmutableList.copyOf(result);
    }

    public static <S, T> EntryIngredient ofTag(class_7871.class_7872 provider, class_6862<S> tagKey, Function<class_6880<S>, EntryStack<T>> mapper) {
        class_7871 getter = provider.method_46751(tagKey.comp_326());
        class_6885.class_6888 holders = getter.method_46733(tagKey).orElse(null);
        if (holders == null) {
            return EntryIngredient.empty();
        }
        return EntryIngredients.from(holders, holders.method_40247(), mapper);
    }

    public static <S, T> List<EntryIngredient> ofTags(class_7871.class_7872 provider, Iterable<class_6862<S>> tagKeys, Function<class_6880<S>, EntryStack<T>> mapper) {
        Collection collection;
        if (tagKeys instanceof Collection && (collection = (Collection)tagKeys).isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (class_6862<S> tagKey : tagKeys) {
            ingredients.add((Object)EntryIngredients.ofTag(provider, tagKey, mapper));
        }
        return ingredients.build();
    }

    public static <T extends class_1935> EntryIngredient ofItemTag(class_6862<T> tagKey) {
        return EntryIngredients.ofTag((class_7871.class_7872)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofItemHolder);
    }

    public static EntryIngredient ofFluidTag(class_6862<class_3611> tagKey) {
        return EntryIngredients.ofTag((class_7871.class_7872)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofFluidHolder);
    }

    public static <T extends class_1935> List<EntryIngredient> ofItemTags(Iterable<class_6862<T>> tagKey) {
        return EntryIngredients.ofTags((class_7871.class_7872)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofItemHolder);
    }

    public static List<EntryIngredient> ofFluidTags(Iterable<class_6862<class_3611>> tagKey) {
        return EntryIngredients.ofTags((class_7871.class_7872)BasicDisplay.registryAccess(), tagKey, EntryStacks::ofFluidHolder);
    }

    public static EntryIngredient ofItemsHolderSet(class_6885<class_1792> stacks) {
        return (EntryIngredient)stacks.method_40248().map(EntryIngredients::ofItemTag, holders -> EntryIngredients.from(holders, EntryStacks::ofItemHolder));
    }

    public static EntryIngredient ofFluidHolderSet(class_6885<class_3611> stacks) {
        return (EntryIngredient)stacks.method_40248().map(EntryIngredients::ofFluidTag, holders -> EntryIngredients.from(holders, EntryStacks::ofFluidHolder));
    }

    public static EntryIngredient ofSlotDisplay(class_10302 slot) {
        class_10302 class_103022 = slot;
        Objects.requireNonNull(class_103022);
        class_10302 class_103023 = class_103022;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_10302.class_10305.class, class_10302.class_10306.class, class_10302.class_10307.class, class_10302.class_10311.class, class_10302.class_10304.class, class_10302.class_10303.class}, (Object)class_103023, n)) {
            case 0 -> {
                EntryIngredient var3_4;
                class_10302.class_10305 $ = (class_10302.class_10305)class_103023;
                yield var3_4 = EntryIngredient.empty();
            }
            case 1 -> {
                EntryIngredient var3_5;
                class_10302.class_10306 s = (class_10302.class_10306)class_103023;
                yield var3_5 = EntryIngredients.ofItemHolder((class_6880<? extends class_1935>)s.comp_3273());
            }
            case 2 -> {
                EntryIngredient var3_6;
                class_10302.class_10307 s = (class_10302.class_10307)class_103023;
                yield var3_6 = EntryIngredients.of(s.comp_3274());
            }
            case 3 -> {
                EntryIngredient var3_7;
                class_10302.class_10311 s = (class_10302.class_10311)class_103023;
                yield var3_7 = EntryIngredients.ofItemTag(s.comp_3275());
            }
            case 4 -> {
                EntryIngredient var3_8;
                class_10302.class_10304 s = (class_10302.class_10304)class_103023;
                EntryIngredient.Builder builder = EntryIngredient.builder();
                for (class_10302 slotDisplay : s.comp_3272()) {
                    builder.addAll(EntryIngredients.ofSlotDisplay(slotDisplay));
                }
                yield var3_8 = builder.build();
            }
            case 5 -> {
                EntryIngredient var3_9;
                class_10302.class_10303 s = (class_10302.class_10303)class_103023;
                yield var3_9 = EntryIngredient.empty();
            }
            default -> {
                class_5455 access = Internals.getRegistryAccess();
                try {
                    EntryIngredient var3_10;
                    yield var3_10 = EntryIngredients.ofItemStacks(slot.method_64738(new class_10352.class_10353().method_64970(class_10363.field_54906, (Object)access).method_64971(class_10363.field_54907)));
                }
                catch (Exception e) {
                    EntryIngredient var3_11;
                    InternalLogger.getInstance().warn("Failed to resolve slot display: " + String.valueOf(slot), e);
                    yield var3_11 = EntryIngredient.empty();
                }
            }
        };
    }

    public static List<EntryIngredient> ofSlotDisplays(Iterable<class_10302> slots) {
        Collection collection;
        if (slots instanceof Collection && (collection = (Collection)slots).isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (class_10302 slot : slots) {
            ingredients.add((Object)EntryIngredients.ofSlotDisplay(slot));
        }
        return ingredients.build();
    }

    public static <T> boolean testFuzzy(EntryIngredient ingredient, EntryStack<T> stack) {
        for (EntryStack ingredientStack : ingredient) {
            if (!EntryStacks.equalsFuzzy(ingredientStack, stack)) continue;
            return true;
        }
        return false;
    }
}

