/*
 * Decompiled with CFR 0.152.
 */
package io.socol.bundleinventory.integration.cloth;

import io.socol.bundleinventory.config.BundleInventoryConfig;
import io.socol.bundleinventory.config.BundleInventoryDefaultConfig;
import java.util.function.Function;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_437;

@Config(name="bundleinventory")
@Environment(value=EnvType.CLIENT)
public class BundleInventoryClothConfig
implements ConfigData,
BundleInventoryConfig {
    @Comment(value="How many rows will be visible in Bundle inventory")
    @ConfigEntry.BoundedDiscrete(min=3L, max=8L)
    int bundleInventoryVisibleRows = BundleInventoryDefaultConfig.INSTANCE.bundleInventoryVisibleRows();
    @Comment(value="Should play sounds when player is interacting with Bundle via inventory")
    boolean shouldPlayBundleInventorySounds = BundleInventoryDefaultConfig.INSTANCE.shouldPlayBundleInventorySounds();
    @Comment(value="Should highlight open Bundle by rendering it differently")
    boolean indicateOpenBundle = BundleInventoryDefaultConfig.INSTANCE.indicateOpenBundle();
    @Comment(value="Show armor & second hand slots in Bundle inventory")
    boolean showEquipmentSlotsInBundleInventory = BundleInventoryDefaultConfig.INSTANCE.showEquipmentSlotsInBundleInventory();

    public static BundleInventoryConfig create() {
        AutoConfig.register(BundleInventoryClothConfig.class, JanksonConfigSerializer::new);
        return (BundleInventoryConfig)AutoConfig.getConfigHolder(BundleInventoryClothConfig.class).getConfig();
    }

    @Override
    public Function<class_437, class_437> getScreenFactory() {
        return parent -> (class_437)AutoConfig.getConfigScreen(BundleInventoryClothConfig.class, (class_437)parent).get();
    }

    @Override
    public int bundleInventoryVisibleRows() {
        return this.bundleInventoryVisibleRows;
    }

    @Override
    public boolean shouldPlayBundleInventorySounds() {
        return this.shouldPlayBundleInventorySounds;
    }

    @Override
    public boolean indicateOpenBundle() {
        return this.indicateOpenBundle;
    }

    @Override
    public boolean showEquipmentSlotsInBundleInventory() {
        return this.showEquipmentSlotsInBundleInventory;
    }
}

