/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.compat.sodium.mixin.CloudRendererAccessor;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderAccess;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.pipeline.programs.ShaderOverrides;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.class_10142;
import net.minecraft.class_10151;
import net.minecraft.class_10156;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_10151.class})
public abstract class MixinShaderManager_Overrides {
    private static final Function<IrisRenderingPipeline, ShaderKey> FAKE_FUNCTION = p -> null;
    @Unique
    private static final Map<class_10156, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMap = new Object2ObjectArrayMap();
    private static final Map<class_10156, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMapShadow = new Object2ObjectArrayMap();
    private Set<class_10156> missingShaders = new HashSet<class_10156>();

    @Shadow
    @Nullable
    public abstract class_5944 method_62947(class_10156 var1);

    private static ShaderKey getCutout(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY_DIFFUSE;
        }
        return ShaderKey.ENTITIES_CUTOUT_DIFFUSE;
    }

    private static ShaderKey getSolid(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT : ShaderKey.HAND_TRANSLUCENT;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_SOLID;
    }

    private static ShaderKey getTranslucent(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_TRANSLUCENT;
    }

    @Inject(method={"method_62947(Lnet/minecraft/class_10156;)Lnet/minecraft/class_5944;"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectIrisProgram(class_10156 shaderProgram, CallbackInfoReturnable<class_5944> cir) {
        IrisRenderingPipeline irisPipeline;
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof IrisRenderingPipeline && (irisPipeline = (IrisRenderingPipeline)pipeline).shouldOverrideShaders()) {
            class_10156 newProgram = shaderProgram;
            if (newProgram == ShaderAccess.MEKANISM_FLAME) {
                class_5944 result = irisPipeline.getShaderMap().getShader(ShadowRenderingState.areShadowsCurrentlyBeingRendered() ? ShaderKey.MEKANISM_FLAME_SHADOW : ShaderKey.MEKANISM_FLAME);
                if (result != null) {
                    cir.setReturnValue((Object)result);
                }
            } else if (shaderProgram == ShaderAccess.MEKASUIT) {
                newProgram = class_10142.field_53888;
            }
            class_5944 program = MixinShaderManager_Overrides.override(irisPipeline, newProgram);
            if (program != null) {
                cir.setReturnValue((Object)program);
            } else if (this.missingShaders.add(shaderProgram)) {
                Iris.logger.error("Missing program " + String.valueOf(shaderProgram.comp_3113()) + " in override list. This is not a critical problem, but it could lead to weird rendering.", new Throwable());
            }
        } else if (shaderProgram == ShaderAccess.MEKANISM_FLAME) {
            cir.setReturnValue((Object)this.method_62947(class_10142.field_53880));
        } else if (shaderProgram == ShaderAccess.MEKASUIT) {
            cir.setReturnValue((Object)this.method_62947(class_10142.field_53888));
        } else if (shaderProgram != ShaderAccess.IE_COMPAT) {
            if (shaderProgram == ShaderAccess.TRANSLUCENT_PARTICLE_SHADER) {
                cir.setReturnValue((Object)this.method_62947(class_10142.field_53874));
            } else if (shaderProgram == ShaderAccess.WEATHER_SHADER) {
                cir.setReturnValue((Object)this.method_62947(class_10142.field_53874));
            }
        }
    }

    private static class_5944 override(IrisRenderingPipeline pipeline, class_10156 shaderProgram) {
        ShaderKey shaderKey = MixinShaderManager_Overrides.convertToShaderKey(pipeline, shaderProgram);
        return shaderKey == null ? null : pipeline.getShaderMap().getShader(shaderKey);
    }

    private static ShaderKey convertToShaderKey(IrisRenderingPipeline pipeline, class_10156 shaderProgram) {
        return ShadowRenderingState.areShadowsCurrentlyBeingRendered() ? (ShaderKey)((Object)coreShaderMapShadow.getOrDefault(shaderProgram, FAKE_FUNCTION).apply((Object)pipeline)) : (ShaderKey)((Object)coreShaderMap.getOrDefault(shaderProgram, FAKE_FUNCTION).apply((Object)pipeline));
    }

    static {
        coreShaderMap.put(class_10142.field_53875, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(class_10142.field_53879, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyTexShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(class_10142.field_53880, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyTexColorShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(class_10142.field_53876, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyColorShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(class_10142.field_53874, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES));
        coreShaderMap.put(ShaderAccess.TRANSLUCENT_PARTICLE_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES_TRANS));
        coreShaderMap.put(ShaderAccess.WEATHER_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.WEATHER));
        coreShaderMap.put(class_10142.field_53888, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(class_10142.field_53887, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getSolid(p)));
        coreShaderMap.put(class_10142.field_53886, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(class_10142.field_54960, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getTranslucent(p)));
        coreShaderMap.put(class_10142.field_53851, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(class_10142.field_53852, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(class_10142.field_53850, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(class_10142.field_53849, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(class_10142.field_53889, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(class_10142.field_53890, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(class_10142.field_53842, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(class_10142.field_53894, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(class_10142.field_53892, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(class_10142.field_53893, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES_TRANS));
        coreShaderMap.put(class_10142.field_53843, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_ALPHA));
        coreShaderMap.put(class_10142.field_53896, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_CUTOUT_DIFFUSE));
        coreShaderMap.put(class_10142.field_53891, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(class_10142.field_53881, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_SOLID));
        coreShaderMap.put(class_10142.field_53883, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_CUTOUT));
        coreShaderMap.put(class_10142.field_53882, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_CUTOUT));
        coreShaderMap.put(class_10142.field_53884, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_TRANSLUCENT));
        coreShaderMap.put(class_10142.field_53860, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_TRANSLUCENT));
        coreShaderMap.put(class_10142.field_53864, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LINES));
        coreShaderMap.put(class_10142.field_53854, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        coreShaderMap.put(class_10142.field_53857, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        coreShaderMap.put(class_10142.field_53853, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_BE : ShaderKey.TEXT));
        coreShaderMap.put(class_10142.field_53856, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_BE : ShaderKey.TEXT));
        coreShaderMap.put(class_10142.field_53855, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_INTENSITY_BE : ShaderKey.TEXT_INTENSITY));
        coreShaderMap.put(class_10142.field_53858, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_INTENSITY_BE : ShaderKey.TEXT_INTENSITY));
        coreShaderMap.put(class_10142.field_53844, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES));
        coreShaderMap.put(class_10142.field_53897, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(class_10142.field_53871, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(class_10142.field_53845, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_CUTOUT));
        coreShaderMap.put(class_10142.field_53895, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BEACON));
        coreShaderMap.put(class_10142.field_53859, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        coreShaderMap.put(class_10142.field_53861, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getCutout));
        coreShaderMap.put(class_10142.field_53862, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getCutout));
        coreShaderMap.put(class_10142.field_53846, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LEASH));
        coreShaderMap.put(class_10142.field_53847, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_SOLID));
        coreShaderMap.put(class_10142.field_53863, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS));
        coreShaderMap.put(class_10142.field_53865, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CRUMBLING));
        coreShaderMap.put(CloudRendererAccessor.getCLOUDS_SHADER(), (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS_SODIUM));
        coreShaderMap.put(class_10142.field_53885, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.MOVING_BLOCK));
        coreShaderMapShadow.put(class_10142.field_53875, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC));
        coreShaderMapShadow.put(class_10142.field_53879, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEX));
        coreShaderMapShadow.put(class_10142.field_53880, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEX_COLOR));
        coreShaderMapShadow.put(class_10142.field_53876, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC_COLOR));
        coreShaderMapShadow.put(class_10142.field_53874, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        coreShaderMapShadow.put(ShaderAccess.TRANSLUCENT_PARTICLE_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        coreShaderMapShadow.put(ShaderAccess.WEATHER_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        coreShaderMapShadow.put(class_10142.field_53888, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53887, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53886, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53851, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53852, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53850, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53849, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53889, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53890, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53894, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53842, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53892, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53893, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53896, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53843, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53891, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53881, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53883, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53882, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53884, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.SHADOW_ENTITIES_CUTOUT : ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53860, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_54960, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53864, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LINES));
        coreShaderMapShadow.put(class_10142.field_53854, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        coreShaderMapShadow.put(class_10142.field_53857, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        coreShaderMapShadow.put(class_10142.field_53853, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        coreShaderMapShadow.put(class_10142.field_53856, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        coreShaderMapShadow.put(class_10142.field_53855, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        coreShaderMapShadow.put(class_10142.field_53858, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        coreShaderMapShadow.put(class_10142.field_53844, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53897, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53871, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53845, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53895, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BEACON_BEAM));
        coreShaderMapShadow.put(class_10142.field_53859, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LIGHTNING));
        coreShaderMapShadow.put(class_10142.field_53861, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53862, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53846, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LEASH));
        coreShaderMapShadow.put(class_10142.field_53847, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(class_10142.field_53863, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_CLOUDS));
        coreShaderMapShadow.put(class_10142.field_53865, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC));
        coreShaderMapShadow.put(CloudRendererAccessor.getCLOUDS_SHADER(), (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_CLOUDS));
        coreShaderMapShadow.put(class_10142.field_53885, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        for (class_10156 program : class_10142.method_62901()) {
            if (!coreShaderMap.containsKey(program) || coreShaderMapShadow.containsKey(program)) continue;
            throw new IllegalStateException("Shader program " + String.valueOf(program) + " is not accounted for in the shadow list");
        }
    }
}

