/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public final class ContiguousArrayList<T extends Structure>
implements List<T> {
    private final T[] array;

    public ContiguousArrayList(Class<T> structureClass, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The list must be at least of size 1");
        }
        Structure firstItem = Structure.newInstance(structureClass, (Pointer)Pointer.NULL);
        this.array = firstItem.toArray(size);
    }

    @Override
    public T get(int index) {
        return this.array[index];
    }

    public void autoWrite() {
        this.array[0].autoWrite();
    }

    public Pointer getPointer() {
        return this.array[0].getPointer();
    }

    public Pointer autoWriteAndGetPointer() {
        this.autoWrite();
        return this.getPointer();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.array.length, Object[].class);
    }

    @Override
    public <S> S[] toArray(S[] a) {
        int size = this.size();
        if (a.length < size) {
            return Arrays.copyOf(this.array, size, a.getClass());
        }
        System.arraycopy(this.array, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.array, 16);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        for (T e : this.array) {
            action.accept(e);
        }
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        T[] a = this.array;
        if (o == null) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (!o.equals(this.array[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private class Itr
    implements Iterator<T> {
        int cursor = 0;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ContiguousArrayList.this.size();
        }

        @Override
        public T next() {
            try {
                int i = this.cursor;
                Object next = ContiguousArrayList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<T> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public T previous() {
            try {
                int i = this.cursor - 1;
                Object previous = ContiguousArrayList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }
}

