/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.sdl3java.api.hidapi;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import dev.isxander.sdl3java.api.hidapi.SDL_hid_device;
import dev.isxander.sdl3java.api.hidapi.SDL_hid_device_info;
import dev.isxander.sdl3java.api.hidapi.SDL_hid_device_info_raw;
import dev.isxander.sdl3java.jna.JnaUtils;
import dev.isxander.sdl3java.jna.SdlNativeLibraryLoader;
import dev.isxander.sdl3java.jna.StringRef;
import dev.isxander.sdl3java.jna.size_t;
import java.util.ArrayList;
import java.util.List;

public final class SdlHidApi {
    private SdlHidApi() {
    }

    public static native int SDL_hid_init();

    public static native int SDL_hid_exit();

    public static native long SDL_hid_device_change_count();

    public static List<SDL_hid_device_info> SDL_hid_enumerate(int vendor_id, int product_id) {
        SDL_hid_device_info_raw rawStruct = InternalNativeFunctions.SDL_hid_enumerate(vendor_id, product_id);
        if (rawStruct == null) {
            return null;
        }
        Pointer pointer = rawStruct.getPointer();
        ArrayList<SDL_hid_device_info> list = new ArrayList<SDL_hid_device_info>();
        while (rawStruct != null) {
            SDL_hid_device_info info = rawStruct.toPublic();
            rawStruct = rawStruct.next;
            list.add(info);
        }
        InternalNativeFunctions.SDL_hid_free_enumeration(pointer);
        return list;
    }

    public static SDL_hid_device SDL_hid_open(int vendor_id, int product_id, String serial_number) {
        return InternalNativeFunctions.SDL_hid_open(vendor_id, product_id, new WString(serial_number));
    }

    public static native SDL_hid_device SDL_hid_open_path(String var0);

    public static int SDL_hid_write(SDL_hid_device dev, byte[] data) {
        try (Memory buffer = JnaUtils.writeArrayToNativeMemory(data);){
            int n = SdlHidApi.SDL_hid_write(dev, (Pointer)buffer, new size_t(data.length));
            return n;
        }
    }

    public static native int SDL_hid_write(SDL_hid_device var0, Pointer var1, size_t var2);

    public static int SDL_hid_read_timeout(SDL_hid_device dev, byte[] data, int milliseconds) {
        try (Memory buffer = new Memory((long)data.length);){
            int result = SdlHidApi.SDL_hid_read_timeout(dev, (Pointer)buffer, new size_t(data.length), milliseconds);
            buffer.read(0L, data, 0, data.length);
            int n = result;
            return n;
        }
    }

    public static native int SDL_hid_read_timeout(SDL_hid_device var0, Pointer var1, size_t var2, int var3);

    public static int SDL_hid_read(SDL_hid_device dev, byte[] data) {
        try (Memory buffer = new Memory((long)data.length);){
            int result = SdlHidApi.SDL_hid_read(dev, (Pointer)buffer, new size_t(buffer.size()));
            buffer.read(0L, data, 0, data.length);
            int n = result;
            return n;
        }
    }

    public static native int SDL_hid_read(SDL_hid_device var0, Pointer var1, size_t var2);

    public static native int SDL_hid_set_nonblocking(SDL_hid_device var0, int var1);

    public static int SDL_hid_send_feature_report(SDL_hid_device dev, byte[] data) {
        try (Memory buffer = JnaUtils.writeArrayToNativeMemory(data);){
            int n = SdlHidApi.SDL_hid_send_feature_report(dev, (Pointer)buffer, new size_t(buffer.size()));
            return n;
        }
    }

    public static native int SDL_hid_send_feature_report(SDL_hid_device var0, Pointer var1, size_t var2);

    public static int SDL_hid_get_feature_report(SDL_hid_device dev, byte[] data) {
        try (Memory buffer = new Memory((long)data.length);){
            int result = SdlHidApi.SDL_hid_get_feature_report(dev, (Pointer)buffer, new size_t(buffer.size()));
            buffer.read(0L, data, 0, data.length);
            int n = result;
            return n;
        }
    }

    public static native int SDL_hid_get_feature_report(SDL_hid_device var0, Pointer var1, size_t var2);

    public static native void SDL_hid_close(SDL_hid_device var0);

    public static int SDL_hid_get_manufacturer_string(SDL_hid_device dev, StringRef text, int maxlen) {
        try (Memory buffer = new Memory((long)maxlen * 2L);){
            int result = InternalNativeFunctions.SDL_hid_get_manufacturer_string(dev, (Pointer)buffer, new size_t(maxlen));
            text.setValue(buffer.getWideString(0L));
            int n = result;
            return n;
        }
    }

    public static int SDL_hid_get_product_string(SDL_hid_device dev, StringRef text, int maxlen) {
        try (Memory buffer = new Memory((long)maxlen * 2L);){
            int result = InternalNativeFunctions.SDL_hid_get_product_string(dev, (Pointer)buffer, new size_t(maxlen));
            text.setValue(buffer.getWideString(0L));
            int n = result;
            return n;
        }
    }

    public static int SDL_hid_get_serial_number_string(SDL_hid_device dev, StringRef text, int maxlen) {
        try (Memory buffer = new Memory((long)maxlen * 2L);){
            int result = InternalNativeFunctions.SDL_hid_get_serial_number_string(dev, (Pointer)buffer, new size_t(maxlen));
            text.setValue(buffer.getWideString(0L));
            int n = result;
            return n;
        }
    }

    public static int SDL_hid_get_indexed_string(SDL_hid_device dev, int stringIndex, StringRef text, int maxlen) {
        try (Memory buffer = new Memory((long)maxlen * 2L);){
            int result = InternalNativeFunctions.SDL_hid_get_indexed_string(dev, stringIndex, (Pointer)buffer, new size_t(maxlen));
            text.setValue(buffer.getWideString(0L));
            int n = result;
            return n;
        }
    }

    public static SDL_hid_device_info SDL_hid_get_device_info(SDL_hid_device dev) {
        SDL_hid_device_info_raw rawStruct = InternalNativeFunctions.SDL_hid_get_device_info(dev);
        return rawStruct.toPublic();
    }

    public static int SDL_hid_get_report_descriptor(SDL_hid_device dev, byte[] buffer) {
        try (Memory memory = new Memory((long)buffer.length);){
            int result = InternalNativeFunctions.SDL_hid_get_report_descriptor(dev, (Pointer)memory, new size_t(buffer.length));
            memory.read(0L, buffer, 0, buffer.length);
            int n = result;
            return n;
        }
    }

    public static native void SDL_hid_ble_scan(boolean var0);

    static {
        SdlNativeLibraryLoader.registerNativeMethods(SdlHidApi.class);
        SdlNativeLibraryLoader.registerNativeMethods(InternalNativeFunctions.class);
    }

    private static final class InternalNativeFunctions {
        private InternalNativeFunctions() {
        }

        public static native SDL_hid_device_info_raw SDL_hid_enumerate(int var0, int var1);

        public static native void SDL_hid_free_enumeration(Pointer var0);

        public static native SDL_hid_device SDL_hid_open(int var0, int var1, WString var2);

        public static native int SDL_hid_get_manufacturer_string(SDL_hid_device var0, Pointer var1, size_t var2);

        public static native int SDL_hid_get_product_string(SDL_hid_device var0, Pointer var1, size_t var2);

        public static native int SDL_hid_get_serial_number_string(SDL_hid_device var0, Pointer var1, size_t var2);

        public static native int SDL_hid_get_indexed_string(SDL_hid_device var0, int var1, Pointer var2, size_t var3);

        public static native SDL_hid_device_info_raw SDL_hid_get_device_info(SDL_hid_device var0);

        public static native int SDL_hid_get_report_descriptor(SDL_hid_device var0, Pointer var1, size_t var2);
    }
}

