/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginContextImpl;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_773;
import net.minecraft.class_7923;
import net.minecraft.class_9824;
import net.minecraft.class_9979;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModelLoadingEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoadingEventDispatcher.class);
    public static final ThreadLocal<ModelLoadingEventDispatcher> CURRENT = new ThreadLocal();
    private final ModelLoadingPluginContextImpl pluginContext;
    private final BlockStateResolverContext blockStateResolverContext = new BlockStateResolverContext();
    private final OnLoadModifierContext onLoadModifierContext = new OnLoadModifierContext();
    private final OnLoadBlockModifierContext onLoadBlockModifierContext = new OnLoadBlockModifierContext();

    public ModelLoadingEventDispatcher(List<ModelLoadingPlugin> plugins) {
        this.pluginContext = new ModelLoadingPluginContextImpl();
        for (ModelLoadingPlugin plugin : plugins) {
            try {
                plugin.initialize(this.pluginContext);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to initialize model loading plugin", (Throwable)exception);
            }
        }
    }

    public void forEachExtraModel(Consumer<class_2960> extraModelConsumer) {
        this.pluginContext.extraModels.forEach(extraModelConsumer);
    }

    @Nullable
    public class_1100 modifyModelOnLoad(@Nullable class_1100 model, class_2960 id) {
        this.onLoadModifierContext.prepare(id);
        return ((ModelModifier.OnLoad)this.pluginContext.modifyModelOnLoad().invoker()).modifyModelOnLoad(model, this.onLoadModifierContext);
    }

    public class_9824.class_10095 modifyBlockModelsOnLoad(class_9824.class_10095 models) {
        HashMap<class_1091, class_9824.class_9825> map = models.comp_3063();
        if (!(map instanceof HashMap)) {
            map = new HashMap<class_1091, class_9824.class_9825>(map);
            models = new class_9824.class_10095(map);
        }
        this.putResolvedBlockStates((Map<class_1091, class_9824.class_9825>)map);
        map.replaceAll((id, blockModel) -> {
            class_9979 modified;
            class_9979 original = blockModel.comp_2871();
            if (original != (modified = this.modifyBlockModelOnLoad(original, (class_1091)id, blockModel.comp_3062()))) {
                return new class_9824.class_9825(blockModel.comp_3062(), modified);
            }
            return blockModel;
        });
        return models;
    }

    private void putResolvedBlockStates(Map<class_1091, class_9824.class_9825> map) {
        this.pluginContext.blockStateResolvers.forEach((block, resolver) -> {
            Optional optionalKey = class_7923.field_41175.method_29113(block);
            if (optionalKey.isEmpty()) {
                return;
            }
            class_2960 blockId = ((class_5321)optionalKey.get()).method_29177();
            this.resolveBlockStates((BlockStateResolver)resolver, (class_2248)block, (state, model) -> {
                class_1091 modelId = class_773.method_3336((class_2960)blockId, (class_2680)state);
                map.put(modelId, new class_9824.class_9825(state, model));
            });
        });
    }

    private void resolveBlockStates(BlockStateResolver resolver, class_2248 block, BiConsumer<class_2680, class_9979> output) {
        BlockStateResolverContext context = this.blockStateResolverContext;
        context.prepare(block);
        Reference2ReferenceMap<class_2680, class_9979> resolvedModels = context.models;
        ImmutableList allStates = block.method_9595().method_11662();
        boolean thrown = false;
        try {
            resolver.resolveBlockStates(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve block state models for block {}. Using missing model for all states.", (Object)block, (Object)e);
            thrown = true;
        }
        if (!thrown) {
            if (resolvedModels.size() == allStates.size()) {
                resolvedModels.forEach(output);
            } else {
                for (class_2680 state : allStates) {
                    @Nullable class_9979 model = (class_9979)resolvedModels.get((Object)state);
                    if (model == null) {
                        LOGGER.error("Block state resolver did not provide a model for state {} in block {}. Using missing model.", (Object)state, (Object)block);
                        continue;
                    }
                    output.accept(state, model);
                }
            }
        }
        resolvedModels.clear();
    }

    private class_9979 modifyBlockModelOnLoad(class_9979 model, class_1091 id, class_2680 state) {
        this.onLoadBlockModifierContext.prepare(id, state);
        return ((ModelModifier.OnLoadBlock)this.pluginContext.modifyBlockModelOnLoad().invoker()).modifyModelOnLoad(model, this.onLoadBlockModifierContext);
    }

    @Environment(value=EnvType.CLIENT)
    private static class BlockStateResolverContext
    implements BlockStateResolver.Context {
        private class_2248 block;
        private final Reference2ReferenceMap<class_2680, class_9979> models = new Reference2ReferenceOpenHashMap();

        private BlockStateResolverContext() {
        }

        private void prepare(class_2248 block) {
            this.block = block;
            this.models.clear();
        }

        @Override
        public class_2248 block() {
            return this.block;
        }

        @Override
        public void setModel(class_2680 state, class_9979 model) {
            Objects.requireNonNull(model, "state cannot be null");
            Objects.requireNonNull(model, "model cannot be null");
            if (!state.method_27852(this.block)) {
                throw new IllegalArgumentException("Attempted to set model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
            if (this.models.putIfAbsent((Object)state, (Object)model) != null) {
                throw new IllegalStateException("Duplicate model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class OnLoadModifierContext
    implements ModelModifier.OnLoad.Context {
        private class_2960 id;

        private OnLoadModifierContext() {
        }

        private void prepare(class_2960 id) {
            this.id = id;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class OnLoadBlockModifierContext
    implements ModelModifier.OnLoadBlock.Context {
        private class_1091 id;
        private class_2680 state;

        private OnLoadBlockModifierContext() {
        }

        private void prepare(class_1091 id, class_2680 state) {
            this.id = id;
            this.state = state;
        }

        @Override
        public class_1091 id() {
            return this.id;
        }

        @Override
        public class_2680 state() {
            return this.state;
        }
    }
}

