/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_3414;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6005;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public interface BiomeModificationContext {
    public WeatherContext getWeather();

    public EffectsContext getEffects();

    public GenerationSettingsContext getGenerationSettings();

    public SpawnSettingsContext getSpawnSettings();

    public static interface SpawnSettingsContext {
        public void setCreatureSpawnProbability(float var1);

        public void addSpawn(class_1311 var1, class_5483.class_1964 var2);

        public boolean removeSpawns(BiPredicate<class_1311, class_5483.class_1964> var1);

        default public boolean removeSpawnsOfEntityType(class_1299<?> entityType) {
            return this.removeSpawns((spawnGroup, spawnEntry) -> spawnEntry.field_9389 == entityType);
        }

        default public void clearSpawns(class_1311 group) {
            this.removeSpawns((spawnGroup, spawnEntry) -> spawnGroup == group);
        }

        default public void clearSpawns() {
            this.removeSpawns((spawnGroup, spawnEntry) -> true);
        }

        public void setSpawnCost(class_1299<?> var1, double var2, double var4);

        public void clearSpawnCost(class_1299<?> var1);
    }

    public static interface GenerationSettingsContext {
        public boolean removeFeature(class_2893.class_2895 var1, class_5321<class_6796> var2);

        default public boolean removeFeature(class_5321<class_6796> placedFeatureKey) {
            boolean anyFound = false;
            for (class_2893.class_2895 step : class_2893.class_2895.values()) {
                if (!this.removeFeature(step, placedFeatureKey)) continue;
                anyFound = true;
            }
            return anyFound;
        }

        public void addFeature(class_2893.class_2895 var1, class_5321<class_6796> var2);

        public void addCarver(class_5321<class_2922<?>> var1);

        public boolean removeCarver(class_5321<class_2922<?>> var1);
    }

    public static interface EffectsContext {
        public void setFogColor(int var1);

        public void setWaterColor(int var1);

        public void setWaterFogColor(int var1);

        public void setSkyColor(int var1);

        public void setFoliageColor(Optional<Integer> var1);

        default public void setFoliageColor(int color) {
            this.setFoliageColor(Optional.of(color));
        }

        default public void setFoliageColor(OptionalInt color) {
            color.ifPresentOrElse(this::setFoliageColor, this::clearFoliageColor);
        }

        default public void clearFoliageColor() {
            this.setFoliageColor(Optional.empty());
        }

        public void setGrassColor(Optional<Integer> var1);

        default public void setGrassColor(int color) {
            this.setGrassColor(Optional.of(color));
        }

        default public void setGrassColor(OptionalInt color) {
            color.ifPresentOrElse(this::setGrassColor, this::clearGrassColor);
        }

        default public void clearGrassColor() {
            this.setGrassColor(Optional.empty());
        }

        public void setGrassColorModifier(@NotNull class_4763.class_5486 var1);

        public void setParticleConfig(Optional<class_4761> var1);

        default public void setParticleConfig(@NotNull class_4761 particleConfig) {
            this.setParticleConfig(Optional.of(particleConfig));
        }

        default public void clearParticleConfig() {
            this.setParticleConfig(Optional.empty());
        }

        public void setAmbientSound(Optional<class_6880<class_3414>> var1);

        default public void setAmbientSound(@NotNull class_6880<class_3414> sound) {
            this.setAmbientSound(Optional.of(sound));
        }

        default public void clearAmbientSound() {
            this.setAmbientSound(Optional.empty());
        }

        public void setMoodSound(Optional<class_4968> var1);

        default public void setMoodSound(@NotNull class_4968 sound) {
            this.setMoodSound(Optional.of(sound));
        }

        default public void clearMoodSound() {
            this.setMoodSound(Optional.empty());
        }

        public void setAdditionsSound(Optional<class_4967> var1);

        default public void setAdditionsSound(@NotNull class_4967 sound) {
            this.setAdditionsSound(Optional.of(sound));
        }

        default public void clearAdditionsSound() {
            this.setAdditionsSound(Optional.empty());
        }

        public void setMusic(Optional<class_6005<class_5195>> var1);

        default public void setMusic(@NotNull class_6005<class_5195> sound) {
            this.setMusic(Optional.of(sound));
        }

        default public void setMusic(@NotNull class_5195 sound) {
            this.setMusic((class_6005<class_5195>)class_6005.method_38061((Object)sound));
        }

        default public void clearMusic() {
            this.setMusic(Optional.empty());
        }

        public void setMusicVolume(float var1);
    }

    public static interface WeatherContext {
        public void setPrecipitation(boolean var1);

        public void setTemperature(float var1);

        public void setTemperatureModifier(class_1959.class_5484 var1);

        public void setDownfall(float var1);
    }
}

