/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tag;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.impl.tag.SimpleRegistryExtension;
import net.fabricmc.fabric.impl.tag.TagAliasEnabledRegistryWrapper;
import net.fabricmc.fabric.impl.tag.TagAliasGroup;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_7780;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TagAliasLoader
extends class_4080<Map<class_5321<? extends class_2378<?>>, List<Data>>>
implements IdentifiableResourceReloadListener {
    public static final class_2960 ID = class_2960.method_60655((String)"fabric-tag-api-v1", (String)"tag_alias_groups");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-tag-api-v1");
    private final class_7225.class_7874 registries;

    public TagAliasLoader(class_7225.class_7874 registries) {
        this.registries = registries;
    }

    public class_2960 getFabricId() {
        return ID;
    }

    /*
     * Loose catch block
     */
    protected Map<class_5321<? extends class_2378<?>>, List<Data>> prepare(class_3300 manager, class_3695 profiler) {
        HashMap dataByRegistry = new HashMap();
        Iterator registryIterator = this.registries.method_55282().iterator();
        while (registryIterator.hasNext()) {
            class_5321 registryKey = (class_5321)registryIterator.next();
            class_7654 resourceFinder = class_7654.method_45114((String)TagAliasLoader.getDirectory(registryKey));
            for (Map.Entry entry : resourceFinder.method_45113(manager).entrySet()) {
                class_2960 resourcePath = (class_2960)entry.getKey();
                class_2960 groupId = resourceFinder.method_45115(resourcePath);
                try {
                    BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                    try {
                        DataResult dataResult;
                        JsonElement json = JsonParser.parseReader((Reader)reader);
                        Codec codec = TagAliasGroup.codec(registryKey);
                        Objects.requireNonNull(codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json));
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                TagAliasGroup tagAliasGroup;
                                DataResult.Success success = (DataResult.Success)dataResult;
                                TagAliasGroup group = tagAliasGroup = (TagAliasGroup)success.value();
                                TagAliasGroup unused = tagAliasGroup = success.lifecycle();
                                Data data = new Data(groupId, group);
                                dataByRegistry.computeIfAbsent(registryKey, key -> new ArrayList()).add(data);
                                break;
                            }
                            case 1: {
                                DataResult.Error error = (DataResult.Error)dataResult;
                                LOGGER.error("[Fabric] Couldn't parse tag alias group file '{}' from '{}': {}", new Object[]{groupId, resourcePath, error.message()});
                                break;
                            }
                        }
                        continue;
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("[Fabric] Couldn't parse tag alias group file '{}' from '{}'", new Object[]{groupId, resourcePath, e});
                }
            }
        }
        return dataByRegistry;
    }

    private static String getDirectory(class_5321<? extends class_2378<?>> registryKey) {
        Object directory = "fabric/tag_alias/";
        class_2960 registryId = registryKey.method_29177();
        if (!"minecraft".equals(registryId.method_12836())) {
            directory = (String)directory + registryId.method_12836() + "/";
        }
        return (String)directory + registryId.method_12832();
    }

    protected void apply(Map<class_5321<? extends class_2378<?>>, List<Data>> prepared, class_3300 manager, class_3695 profiler) {
        for (Map.Entry<class_5321<class_2378<?>>, List<Data>> entry : prepared.entrySet()) {
            HashMap groupsByTag = new HashMap();
            for (Data data : entry.getValue()) {
                HashSet group = new HashSet(data.group.tags());
                for (class_6862<?> tag : data.group.tags()) {
                    Set oldGroup = (Set)groupsByTag.get(tag);
                    if (oldGroup != null) {
                        group.addAll(oldGroup);
                        for (class_6862 other : oldGroup) {
                            groupsByTag.put(other, group);
                        }
                    }
                    groupsByTag.put(tag, group);
                }
            }
            groupsByTag.values().removeIf(tags -> tags.size() == 1);
            class_7225.class_7226 wrapper = this.registries.method_46762(entry.getKey());
            if (wrapper instanceof TagAliasEnabledRegistryWrapper) {
                TagAliasEnabledRegistryWrapper aliasWrapper = (TagAliasEnabledRegistryWrapper)wrapper;
                aliasWrapper.fabric_loadTagAliases(groupsByTag);
                continue;
            }
            throw new ClassCastException("[Fabric] Couldn't apply tag aliases to registry wrapper %s (%s) since it doesn't implement TagAliasEnabledRegistryWrapper".formatted(wrapper, entry.getKey().method_29177()));
        }
    }

    public static <T> void applyToDynamicRegistries(class_7780<T> registries, T phase) {
        Iterator registryEntries = registries.method_45928(phase).method_40311().iterator();
        while (registryEntries.hasNext()) {
            class_2378 registry = ((class_5455.class_6892)registryEntries.next()).comp_351();
            if (registry instanceof SimpleRegistryExtension) {
                SimpleRegistryExtension extension = (SimpleRegistryExtension)registry;
                extension.fabric_applyPendingTagAliases();
                extension.fabric_refreshTags();
                continue;
            }
            throw new ClassCastException("[Fabric] Couldn't apply pending tag aliases to registry %s (%s) since it doesn't implement SimpleRegistryExtension".formatted(registry, registry.getClass().getName()));
        }
    }

    protected record Data(class_2960 groupId, TagAliasGroup<?> group) {
    }
}

