/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.api;

import java.util.List;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ErrorProvider {
    public List<ErrorComponent> errors();

    public record ErrorComponent(MessageComponent message, @Nullable String url) {
        public ErrorComponent(MessageComponent message) {
            this(message, null);
        }

        public ErrorComponent withUrl(@Nullable String url) {
            return new ErrorComponent(this.message, url);
        }
    }

    public static interface MessageComponent {
        public String getMessage();

        public static MessageComponent of(String message) {
            return () -> message;
        }

        public static MessageComponent of(String message, Object ... args) {
            return () -> String.format(message, args);
        }
    }
}

